/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.symbol.Constant;

public class TestConstant {
    public static final Constant sample1() {
        String s = "the string";
        return new Constant((Object)s);
    }

    public static final Constant sample2() {
        Integer i = new Integer(5);
        return new Constant((Object)i);
    }

    @Test
    public void testString() {
        String s = "the string";
        Constant c = new Constant((Object)s);
        Assert.assertEquals((String)"Value is incorrect: ", (Object)s, (Object)c.getValue());
        Assert.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.STRING, (Object)c.getType());
        Assert.assertEquals((String)"Should be non-null: ", (Object)false, (Object)c.isNull());
        Assert.assertEquals((String)"Is not resolved: ", (Object)true, (Object)c.isResolved());
        Assert.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant((Object)s);
        Assert.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        Assert.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
    }

    @Test
    public void testInteger() {
        Integer i = new Integer(5);
        Constant c = new Constant((Object)i);
        Assert.assertEquals((String)"Value is incorrect: ", (Object)i, (Object)c.getValue());
        Assert.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)c.getType());
        Assert.assertEquals((String)"Should be non-null: ", (Object)false, (Object)c.isNull());
        Assert.assertEquals((String)"Is not resolved: ", (Object)true, (Object)c.isResolved());
        Assert.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant((Object)i);
        Assert.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        Assert.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
    }

    @Test
    public void testNoTypeNull() {
        Constant c = new Constant(null);
        Assert.assertEquals((String)"Value is incorrect: ", null, (Object)c.getValue());
        Assert.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.NULL, (Object)c.getType());
        Assert.assertEquals((String)"Should be null: ", (Object)true, (Object)c.isNull());
        Assert.assertEquals((String)"Is not resolved: ", (Object)true, (Object)c.isResolved());
        Assert.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant(null);
        Assert.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        Assert.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
    }

    @Test
    public void testTypedNull() {
        Constant c = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
        Assert.assertEquals((String)"Value is incorrect: ", null, (Object)c.getValue());
        Assert.assertEquals((String)"Type is incorrect: ", (Object)DataTypeManager.DefaultDataClasses.STRING, (Object)c.getType());
        Assert.assertEquals((String)"Should be null: ", (Object)true, (Object)c.isNull());
        Assert.assertEquals((String)"Is not resolved: ", (Object)true, (Object)c.isResolved());
        Assert.assertEquals((String)"Object does not equal itself", (Object)c, (Object)c);
        Constant c2 = new Constant(null, DataTypeManager.DefaultDataClasses.STRING);
        Assert.assertEquals((String)"Constants for same object aren't equal: ", (Object)c, (Object)c2);
        Constant cc = (Constant)c.clone();
        Assert.assertEquals((String)"Cloned object not equal to original: ", (Object)c, (Object)cc);
        Constant c3 = new Constant(null);
        Assert.assertEquals((String)"Typed null not equal to non-typed null: ", (Object)c, (Object)c3);
    }

    @Test
    public void testClone() {
        StringBuffer value = new StringBuffer("x");
        Constant c1 = new Constant((Object)value, DataTypeManager.DefaultDataClasses.OBJECT);
        Constant copy = (Constant)c1.clone();
        Assert.assertEquals((String)"Cloned object not equal to original: ", (Object)c1, (Object)copy);
        value.append("y");
        Assert.assertTrue((String)"Original object has not changed, but should have", (boolean)((StringBuffer)c1.getValue()).toString().equals("xy"));
        Assert.assertTrue((String)"Cloned object has not changed, but should have", (boolean)((StringBuffer)copy.getValue()).toString().equals("xy"));
    }

    @Test
    public void testSelfEquivalence() {
        Constant s1 = TestConstant.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    @Test
    public void testEquivalence() {
        Constant s1 = TestConstant.sample1();
        Constant s1a = TestConstant.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    @Test
    public void testNonEquivalence() {
        Constant s1 = TestConstant.sample1();
        Constant s2 = TestConstant.sample2();
        int equals = -1;
        try {
            UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
        }
        catch (ClassCastException e) {
            // empty catch block
        }
    }

    @Test
    public void testPaddedStringComparison() {
        Assert.assertEquals((long)1L, (long)Constant.comparePadded((CharSequence)"a", (CharSequence)""));
        Assert.assertEquals((long)0L, (long)Constant.comparePadded((CharSequence)"a", (CharSequence)"a "));
        Assert.assertEquals((long)-24L, (long)Constant.comparePadded((CharSequence)"ab ", (CharSequence)"az "));
        Assert.assertEquals((long)66L, (long)Constant.comparePadded((CharSequence)"ab ", (CharSequence)"a "));
        Assert.assertEquals((long)0L, (long)Constant.comparePadded((CharSequence)"a1 ", (CharSequence)"a1"));
    }
}

