/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.jdbc.TeiidSQLException;

public class TestResultSetUtil {
    public static final int DEFAULT_MAX_COL_WIDTH = 29;
    private static final String SPACER = "  ";
    private static final String NULL = "<null>";
    private static final String MORE = "$ ";
    private static String[] METADATA_METHODS = new String[]{"getColumnName", "getColumnType", "getCatalogName", "getColumnClassName", "getColumnLabel", "getColumnTypeName", "getSchemaName", "getTableName", "getColumnDisplaySize", "getPrecision", "getScale", "isAutoIncrement", "isCaseSensitive", "isCurrency", "isDefinitelyWritable", "isNullable", "isReadOnly", "isSearchable", "isSigned", "isWritable"};

    public static List compareThrowable(Throwable t, String query, File expectedResultsFile, boolean printToConsole) throws IOException, SQLException {
        BufferedReader expectedResultsReader = null;
        if (expectedResultsFile != null && expectedResultsFile.exists() && expectedResultsFile.canRead()) {
            expectedResultsReader = new BufferedReader(new FileReader(expectedResultsFile));
        }
        PrintStream out = TestResultSetUtil.getPrintStream(null, expectedResultsReader, printToConsole ? System.out : null);
        TestResultSetUtil.printThrowable(t, query, out);
        return TestResultSetUtil.getUnequalLines(out);
    }

    public static void printThrowable(Throwable t, String sql, PrintStream out) {
        TeiidSQLException sqle;
        SQLException se;
        out.println(sql);
        Throwable answer = t;
        if (t instanceof TeiidSQLException && (se = (sqle = (TeiidSQLException)t).getNextException()) != null) {
            SQLException s = null;
            while ((s = se.getNextException()) != null) {
                se = s;
            }
            answer = se;
        }
        out.print(t.getClass().getName() + " : " + answer.getMessage());
    }

    public static PrintStream getPrintStream(OutputStream resultsOutput, BufferedReader expectedResultsInput, PrintStream defaultPrintStream) {
        PrintStream out = null;
        if (defaultPrintStream == null) {
            defaultPrintStream = new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
        }
        if (resultsOutput == null && expectedResultsInput == null) {
            out = defaultPrintStream;
        } else if (resultsOutput == null && expectedResultsInput != null) {
            out = new ComparingPrintStream((OutputStream)defaultPrintStream, expectedResultsInput);
        } else if (resultsOutput != null && expectedResultsInput == null) {
            PrintStream filePrintStream = new PrintStream(resultsOutput);
            out = new MuxingPrintStream(new PrintStream[]{defaultPrintStream, filePrintStream});
        } else {
            PrintStream filePrintStream = new PrintStream(resultsOutput);
            out = new ComparingPrintStream((OutputStream)new MuxingPrintStream(new PrintStream[]{defaultPrintStream, filePrintStream}), expectedResultsInput);
        }
        return out;
    }

    public static List writeAndCompareResultSet(ResultSet rs, String query, int maxColWidth, boolean printMetadata, File resultsFile, File expectedResultsFile, boolean printToConsole) throws IOException, SQLException {
        FileOutputStream resultsOutputStream = null;
        if (resultsFile != null) {
            resultsOutputStream = new FileOutputStream(resultsFile);
        }
        BufferedReader expectedResultsReader = null;
        if (expectedResultsFile != null && expectedResultsFile.exists() && expectedResultsFile.canRead()) {
            expectedResultsReader = new BufferedReader(new FileReader(expectedResultsFile));
        }
        return TestResultSetUtil.writeAndCompareResultSet(rs, query, maxColWidth, printMetadata, resultsOutputStream, expectedResultsReader, printToConsole ? System.out : null);
    }

    public static List writeAndCompareResultSet(ResultSet rs, String query, int maxColWidth, boolean printMetadata, OutputStream resultsOutput, BufferedReader expectedResultsInput, PrintStream defaultPrintStream) throws SQLException {
        PrintStream out = TestResultSetUtil.getPrintStream(resultsOutput, expectedResultsInput, defaultPrintStream);
        TestResultSetUtil.printResultSet(rs, query, maxColWidth, printMetadata, out);
        return TestResultSetUtil.getUnequalLines(out);
    }

    public static List getUnequalLines(PrintStream out) {
        if (out instanceof ComparingPrintStream) {
            return ((ComparingPrintStream)out).getUnequalLines();
        }
        return Collections.EMPTY_LIST;
    }

    public static void printUpdateCount(int updateCount, PrintStream out) {
        out.println("Update Count : " + updateCount);
    }

    public static void printBatchedUpdateCounts(int[] counts, PrintStream out) {
        out.println("Batched Update Counts :");
        for (int i = 0; i < counts.length; ++i) {
            out.println(counts[i]);
        }
        out.println("Total Batched Commands : " + counts.length);
    }

    public static void printResultSet(ResultSet rs, String query, int maxColWidth, boolean printMetadata, PrintStream out) throws SQLException {
        if (maxColWidth < 0) {
            maxColWidth = 29;
        }
        out.println(query);
        ResultSetMetaData rsmd = rs.getMetaData();
        int count = rsmd.getColumnCount();
        int[] sizes = new int[count];
        StringWriter types = new StringWriter();
        StringWriter columns = new StringWriter();
        for (int i = 1; i <= count; ++i) {
            String columnName = rsmd.getColumnName(i);
            String typeName = rsmd.getColumnTypeName(i);
            sizes[i - 1] = maxColWidth == 0 ? Math.max(columnName.length(), typeName.length()) : Math.max(Math.max(columnName.length(), typeName.length()), Math.min(rsmd.getColumnDisplaySize(i), maxColWidth));
            types.write(TestResultSetUtil.resizeString(typeName, sizes[i - 1]));
            columns.write(TestResultSetUtil.resizeString(columnName, sizes[i - 1]));
            if (i == count) continue;
            types.write(SPACER);
            columns.write(SPACER);
        }
        out.println(types.toString());
        out.println(columns.toString());
        int totalRows = 0;
        while (rs.next()) {
            for (int j = 1; j <= count; ++j) {
                if (maxColWidth == 0) {
                    Object obj = rs.getObject(j);
                    out.print(obj == null ? NULL : obj);
                    if (j == count) continue;
                    out.print(SPACER);
                    continue;
                }
                String resizedString = TestResultSetUtil.resizeString(rs.getObject(j), sizes[j - 1]);
                out.print(resizedString);
                if (j == count || resizedString.length() > sizes[j - 1]) continue;
                out.print(SPACER);
            }
            out.println();
            ++totalRows;
        }
        out.println("Row Count : " + totalRows);
        if (printMetadata) {
            TestResultSetUtil.printResultSetMetadata(rsmd, out);
        }
    }

    public static void printResultSetMetadata(ResultSetMetaData rsmd, PrintStream out) throws SQLException {
        int col;
        int i;
        int columns = rsmd.getColumnCount();
        Class<ResultSetMetaData> RSMD = ResultSetMetaData.class;
        Class[] params = new Class[]{Integer.TYPE};
        int numMethods = METADATA_METHODS.length;
        String[][] metadataStrings = new String[columns][numMethods];
        int[] maxColWidths = new int[numMethods];
        for (i = 0; i < numMethods; ++i) {
            maxColWidths[i] = METADATA_METHODS[i].length();
        }
        for (col = 1; col <= columns; ++col) {
            Object[] columnParam = new Object[]{new Integer(col)};
            for (int i2 = 0; i2 < numMethods; ++i2) {
                try {
                    String stringVal;
                    Method m = RSMD.getMethod(METADATA_METHODS[i2], params);
                    Object obj = m.invoke((Object)rsmd, columnParam);
                    metadataStrings[col - 1][i2] = stringVal = obj == null ? NULL : obj.toString();
                    if (maxColWidths[i2] >= stringVal.length()) continue;
                    maxColWidths[i2] = stringVal.length();
                    continue;
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
        }
        for (i = 0; i < numMethods; ++i) {
            out.print(TestResultSetUtil.resizeString(METADATA_METHODS[i], maxColWidths[i]));
            if (i == numMethods) continue;
            out.print(SPACER);
        }
        out.println();
        for (col = 0; col < columns; ++col) {
            for (int i3 = 0; i3 < numMethods; ++i3) {
                out.print(TestResultSetUtil.resizeString(metadataStrings[col][i3], maxColWidths[i3]));
                if (i3 == numMethods) continue;
                out.print(SPACER);
            }
            out.println();
        }
    }

    private static String resizeString(Object obj, int size) {
        if (obj == null) {
            return TestResultSetUtil.resizeString(NULL, size);
        }
        String str = obj.toString();
        if (str.length() == size) {
            return str;
        }
        if (str.length() < size) {
            return TestResultSetUtil.pad(str, size - str.length());
        }
        return str.substring(0, size) + MORE;
    }

    private static String pad(String str, int padding) {
        StringBuffer buf = new StringBuffer(str);
        for (int i = 0; i < padding; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    private static final class ComparingPrintStream
    extends PrintStream {
        private ByteArrayOutputStream byteStream = new ByteArrayOutputStream(2048);
        private PrintStream buf = new PrintStream(this.byteStream);
        private BufferedReader in;
        private int line = 0;
        private ArrayList unequalLines = new ArrayList();

        private ComparingPrintStream(OutputStream out, BufferedReader in) {
            super(out);
            this.in = in;
        }

        @Override
        public void print(boolean b) {
            super.print(b);
            this.buf.print(b);
        }

        @Override
        public void print(char c) {
            super.print(c);
            this.buf.print(c);
        }

        @Override
        public void print(char[] s) {
            super.print(s);
            this.buf.print(s);
        }

        @Override
        public void print(double d) {
            super.print(d);
            this.buf.print(d);
        }

        @Override
        public void print(float f) {
            super.print(f);
            this.buf.print(f);
        }

        @Override
        public void print(int i) {
            super.print(i);
            this.buf.print(i);
        }

        @Override
        public void print(long l) {
            super.print(l);
            this.buf.print(l);
        }

        @Override
        public void print(Object obj) {
            super.print(obj);
            this.buf.print(obj);
        }

        @Override
        public void print(String s) {
            super.print(s);
            this.buf.print(s);
        }

        @Override
        public void println() {
            super.println();
            this.compareLines();
        }

        @Override
        public void println(boolean x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(char x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(char[] x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(double x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(float x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(int x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(long x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(Object x) {
            super.println(x);
            this.compareLines();
        }

        @Override
        public void println(String x) {
            super.println(x);
            this.compareLines();
        }

        private void compareLines() {
            ++this.line;
            this.buf.flush();
            String bufferedLine = this.byteStream.toString();
            this.byteStream.reset();
            try {
                String expectedLine = this.in.readLine();
                if (!bufferedLine.equals(expectedLine)) {
                    this.unequalLines.add("\n" + new Integer(this.line) + ":" + bufferedLine);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public List getUnequalLines() {
            return this.unequalLines;
        }
    }

    private static final class MuxingPrintStream
    extends PrintStream {
        private PrintStream[] streams;

        private MuxingPrintStream(PrintStream[] streams) {
            super(streams[0]);
            this.streams = new PrintStream[streams.length];
            System.arraycopy(streams, 0, this.streams, 0, streams.length);
        }

        @Override
        public void close() {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].close();
            }
        }

        @Override
        public void flush() {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].close();
            }
        }

        @Override
        public void print(boolean b) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(b);
            }
        }

        @Override
        public void print(char c) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(c);
            }
        }

        @Override
        public void print(char[] s) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(s);
            }
        }

        @Override
        public void print(double d) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(d);
            }
        }

        @Override
        public void print(float f) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(f);
            }
        }

        @Override
        public void print(int b) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(b);
            }
        }

        @Override
        public void print(long l) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(l);
            }
        }

        @Override
        public void print(Object obj) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(obj);
            }
        }

        @Override
        public void print(String s) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].print(s);
            }
        }

        @Override
        public void println() {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println();
            }
        }

        @Override
        public void println(boolean x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(char x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(char[] x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(double x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(float x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(int x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(long x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(Object x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void println(String x) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].println(x);
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].write(buf, off, len);
            }
        }

        @Override
        public void write(int b) {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].write(b);
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            for (int i = 0; i < this.streams.length; ++i) {
                this.streams[i].write(b);
            }
        }
    }
}

