/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.CapabilitiesConverter;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.message.AtomicRequestID;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.logging.CommandLogMessage;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.report.ActivityReport;
import org.teiid.query.sql.lang.Command;
import org.teiid.resource.spi.WrappedConnection;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.TranslatorException;

public class ConnectorManager {
    private static final String JAVA_CONTEXT = "java:";
    private String translatorName;
    private String connectionName;
    private String modelName;
    private ConcurrentHashMap<AtomicRequestID, ConnectorWorkItem> requestStates = new ConcurrentHashMap();
    private SourceCapabilities cachedCapabilities;
    private volatile boolean stopped;
    private ExecutionFactory<Object, Object> executionFactory;

    public ConnectorManager(String translatorName, String connectionName) {
        this.translatorName = translatorName;
        this.connectionName = connectionName;
    }

    public String getStausMessage() {
        StringBuilder sb = new StringBuilder();
        ExecutionFactory<Object, Object> ef = this.getExecutionFactory();
        if (ef != null) {
            if (ef.isSourceRequired()) {
                Object conn = null;
                try {
                    conn = this.getConnectionFactory();
                }
                catch (TranslatorException e) {
                    // empty catch block
                }
                if (conn == null) {
                    sb.append(QueryPlugin.Util.getString("datasource_not_found", new Object[]{this.connectionName}));
                }
            }
        } else {
            sb.append(QueryPlugin.Util.getString("translator_not_found", new Object[]{this.translatorName}));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataStore getMetadata(String modelName, Map<String, Datatype> datatypes, Properties importProperties) throws TranslatorException {
        MetadataFactory factory = new MetadataFactory(modelName, datatypes, importProperties);
        Object connectionFactory = this.getConnectionFactory();
        Object connection = this.executionFactory.getConnection(connectionFactory, null);
        Connection unwrapped = null;
        if (connection instanceof WrappedConnection) {
            try {
                unwrapped = ((WrappedConnection)connection).unwrap();
            }
            catch (ResourceException e) {
                throw new TranslatorException(QueryPlugin.Util.getString("failed_to_unwrap_connection"));
            }
        }
        try {
            this.executionFactory.getMetadata(factory, unwrapped == null ? connection : unwrapped);
        }
        finally {
            this.executionFactory.closeConnection(connection, connectionFactory);
        }
        this.validateMetadata(factory.getMetadataStore(), modelName);
        return factory.getMetadataStore();
    }

    private void validateMetadata(MetadataStore metadataStore, String schemaName) throws TranslatorException {
        if (metadataStore.getSchemas().size() != 1) {
            throw new TranslatorException(QueryPlugin.Util.getString("invalid_schema", new Object[]{schemaName}));
        }
        Map.Entry schemaEntry = metadataStore.getSchemas().entrySet().iterator().next();
        if (!schemaName.equalsIgnoreCase((String)schemaEntry.getKey())) {
            throw new TranslatorException(QueryPlugin.Util.getString("invalid_schema", new Object[]{schemaName}));
        }
        Schema s = (Schema)schemaEntry.getValue();
        for (Table t : s.getTables().values()) {
            if (t.getColumns() != null && t.getColumns().size() != 0) continue;
            throw new TranslatorException(QueryPlugin.Util.getString("invalid_table", new Object[]{t.getFullName()}));
        }
        ActivityReport report = new ActivityReport("Translator metadata load " + schemaName);
        FunctionMetadataValidator.validateFunctionMethods(s.getFunctions().values(), report);
        if (report.hasItems()) {
            throw new TranslatorException(QueryPlugin.Util.getString("ERR.015.001.0005", new Object[]{report}));
        }
    }

    public List<FunctionMethod> getPushDownFunctions() {
        return this.getExecutionFactory().getPushDownFunctions();
    }

    public SourceCapabilities getCapabilities() throws TeiidComponentException {
        if (this.cachedCapabilities != null) {
            return this.cachedCapabilities;
        }
        this.checkStatus();
        ExecutionFactory<Object, Object> translator = this.getExecutionFactory();
        BasicSourceCapabilities resultCaps = CapabilitiesConverter.convertCapabilities(translator, Arrays.asList(this.translatorName, this.connectionName));
        resultCaps.setScope(SourceCapabilities.Scope.SCOPE_GLOBAL);
        this.cachedCapabilities = resultCaps;
        return resultCaps;
    }

    public ConnectorWork registerRequest(AtomicRequestMessage message) throws TeiidComponentException {
        this.checkStatus();
        AtomicRequestID atomicRequestId = message.getAtomicRequestID();
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{atomicRequestId, "Create State"});
        ConnectorWorkItem item = new ConnectorWorkItem(message, this);
        Assertion.isNull((Object)this.requestStates.put(atomicRequestId, item), (String)"State already existed");
        return item;
    }

    ConnectorWork getState(AtomicRequestID requestId) {
        return this.requestStates.get(requestId);
    }

    void removeState(AtomicRequestID id) {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{id, "Remove State"});
        this.requestStates.remove(id);
    }

    int size() {
        return this.requestStates.size();
    }

    public void start() {
        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{QueryPlugin.Util.getString("ConnectorManagerImpl.Initializing_connector", new Object[]{this.translatorName})});
    }

    public void stop() {
        this.stopped = true;
        for (ConnectorWorkItem workItem : this.requestStates.values()) {
            workItem.cancel();
        }
    }

    void logSRCCommand(AtomicRequestMessage qr, ExecutionContext context, CommandLogMessage.Event cmdStatus, Integer finalRowCnt) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.COMMAND_LOG", (int)5)) {
            return;
        }
        String sqlStr = null;
        if (cmdStatus == CommandLogMessage.Event.NEW) {
            Command cmd = qr.getCommand();
            sqlStr = cmd != null ? cmd.toString() : null;
        }
        String userName = qr.getWorkContext().getUserName();
        String transactionID = null;
        if (qr.isTransactional()) {
            transactionID = qr.getTransactionContext().getTransactionId();
        }
        String modelName = qr.getModelName();
        AtomicRequestID id = qr.getAtomicRequestID();
        String principal = userName == null ? "unknown" : userName;
        CommandLogMessage message = null;
        message = cmdStatus == CommandLogMessage.Event.NEW ? new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)id.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, sqlStr, context) : new CommandLogMessage(System.currentTimeMillis(), qr.getRequestID().toString(), (long)id.getNodeID(), transactionID, modelName, this.translatorName, qr.getWorkContext().getSessionId(), principal, finalRowCnt, cmdStatus, context);
        LogManager.log((int)5, (String)"org.teiid.COMMAND_LOG", (Object)message);
    }

    public ExecutionFactory<Object, Object> getExecutionFactory() {
        return this.executionFactory;
    }

    public void setExecutionFactory(ExecutionFactory<Object, Object> ef) {
        this.executionFactory = ef;
    }

    protected Object getConnectionFactory() throws TranslatorException {
        if (this.connectionName != null) {
            String jndiName = this.connectionName;
            if (!this.connectionName.startsWith(JAVA_CONTEXT)) {
                jndiName = JAVA_CONTEXT + jndiName;
            }
            try {
                InitialContext ic = new InitialContext();
                try {
                    return ic.lookup(jndiName);
                }
                catch (NamingException e) {
                    if (!jndiName.equals(this.connectionName)) {
                        return ic.lookup(this.connectionName);
                    }
                }
            }
            catch (NamingException e) {
                throw new TranslatorException((Throwable)e, QueryPlugin.Util.getString("connection_factory_not_found", new Object[]{this.connectionName}));
            }
        }
        return null;
    }

    private void checkStatus() throws TeiidComponentException {
        if (this.stopped) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("ConnectorManager.not_in_valid_state", new Object[]{this.translatorName}));
        }
    }

    public String getTranslatorName() {
        return this.translatorName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelName() {
        return this.modelName;
    }
}

