/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.List;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.language.SortSpecification;
import org.teiid.metadata.Schema;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.translator.ExecutionFactory;

public class CapabilitiesUtil {
    private CapabilitiesUtil() {
    }

    static boolean supportsInlineView(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS, modelID, metadata, capFinder);
    }

    public static boolean supportsSelfJoins(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability(SourceCapabilities.Capability.QUERY_FROM_JOIN_SELFJOIN) && caps.supportsCapability(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS);
    }

    public static boolean supportsGroupAliases(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_GROUP_ALIAS, modelID, metadata, capFinder);
    }

    public static boolean supportsJoin(Object modelID, JoinType joinType, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (!joinType.isOuter()) {
            return caps.supportsCapability(SourceCapabilities.Capability.QUERY_FROM_JOIN_INNER);
        }
        if (!caps.supportsCapability(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER)) {
            return false;
        }
        return !joinType.equals(JoinType.JOIN_FULL_OUTER) || caps.supportsCapability(SourceCapabilities.Capability.QUERY_FROM_JOIN_OUTER_FULL);
    }

    public static boolean supportsAggregates(List groupCols, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        if (groupCols != null && !groupCols.isEmpty()) {
            if (!caps.supportsCapability(SourceCapabilities.Capability.QUERY_GROUP_BY)) {
                return false;
            }
            boolean supportsFunctionsInGroupBy = caps.supportsCapability(SourceCapabilities.Capability.QUERY_FUNCTIONS_IN_GROUP_BY);
            boolean supportsInlineView = caps.supportsCapability(SourceCapabilities.Capability.QUERY_FROM_INLINE_VIEWS);
            for (Expression col : groupCols) {
                if (col instanceof ElementSymbol || supportsFunctionsInGroupBy || supportsInlineView) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean supportsAggregateFunction(Object modelID, AggregateSymbol aggregate, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        AggregateSymbol.Type func = aggregate.getAggregateFunction();
        switch (func) {
            case COUNT: {
                if (!(aggregate.getExpression() == null ? !caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT_STAR) : !caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_COUNT))) break;
                return false;
            }
            case SUM: {
                if (caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_SUM)) break;
                return false;
            }
            case AVG: {
                if (caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_AVG)) break;
                return false;
            }
            case MIN: {
                if (caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_MIN)) break;
                return false;
            }
            case MAX: {
                if (caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_MAX)) break;
                return false;
            }
            case ARRAY_AGG: {
                if (caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_ARRAY)) break;
                return false;
            }
            case RANK: 
            case DENSE_RANK: 
            case ROW_NUMBER: {
                if (caps.supportsCapability(SourceCapabilities.Capability.ELEMENTARY_OLAP)) break;
                return false;
            }
            default: {
                if (aggregate.isEnhancedNumeric()) {
                    if (caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_ENHANCED_NUMERIC)) break;
                    return false;
                }
                return false;
            }
        }
        if (aggregate.isDistinct() && !caps.supportsCapability(SourceCapabilities.Capability.QUERY_AGGREGATES_DISTINCT)) {
            return false;
        }
        return aggregate.getCondition() == null || caps.supportsCapability(SourceCapabilities.Capability.ADVANCED_OLAP);
    }

    public static boolean supportsScalarFunction(Object modelID, Function function, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        SourceCapabilities caps;
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        Schema schema = function.getFunctionDescriptor().getMethod().getParent();
        if (schema == null ? !(caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder)).supportsFunction(function.getFunctionDescriptor().getName()) : !CapabilitiesUtil.isSameConnector(modelID, schema, metadata, capFinder)) {
            return false;
        }
        if (FunctionLibrary.isConvert(function)) {
            Class fromType = function.getArg(0).getType();
            if (DataTypeManager.DefaultDataClasses.OBJECT.equals(fromType) || DataTypeManager.DefaultDataClasses.CLOB.equals(fromType) || DataTypeManager.DefaultDataClasses.XML.equals(fromType)) {
                return false;
            }
            String targetType = (String)((Constant)function.getArg(1)).getValue();
            if ("clob".equalsIgnoreCase(targetType) || "xml".equalsIgnoreCase(targetType)) {
                return false;
            }
        }
        return true;
    }

    public static boolean supportsSelectDistinct(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_DISTINCT, modelID, metadata, capFinder);
    }

    public static boolean supportsSelectExpression(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SELECT_EXPRESSION, modelID, metadata, capFinder);
    }

    public static boolean supportsOrderBy(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY, modelID, metadata, capFinder);
    }

    public static boolean supportsSetOp(Object modelID, SetQuery.Operation setOp, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        switch (setOp) {
            case EXCEPT: {
                return caps.supportsCapability(SourceCapabilities.Capability.QUERY_EXCEPT);
            }
            case INTERSECT: {
                return caps.supportsCapability(SourceCapabilities.Capability.QUERY_INTERSECT);
            }
            case UNION: {
                return caps.supportsCapability(SourceCapabilities.Capability.QUERY_UNION);
            }
        }
        return false;
    }

    public static boolean supportsSetQueryOrderBy(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SET_ORDER_BY, modelID, metadata, capFinder);
    }

    public static boolean supportsCaseExpression(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_CASE, modelID, metadata, capFinder);
    }

    public static boolean supportsSearchedCaseExpression(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_SEARCHED_CASE, modelID, metadata, capFinder);
    }

    public static int getMaxInCriteriaSize(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.getProperty(SourceCapabilities.Capability.MAX_IN_CRITERIA_SIZE, modelID, metadata, capFinder);
    }

    private static int getProperty(SourceCapabilities.Capability cap, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return -1;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        Object maxInCriteriaSize = caps.getSourceProperty(cap);
        int value = -1;
        if (maxInCriteriaSize != null) {
            value = (Integer)maxInCriteriaSize;
        }
        if (value <= 0) {
            value = -1;
        }
        return value;
    }

    public static int getMaxDependentPredicates(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.getProperty(SourceCapabilities.Capability.MAX_DEPENDENT_PREDICATES, modelID, metadata, capFinder);
    }

    public static int getMaxFromGroups(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return -1;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        Object maxGroups = caps.getSourceProperty(SourceCapabilities.Capability.MAX_QUERY_FROM_GROUPS);
        int value = -1;
        if (maxGroups != null) {
            value = (Integer)maxGroups;
        }
        if (value <= 0) {
            value = -1;
        }
        return value;
    }

    public static ExecutionFactory.SupportedJoinCriteria getSupportedJoinCriteria(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return ExecutionFactory.SupportedJoinCriteria.ANY;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        ExecutionFactory.SupportedJoinCriteria crits = (ExecutionFactory.SupportedJoinCriteria)caps.getSourceProperty(SourceCapabilities.Capability.JOIN_CRITERIA_ALLOWED);
        if (crits == null) {
            return ExecutionFactory.SupportedJoinCriteria.ANY;
        }
        return crits;
    }

    public static ExecutionFactory.NullOrder getDefaultNullOrder(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return ExecutionFactory.NullOrder.UNKNOWN;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        ExecutionFactory.NullOrder order = (ExecutionFactory.NullOrder)caps.getSourceProperty(SourceCapabilities.Capability.QUERY_ORDERBY_DEFAULT_NULL_ORDER);
        if (order == null) {
            return ExecutionFactory.NullOrder.UNKNOWN;
        }
        return order;
    }

    public static boolean supportsRowLimit(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.ROW_LIMIT, modelID, metadata, capFinder);
    }

    public static boolean supportsRowOffset(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.ROW_OFFSET, modelID, metadata, capFinder);
    }

    public static boolean isSameConnector(Object modelID, Object modelID1, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (modelID == null || modelID1 == null || metadata.isVirtualModel(modelID) || metadata.isVirtualModel(modelID1)) {
            return false;
        }
        if (modelID.equals(modelID1)) {
            return true;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        SourceCapabilities caps1 = CapabilitiesUtil.getCapabilities(modelID1, metadata, capFinder);
        Object connectorID = caps.getSourceProperty(SourceCapabilities.Capability.CONNECTOR_ID);
        return connectorID != null && connectorID.equals(caps1.getSourceProperty(SourceCapabilities.Capability.CONNECTOR_ID));
    }

    private static SourceCapabilities getCapabilities(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        String modelName = metadata.getFullName(modelID);
        return capFinder.findCapabilities(modelName);
    }

    public static boolean requiresCriteria(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.REQUIRES_CRITERIA, modelID, metadata, capFinder);
    }

    public static boolean useAnsiJoin(Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        return CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_FROM_ANSI_JOIN, modelID, metadata, capFinder);
    }

    public static boolean supports(SourceCapabilities.Capability cap, Object modelID, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        if (metadata.isVirtualModel(modelID)) {
            return false;
        }
        SourceCapabilities caps = CapabilitiesUtil.getCapabilities(modelID, metadata, capFinder);
        return caps.supportsCapability(cap);
    }

    static boolean checkElementsAreSearchable(List<? extends LanguageObject> objs, QueryMetadataInterface metadata, int searchableType) throws QueryMetadataException, TeiidComponentException {
        ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>();
        ElementCollectorVisitor.getElements(objs, elements);
        for (ElementSymbol elementSymbol : elements) {
            if (metadata.elementSupports(elementSymbol.getMetadataID(), searchableType)) continue;
            return false;
        }
        return true;
    }

    static boolean supportsNullOrdering(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, Object modelID, OrderByItem symbol) throws QueryMetadataException, TeiidComponentException {
        boolean supportsNullOrdering = CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY_NULL_ORDERING, modelID, metadata, capFinder);
        ExecutionFactory.NullOrder defaultNullOrder = CapabilitiesUtil.getDefaultNullOrder(modelID, metadata, capFinder);
        if (symbol.getNullOrdering() != null) {
            if (!supportsNullOrdering) {
                if (symbol.getNullOrdering() == SortSpecification.NullOrdering.FIRST ? !(defaultNullOrder == ExecutionFactory.NullOrder.FIRST || symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.LOW || !symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.HIGH) : !(defaultNullOrder == ExecutionFactory.NullOrder.LAST || symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.HIGH || !symbol.isAscending() && defaultNullOrder == ExecutionFactory.NullOrder.LOW)) {
                    return false;
                }
                symbol.setNullOrdering(null);
            }
        } else if (supportsNullOrdering && defaultNullOrder != ExecutionFactory.NullOrder.LOW) {
            if (symbol.isAscending()) {
                if (defaultNullOrder != ExecutionFactory.NullOrder.FIRST) {
                    symbol.setNullOrdering(SortSpecification.NullOrdering.FIRST);
                }
            } else if (defaultNullOrder != ExecutionFactory.NullOrder.LAST) {
                symbol.setNullOrdering(SortSpecification.NullOrdering.LAST);
            }
        }
        return true;
    }
}

