/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import java.util.List;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.IndexedTupleSource;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.BatchIterator;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SortUtility;
import org.teiid.query.sql.symbol.SingleElementSymbol;

class SourceState {
    private RelationalNode source;
    private List expressions;
    private BatchCollector collector;
    private TupleBuffer buffer;
    private List<TupleBuffer> buffers;
    private List<Object> outerVals;
    private IndexedTupleSource iterator;
    private int[] expressionIndexes;
    private List currentTuple;
    private int maxProbeMatch = 1;
    private boolean distinct;
    private ImplicitBuffer implicitBuffer = ImplicitBuffer.FULL;
    boolean open;
    private SortUtility sortUtility;

    public SourceState(RelationalNode source, List expressions) {
        this.source = source;
        this.expressions = expressions;
        List<? extends SingleElementSymbol> elements = source.getElements();
        this.outerVals = Collections.nCopies(elements.size(), null);
        this.expressionIndexes = SourceState.getExpressionIndecies(expressions, elements);
    }

    public RelationalNode getSource() {
        return this.source;
    }

    public void setImplicitBuffer(ImplicitBuffer implicitBuffer) {
        this.implicitBuffer = implicitBuffer;
    }

    static int[] getExpressionIndecies(List expressions, List elements) {
        if (expressions == null) {
            return new int[0];
        }
        int[] indecies = new int[expressions.size()];
        for (int i = 0; i < expressions.size(); ++i) {
            indecies[i] = elements.indexOf(expressions.get(i));
            assert (indecies[i] != -1);
        }
        return indecies;
    }

    TupleBuffer createSourceTupleBuffer() throws TeiidComponentException {
        return this.source.getBufferManager().createTupleBuffer(this.source.getElements(), this.source.getConnectionID(), BufferManager.TupleSourceType.PROCESSOR);
    }

    public List saveNext() throws TeiidComponentException, TeiidProcessingException {
        this.currentTuple = this.getIterator().nextTuple();
        return this.currentTuple;
    }

    public void reset() throws TeiidComponentException {
        this.getIterator().reset();
        this.getIterator().mark();
        this.currentTuple = null;
    }

    public void close() {
        while (this.nextBuffer()) {
        }
        this.open = false;
    }

    private void closeBuffer() {
        if (this.buffer != null) {
            this.buffer.remove();
            this.buffer = null;
        }
        if (this.iterator != null) {
            this.iterator.closeSource();
            this.iterator = null;
        }
        this.currentTuple = null;
    }

    public int getRowCount() throws TeiidComponentException, TeiidProcessingException {
        return this.getTupleBuffer().getRowCount();
    }

    IndexedTupleSource getIterator() throws TeiidComponentException {
        if (this.iterator == null) {
            if (this.buffer != null) {
                this.iterator = this.buffer.createIndexedTupleSource();
            } else {
                BatchIterator bi = new BatchIterator(this.source);
                if (this.implicitBuffer != ImplicitBuffer.NONE) {
                    bi.setBuffer(this.createSourceTupleBuffer(), this.implicitBuffer == ImplicitBuffer.ON_MARK);
                }
                this.iterator = bi;
            }
        }
        return this.iterator;
    }

    public List<Object> getOuterVals() {
        return this.outerVals;
    }

    public List getCurrentTuple() {
        return this.currentTuple;
    }

    public int[] getExpressionIndexes() {
        return this.expressionIndexes;
    }

    void setMaxProbeMatch(int maxProbeMatch) {
        this.maxProbeMatch = maxProbeMatch;
    }

    int getMaxProbeMatch() {
        return this.maxProbeMatch;
    }

    public TupleBuffer getTupleBuffer() throws TeiidComponentException, TeiidProcessingException {
        if (this.buffer == null) {
            if (this.iterator instanceof BatchIterator) {
                throw new AssertionError((Object)"cannot buffer the source");
            }
            if (this.collector == null) {
                this.collector = new BatchCollector(this.source, this.source.getBufferManager(), this.source.getContext(), false);
            }
            this.buffer = this.collector.collectTuples();
        }
        return this.buffer;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void markDistinct(boolean distinct) {
        this.distinct |= distinct;
    }

    public void sort(MergeJoinStrategy.SortOption sortOption) throws TeiidComponentException, TeiidProcessingException {
        if (sortOption == MergeJoinStrategy.SortOption.ALREADY_SORTED) {
            return;
        }
        if (this.sortUtility == null) {
            IndexedTupleSource ts = null;
            if (this.buffer != null) {
                this.buffer.setForwardOnly(true);
                ts = this.buffer.createIndexedTupleSource();
            } else {
                ts = new BatchIterator(this.source);
            }
            this.sortUtility = new SortUtility(ts, this.expressions, Collections.nCopies(this.expressions.size(), true), sortOption == MergeJoinStrategy.SortOption.SORT_DISTINCT ? SortUtility.Mode.DUP_REMOVE_SORT : SortUtility.Mode.SORT, this.source.getBufferManager(), this.source.getConnectionID(), this.source.getElements());
            this.markDistinct(sortOption == MergeJoinStrategy.SortOption.SORT_DISTINCT && this.expressions.size() == this.getOuterVals().size());
        }
        if (sortOption == MergeJoinStrategy.SortOption.NOT_SORTED) {
            this.buffers = this.sortUtility.onePassSort();
            if (this.buffers.size() == 1) {
                this.markDistinct(this.sortUtility.isDistinct());
            }
            this.nextBuffer();
            return;
        }
        this.buffer = this.sortUtility.sort();
        this.markDistinct(this.sortUtility.isDistinct());
    }

    public boolean hasBuffer() {
        return this.buffer != null;
    }

    public boolean nextBuffer() {
        this.closeBuffer();
        if (this.buffers == null || this.buffers.isEmpty()) {
            return false;
        }
        this.buffer = this.buffers.remove(this.buffers.size() - 1);
        this.buffer.setForwardOnly(false);
        this.resetState();
        return true;
    }

    public void resetState() {
        if (this.iterator != null) {
            this.iterator.reset();
            this.iterator.setPosition(1);
        }
        this.currentTuple = null;
        this.maxProbeMatch = 1;
    }

    static enum ImplicitBuffer {
        NONE,
        FULL,
        ON_MARK;

    }
}

