/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core;

import java.sql.SQLException;
import java.util.Iterator;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ExceptionUtil;

public class TeiidException
extends Exception {
    private static final long serialVersionUID = -3033427629587497938L;
    protected String code;
    private transient String originalType;

    public TeiidException() {
    }

    public TeiidException(String message) {
        super(message);
    }

    public TeiidException(BundleUtil.Event code, String message) {
        super(message);
        this.setCode(code.toString());
    }

    public TeiidException(BundleUtil.Event code, Throwable t, String message) {
        super(message, t);
        this.setCode(code.toString());
    }

    public TeiidException(BundleUtil.Event code, Throwable t) {
        super(t);
        this.setCode(code.toString());
    }

    public TeiidException(Throwable e) {
        this(e, e != null ? e.getMessage() : null);
    }

    public TeiidException(Throwable e, String message) {
        super(message, e);
        this.setCode(TeiidException.getCode(e));
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(String originalType) {
        this.originalType = originalType;
    }

    static String getCode(Throwable e) {
        if (e instanceof TeiidException) {
            return ((TeiidException)e).getCode();
        }
        if (e instanceof TeiidRuntimeException) {
            return ((TeiidRuntimeException)e).getCode();
        }
        if (e instanceof SQLException) {
            return ((SQLException)e).getSQLState();
        }
        return null;
    }

    @Override
    public String getMessage() {
        if (this.code == null || this.code.length() == 0) {
            return super.getMessage();
        }
        return "Error Code:" + this.code + " Message:" + super.getMessage();
    }

    static String getFormattedMessage(Throwable throwable, int level) {
        String code = throwable instanceof TeiidException ? ((TeiidException)throwable).getCode() : (throwable instanceof TeiidRuntimeException ? ((TeiidRuntimeException)throwable).getCode() : null);
        return (level != 0 ? "\n" + level + " " : "") + "[" + throwable.getClass().getSimpleName() + "]" + (code != null ? ' ' + code + ": " : "") + (throwable.getMessage() == null ? "" : throwable.getMessage());
    }

    public String getFullMessage() {
        int level = 0;
        StringBuffer buf = new StringBuffer();
        buf.append(TeiidException.getFormattedMessage(this, level));
        Iterator children = ExceptionUtil.getChildrenIterator(this);
        while (children.hasNext()) {
            Throwable exception = (Throwable)children.next();
            buf.append(TeiidException.getFormattedMessage(exception, ++level));
        }
        return buf.toString();
    }

    public Throwable getChild() {
        return super.getCause();
    }

    @Override
    public String toString() {
        return this.getFullMessage();
    }
}

