/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialBlob;
import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;

public final class BlobType
extends Streamable<Blob>
implements Blob,
Comparable<BlobType> {
    private static final long serialVersionUID = 1294191629070433450L;

    public BlobType() {
    }

    public BlobType(Blob blob) {
        super(blob);
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return ((Blob)this.reference).getBinaryStream();
    }

    @Override
    public byte[] getBytes(long pos, int len) throws SQLException {
        return ((Blob)this.reference).getBytes(pos, len);
    }

    @Override
    long computeLength() throws SQLException {
        return ((Blob)this.reference).length();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        return ((Blob)this.reference).position(pattern, start);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        return ((Blob)this.reference).position(pattern, start);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        return ((Blob)this.reference).setBinaryStream(pos);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        return ((Blob)this.reference).setBytes(pos, bytes, offset, len);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return ((Blob)this.reference).setBytes(pos, bytes);
    }

    @Override
    public void truncate(long len) throws SQLException {
        ((Blob)this.reference).truncate(len);
    }

    @Override
    public void free() throws SQLException {
        ((Blob)this.reference).free();
    }

    @Override
    public InputStream getBinaryStream(long pos, long len) throws SQLException {
        return ((Blob)this.reference).getBinaryStream(pos, len);
    }

    public static SerialBlob createBlob(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        try {
            return new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10047, (Throwable)e);
        }
    }

    @Override
    protected void readReference(ObjectInput in) throws IOException {
        byte[] bytes = new byte[(int)this.getLength()];
        in.readFully(bytes);
        try {
            this.reference = new SerialBlob(bytes);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void writeReference(DataOutput out) throws IOException {
        try {
            BlobType.writeBinary(out, this.getBinaryStream(), (int)this.length);
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeBinary(final DataOutput out, InputStream is, int length) throws IOException {
        OutputStream os = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                out.write(b);
            }
        };
        try {
            int bytes = ObjectConverterUtil.write(os, is, length, false);
            if (bytes != length) {
                throw new IOException("Expected length " + length + " but was " + bytes);
            }
        }
        finally {
            is.close();
        }
    }

    @Override
    public int compareTo(BlobType o) {
        try {
            InputStream is1 = this.getBinaryStream();
            InputStream is2 = o.getBinaryStream();
            long len1 = this.length();
            long len2 = o.length();
            long n = Math.min(len1, len2);
            for (long i = 0L; i < n; ++i) {
                int b2;
                int b1 = is1.read();
                if (b1 == (b2 = is2.read())) continue;
                return b1 - b2;
            }
            return Long.signum(len1 - len2);
        }
        catch (SQLException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10048, (Throwable)e);
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)CorePlugin.Event.TEIID10049, (Throwable)e);
        }
    }
}

