/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleCleanCriteria
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        boolean pushRaiseNull = false;
        pushRaiseNull = this.clean(plan);
        if (pushRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return plan;
    }

    private boolean clean(PlanNode plan) throws TeiidComponentException {
        boolean pushRaiseNull = false;
        plan.setProperty(NodeConstants.Info.OUTPUT_COLS, null);
        for (PlanNode node : plan.getChildren()) {
            pushRaiseNull |= this.clean(node);
        }
        if (plan.getType() == 16) {
            pushRaiseNull = this.cleanCriteria(plan);
        }
        return pushRaiseNull;
    }

    boolean cleanCriteria(PlanNode critNode) throws TeiidComponentException {
        if (critNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) {
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
            return false;
        }
        if (critNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING) || critNode.getGroups().size() != 0) {
            return false;
        }
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (!EvaluatableVisitor.isFullyEvaluatable(crit, true)) {
            return false;
        }
        try {
            boolean eval = Evaluator.evaluate(crit);
            if (!eval) {
                FrameUtil.replaceWithNullNode(critNode);
                return true;
            }
            NodeEditor.removeChildNode(critNode.getParent(), critNode);
        }
        catch (BlockedException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30273, (Throwable)((Object)e));
        }
        catch (ExpressionEvaluationException e) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30274, (Throwable)((Object)e));
        }
        return false;
    }

    public String toString() {
        return "CleanCriteria";
    }
}

