/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.lang.reflect.Array;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.util.CommandContext;

public class ArrayTableNode
extends SubqueryAwareRelationalNode {
    private ArrayTable table;
    private int[] projectionIndexes;

    public ArrayTableNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.projectionIndexes != null) {
            return;
        }
        Map<Expression, Integer> elementMap = ArrayTableNode.createLookupMap(this.table.getProjectedSymbols());
        this.projectionIndexes = ArrayTableNode.getProjectionIndexes(elementMap, this.getElements());
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        this.reset();
    }

    public void setTable(ArrayTable table) {
        this.table = table;
    }

    @Override
    public ArrayTableNode clone() {
        ArrayTableNode clone = new ArrayTableNode(this.getID());
        this.copy(this, clone);
        clone.setTable(this.table);
        return clone;
    }

    @Override
    protected TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        ArrayList<Object> tuple = new ArrayList<Object>(this.projectionIndexes.length);
        Object array = this.getEvaluator(Collections.emptyMap()).evaluate(this.table.getArrayValue(), null);
        if (!array.getClass().isArray()) {
            if (array instanceof java.sql.Array) {
                try {
                    array = ((java.sql.Array)array).getArray();
                }
                catch (SQLException e) {
                    throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30188, (Throwable)e);
                }
            } else {
                throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30189, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30189, new Object[]{array.getClass()}));
            }
        }
        for (int output : this.projectionIndexes) {
            TableFunctionReference.ProjectedColumn col = this.table.getColumns().get(output);
            try {
                Object val = Array.get(array, output);
                tuple.add(DataTypeManager.transformValue((Object)val, this.table.getColumns().get(output).getSymbol().getType()));
            }
            catch (TransformationException e) {
                throw new TeiidProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30190, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30190, new Object[]{col.getName()}));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID30191, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30191, new Object[]{output + 1}));
            }
        }
        this.addBatchRow(tuple);
        this.terminateBatches();
        return this.pullBatch();
    }
}

