/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.language.SQLConstants;
import org.teiid.metadata.BaseColumn;
import org.teiid.metadata.Column;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AlterProcedure;
import org.teiid.query.sql.lang.AlterTrigger;
import org.teiid.query.sql.lang.AlterView;
import org.teiid.query.sql.lang.ArrayTable;
import org.teiid.query.sql.lang.AtomicCriteria;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.WithQueryCommand;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BranchingStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TriggerAction;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.MultipleElementSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.symbol.TextLine;
import org.teiid.query.sql.symbol.WindowFunction;
import org.teiid.query.sql.symbol.WindowSpecification;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;

public class SQLStringVisitor
extends LanguageVisitor {
    public static final String UNDEFINED = "<undefined>";
    private static final String SPACE = " ";
    private static final String BEGIN_HINT = "/*+";
    private static final String END_HINT = "*/";
    private static final char ID_ESCAPE_CHAR = '\"';
    protected StringBuilder parts = new StringBuilder();

    public static final String getSQLString(LanguageObject obj) {
        if (obj == null) {
            return UNDEFINED;
        }
        SQLStringVisitor visitor = new SQLStringVisitor();
        obj.acceptVisitor(visitor);
        return visitor.getSQLString();
    }

    public String getSQLString() {
        return this.parts.toString();
    }

    protected void visitNode(LanguageObject obj) {
        if (obj == null) {
            this.append(UNDEFINED);
            return;
        }
        obj.acceptVisitor(this);
    }

    protected void append(Object value) {
        this.parts.append(value);
    }

    protected void beginClause(int level) {
        this.append(SPACE);
    }

    @Override
    public void visit(BetweenCriteria obj) {
        this.visitNode(obj.getExpression());
        this.append(SPACE);
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(SPACE);
        }
        this.append("BETWEEN");
        this.append(SPACE);
        this.visitNode(obj.getLowerExpression());
        this.append(SPACE);
        this.append("AND");
        this.append(SPACE);
        this.visitNode(obj.getUpperExpression());
    }

    @Override
    public void visit(CaseExpression obj) {
        this.append("CASE");
        this.append(SPACE);
        this.visitNode(obj.getExpression());
        this.append(SPACE);
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.append("WHEN");
            this.append(SPACE);
            this.visitNode(obj.getWhenExpression(i));
            this.append(SPACE);
            this.append("THEN");
            this.append(SPACE);
            this.visitNode(obj.getThenExpression(i));
            this.append(SPACE);
        }
        if (obj.getElseExpression() != null) {
            this.append("ELSE");
            this.append(SPACE);
            this.visitNode(obj.getElseExpression());
            this.append(SPACE);
        }
        this.append("END");
    }

    @Override
    public void visit(CompareCriteria obj) {
        Expression leftExpression = obj.getLeftExpression();
        this.visitNode(leftExpression);
        this.append(SPACE);
        this.append(obj.getOperatorAsString());
        this.append(SPACE);
        Expression rightExpression = obj.getRightExpression();
        this.visitNode(rightExpression);
    }

    @Override
    public void visit(CompoundCriteria obj) {
        int operator = obj.getOperator();
        String operatorStr = "";
        if (operator == 0) {
            operatorStr = "AND";
        } else if (operator == 1) {
            operatorStr = "OR";
        }
        List<Criteria> subCriteria = obj.getCriteria();
        if (subCriteria.size() == 1) {
            Criteria firstChild = subCriteria.get(0);
            this.visitNode(firstChild);
        } else {
            Iterator<Criteria> iter = subCriteria.iterator();
            while (iter.hasNext()) {
                Criteria crit = iter.next();
                this.append("(");
                this.visitNode(crit);
                this.append(")");
                if (!iter.hasNext()) continue;
                this.append(SPACE);
                this.append(operatorStr);
                this.append(SPACE);
            }
        }
    }

    @Override
    public void visit(Delete obj) {
        this.append("DELETE");
        this.addSourceHint(obj.getSourceHint());
        this.append(SPACE);
        this.append("FROM");
        this.append(SPACE);
        this.visitNode(obj.getGroup());
        if (obj.getCriteria() != null) {
            this.beginClause(0);
            this.visitCriteria("WHERE", obj.getCriteria());
        }
        if (obj.getOption() != null) {
            this.beginClause(0);
            this.visitNode(obj.getOption());
        }
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        this.visitNode(obj.getExpression());
        this.append(SPACE);
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(SPACE);
        }
        this.append("IN");
        this.append(" (<dependent values>)");
    }

    @Override
    public void visit(From obj) {
        this.append("FROM");
        this.beginClause(1);
        this.registerNodes(obj.getClauses(), 0);
    }

    @Override
    public void visit(GroupBy obj) {
        this.append("GROUP");
        this.append(SPACE);
        this.append("BY");
        this.append(SPACE);
        this.registerNodes(obj.getSymbols(), 0);
    }

    @Override
    public void visit(Insert obj) {
        this.append("INSERT");
        this.addSourceHint(obj.getSourceHint());
        this.append(SPACE);
        this.append("INTO");
        this.append(SPACE);
        this.visitNode(obj.getGroup());
        if (!obj.getVariables().isEmpty()) {
            this.beginClause(2);
            List<ElementSymbol> vars = obj.getVariables();
            if (vars != null) {
                this.append("(");
                this.registerNodes(vars, 0);
                this.append(")");
            }
        }
        this.beginClause(1);
        if (obj.getQueryExpression() != null) {
            this.visitNode(obj.getQueryExpression());
        } else if (obj.getTupleSource() != null) {
            this.append("VALUES");
            this.append(" (...)");
        } else if (obj.getValues() != null) {
            this.append("VALUES");
            this.beginClause(2);
            this.append("(");
            this.registerNodes(obj.getValues(), 0);
            this.append(")");
        }
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
    }

    @Override
    public void visit(Create obj) {
        this.append("CREATE");
        this.append(SPACE);
        this.append("LOCAL");
        this.append(SPACE);
        this.append("TEMPORARY");
        this.append(SPACE);
        this.append("TABLE");
        this.append(SPACE);
        this.visitNode(obj.getTable());
        this.append(SPACE);
        List<Column> columns = obj.getColumns();
        this.append("(");
        Iterator<Column> iter = columns.iterator();
        while (iter.hasNext()) {
            Column element = iter.next();
            this.outputDisplayName(element.getName());
            this.append(SPACE);
            if (element.isAutoIncremented()) {
                this.append("SERIAL");
            } else {
                this.append(element.getRuntimeType());
                if (element.getNullType() == BaseColumn.NullType.No_Nulls) {
                    this.append("NOT");
                    this.append(SPACE);
                    this.append("NULL");
                }
            }
            if (!iter.hasNext()) continue;
            this.append(", ");
        }
        if (!obj.getPrimaryKey().isEmpty()) {
            this.append(", ");
            this.append("PRIMARY");
            this.append(SPACE);
            this.append("KEY");
            this.append("(");
            Iterator<ElementSymbol> pkiter = obj.getPrimaryKey().iterator();
            while (pkiter.hasNext()) {
                this.outputShortName(pkiter.next());
                if (!pkiter.hasNext()) continue;
                this.append(", ");
            }
            this.append(")");
        }
        this.append(")");
    }

    @Override
    public void visit(Drop obj) {
        this.append("DROP");
        this.append(SPACE);
        this.append("TABLE");
        this.append(SPACE);
        this.visitNode(obj.getTable());
    }

    @Override
    public void visit(IsNullCriteria obj) {
        Expression expr = obj.getExpression();
        this.visitNode(expr);
        this.append(SPACE);
        this.append("IS");
        this.append(SPACE);
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(SPACE);
        }
        this.append("NULL");
    }

    @Override
    public void visit(JoinPredicate obj) {
        FromClause leftClause;
        this.addHintComment(obj);
        if (obj.hasHint()) {
            this.append("(");
        }
        if ((leftClause = obj.getLeftClause()) instanceof JoinPredicate && !((JoinPredicate)leftClause).hasHint()) {
            this.append("(");
            this.visitNode(leftClause);
            this.append(")");
        } else {
            this.visitNode(leftClause);
        }
        this.append(SPACE);
        this.visitNode(obj.getJoinType());
        this.append(SPACE);
        FromClause rightClause = obj.getRightClause();
        if (rightClause instanceof JoinPredicate && !((JoinPredicate)rightClause).hasHint()) {
            this.append("(");
            this.visitNode(rightClause);
            this.append(")");
        } else {
            this.visitNode(rightClause);
        }
        List joinCriteria = obj.getJoinCriteria();
        if (joinCriteria != null && joinCriteria.size() > 0) {
            this.append(SPACE);
            this.append("ON");
            this.append(SPACE);
            Iterator critIter = joinCriteria.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)critIter.next();
                if (crit instanceof PredicateCriteria || crit instanceof AtomicCriteria) {
                    this.visitNode(crit);
                } else {
                    this.append("(");
                    this.visitNode(crit);
                    this.append(")");
                }
                if (!critIter.hasNext()) continue;
                this.append(SPACE);
                this.append("AND");
                this.append(SPACE);
            }
        }
        if (obj.hasHint()) {
            this.append(")");
        }
    }

    private void addHintComment(FromClause obj) {
        if (obj.hasHint()) {
            this.append(BEGIN_HINT);
            this.append(SPACE);
            if (obj.isOptional()) {
                this.append("optional");
                this.append(SPACE);
            }
            if (obj.isMakeDep()) {
                this.append("MAKEDEP");
                this.append(SPACE);
            }
            if (obj.isMakeNotDep()) {
                this.append("MAKENOTDEP");
                this.append(SPACE);
            }
            if (obj.isMakeInd()) {
                this.append(FromClause.MAKEIND);
                this.append(SPACE);
            }
            if (obj.isNoUnnest()) {
                this.append(ExistsCriteria.SubqueryHint.NOUNNEST);
                this.append(SPACE);
            }
            this.append(END_HINT);
            this.append(SPACE);
        }
    }

    @Override
    public void visit(JoinType obj) {
        String[] output = null;
        if (obj.equals(JoinType.JOIN_INNER)) {
            output = new String[]{"INNER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_CROSS)) {
            output = new String[]{"CROSS", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_LEFT_OUTER)) {
            output = new String[]{"LEFT", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_RIGHT_OUTER)) {
            output = new String[]{"RIGHT", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_FULL_OUTER)) {
            output = new String[]{"FULL", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_UNION)) {
            output = new String[]{"UNION", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_SEMI)) {
            output = new String[]{"SEMI", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_ANTI_SEMI)) {
            output = new String[]{"ANTI SEMI", SPACE, "JOIN"};
        } else {
            throw new AssertionError();
        }
        for (String part : output) {
            this.append(part);
        }
    }

    @Override
    public void visit(MatchCriteria obj) {
        this.visitNode(obj.getLeftExpression());
        this.append(SPACE);
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(SPACE);
        }
        switch (obj.getMode()) {
            case SIMILAR: {
                this.append("SIMILAR");
                this.append(SPACE);
                this.append("TO");
                break;
            }
            case LIKE: {
                this.append("LIKE");
                break;
            }
            case REGEX: {
                this.append("LIKE_REGEX");
            }
        }
        this.append(SPACE);
        this.visitNode(obj.getRightExpression());
        if (obj.getEscapeChar() != '\u0000') {
            this.append(SPACE);
            this.append("ESCAPE");
            this.append(" '");
            this.append(String.valueOf(obj.getEscapeChar()));
            this.append("'");
        }
    }

    @Override
    public void visit(NotCriteria obj) {
        this.append("NOT");
        this.append(" (");
        this.visitNode(obj.getCriteria());
        this.append(")");
    }

    @Override
    public void visit(Option obj) {
        Iterator iter;
        this.append("OPTION");
        List<String> groups = obj.getDependentGroups();
        if (groups != null && groups.size() > 0) {
            this.append(SPACE);
            this.append("MAKEDEP");
            this.append(SPACE);
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.append(", ");
            }
        }
        if ((groups = obj.getNotDependentGroups()) != null && groups.size() > 0) {
            this.append(SPACE);
            this.append("MAKENOTDEP");
            this.append(SPACE);
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.append(", ");
            }
        }
        if ((groups = obj.getNoCacheGroups()) != null && groups.size() > 0) {
            this.append(SPACE);
            this.append("NOCACHE");
            this.append(SPACE);
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.append(", ");
            }
        } else if (obj.isNoCache()) {
            this.append(SPACE);
            this.append("NOCACHE");
        }
    }

    @Override
    public void visit(OrderBy obj) {
        this.append("ORDER");
        this.append(SPACE);
        this.append("BY");
        this.append(SPACE);
        this.registerNodes(obj.getOrderByItems(), 0);
    }

    @Override
    public void visit(OrderByItem obj) {
        Expression ses = obj.getSymbol();
        if (ses instanceof AliasSymbol) {
            AliasSymbol as = (AliasSymbol)ses;
            this.outputDisplayName(as.getOutputName());
        } else {
            this.visitNode(ses);
        }
        if (!obj.isAscending()) {
            this.append(SPACE);
            this.append("DESC");
        }
        if (obj.getNullOrdering() != null) {
            this.append(SPACE);
            this.append("NULLS");
            this.append(SPACE);
            this.append(obj.getNullOrdering().name());
        }
    }

    @Override
    public void visit(DynamicCommand obj) {
        this.append("EXECUTE");
        this.append(SPACE);
        this.append("IMMEDIATE");
        this.append(SPACE);
        this.visitNode(obj.getSql());
        if (obj.isAsClauseSet()) {
            this.beginClause(1);
            this.append("AS");
            this.append(SPACE);
            for (int i = 0; i < obj.getAsColumns().size(); ++i) {
                ElementSymbol symbol = (ElementSymbol)obj.getAsColumns().get(i);
                this.outputShortName(symbol);
                this.append(SPACE);
                this.append(DataTypeManager.getDataTypeName(symbol.getType()));
                if (i >= obj.getAsColumns().size() - 1) continue;
                this.append(", ");
            }
        }
        if (obj.getIntoGroup() != null) {
            this.beginClause(1);
            this.append("INTO");
            this.append(SPACE);
            this.visitNode(obj.getIntoGroup());
        }
        if (obj.getUsing() != null && !obj.getUsing().isEmpty()) {
            this.beginClause(1);
            this.append("USING");
            this.append(SPACE);
            this.visitNode(obj.getUsing());
        }
        if (obj.getUpdatingModelCount() > 0) {
            this.beginClause(1);
            this.append("UPDATE");
            this.append(SPACE);
            if (obj.getUpdatingModelCount() > 1) {
                this.append("*");
            } else {
                this.append("1");
            }
        }
    }

    @Override
    public void visit(SetClauseList obj) {
        Iterator<SetClause> iterator = obj.getClauses().iterator();
        while (iterator.hasNext()) {
            SetClause clause = iterator.next();
            this.visitNode(clause);
            if (!iterator.hasNext()) continue;
            this.append(", ");
        }
    }

    @Override
    public void visit(SetClause obj) {
        ElementSymbol symbol = obj.getSymbol();
        this.outputShortName(symbol);
        this.append(" = ");
        this.visitNode(obj.getValue());
    }

    @Override
    public void visit(WithQueryCommand obj) {
        this.visitNode(obj.getGroupSymbol());
        this.append(SPACE);
        if (obj.getColumns() != null && !obj.getColumns().isEmpty()) {
            this.append("(");
            this.registerNodes(obj.getColumns(), 0);
            this.append(")");
            this.append(SPACE);
        }
        this.append("AS");
        this.append(SPACE);
        this.append("(");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    @Override
    public void visit(Query obj) {
        this.addCacheHint(obj.getCacheHint());
        this.addWithClause(obj);
        this.append("SELECT");
        SourceHint sh = obj.getSourceHint();
        this.addSourceHint(sh);
        if (obj.getSelect() != null) {
            this.visitNode(obj.getSelect());
        }
        if (obj.getInto() != null) {
            this.beginClause(1);
            this.visitNode(obj.getInto());
        }
        if (obj.getFrom() != null) {
            this.beginClause(1);
            this.visitNode(obj.getFrom());
        }
        if (obj.getCriteria() != null) {
            this.beginClause(1);
            this.visitCriteria("WHERE", obj.getCriteria());
        }
        if (obj.getGroupBy() != null) {
            this.beginClause(1);
            this.visitNode(obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.beginClause(1);
            this.visitCriteria("HAVING", obj.getHaving());
        }
        if (obj.getOrderBy() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.beginClause(1);
            this.visitNode(obj.getLimit());
        }
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
    }

    private void addSourceHint(SourceHint sh) {
        if (sh != null) {
            this.append(SPACE);
            this.append(BEGIN_HINT);
            this.append("sh");
            if (sh.getGeneralHint() != null) {
                this.appendSourceHintValue(sh.getGeneralHint());
            }
            if (sh.getSourceHints() != null) {
                for (Map.Entry<String, String> entry : sh.getSourceHints().entrySet()) {
                    this.append(entry.getKey());
                    this.appendSourceHintValue(entry.getValue());
                }
            }
            this.append(END_HINT);
        }
    }

    private void addWithClause(QueryCommand obj) {
        if (obj.getWith() != null) {
            this.append("WITH");
            this.append(SPACE);
            this.registerNodes(obj.getWith(), 0);
            this.beginClause(0);
        }
    }

    protected void visitCriteria(String keyWord, Criteria crit) {
        this.append(keyWord);
        this.append(SPACE);
        this.visitNode(crit);
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        this.append("CASE");
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.append(SPACE);
            this.append("WHEN");
            this.append(SPACE);
            this.visitNode(obj.getWhenCriteria(i));
            this.append(SPACE);
            this.append("THEN");
            this.append(SPACE);
            this.visitNode(obj.getThenExpression(i));
        }
        this.append(SPACE);
        if (obj.getElseExpression() != null) {
            this.append("ELSE");
            this.append(SPACE);
            this.visitNode(obj.getElseExpression());
            this.append(SPACE);
        }
        this.append("END");
    }

    @Override
    public void visit(Select obj) {
        if (obj.isDistinct()) {
            this.append(SPACE);
            this.append("DISTINCT");
        }
        this.beginClause(2);
        Iterator<Expression> iter = obj.getSymbols().iterator();
        while (iter.hasNext()) {
            Expression symbol = iter.next();
            this.visitNode(symbol);
            if (!iter.hasNext()) continue;
            this.append(", ");
        }
    }

    private void appendSourceHintValue(String sh) {
        this.append(":");
        this.append(Character.valueOf('\''));
        this.append(SQLStringVisitor.escapeStringValue(sh, "'"));
        this.append(Character.valueOf('\''));
        this.append(SPACE);
    }

    @Override
    public void visit(SetCriteria obj) {
        this.visitNode(obj.getExpression());
        this.append(SPACE);
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(SPACE);
        }
        this.append("IN");
        this.append(" (");
        Collection vals = obj.getValues();
        int size = vals.size();
        if (size == 1) {
            Iterator iter = vals.iterator();
            Expression expr = (Expression)iter.next();
            this.visitNode(expr);
        } else if (size > 1) {
            Iterator iter = vals.iterator();
            Expression expr = (Expression)iter.next();
            this.visitNode(expr);
            while (iter.hasNext()) {
                expr = (Expression)iter.next();
                this.append(", ");
                this.visitNode(expr);
            }
        }
        this.append(")");
    }

    @Override
    public void visit(SetQuery obj) {
        this.addCacheHint(obj.getCacheHint());
        this.addWithClause(obj);
        QueryCommand query = obj.getLeftQuery();
        this.appendSetQuery(obj, query, false);
        this.beginClause(0);
        this.append((Object)obj.getOperation());
        if (obj.isAll()) {
            this.append(SPACE);
            this.append("ALL");
        }
        this.beginClause(0);
        query = obj.getRightQuery();
        this.appendSetQuery(obj, query, true);
        if (obj.getOrderBy() != null) {
            this.beginClause(0);
            this.visitNode(obj.getOrderBy());
        }
        if (obj.getLimit() != null) {
            this.beginClause(0);
            this.visitNode(obj.getLimit());
        }
        if (obj.getOption() != null) {
            this.beginClause(0);
            this.visitNode(obj.getOption());
        }
    }

    protected void appendSetQuery(SetQuery parent, QueryCommand obj, boolean right) {
        if (obj.getLimit() != null || obj.getOrderBy() != null || right && obj instanceof SetQuery && (parent.isAll() && !((SetQuery)obj).isAll() || parent.getOperation() != ((SetQuery)obj).getOperation())) {
            this.append("(");
            this.visitNode(obj);
            this.append(")");
        } else {
            this.visitNode(obj);
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.addCacheHint(obj.getCacheHint());
        if (obj.isCalledWithReturn()) {
            for (SPParameter param : obj.getParameters()) {
                if (param.getParameterType() != 4) continue;
                if (param.getExpression() == null) {
                    this.append("?");
                    continue;
                }
                this.visitNode(param.getExpression());
            }
            this.append(SPACE);
            this.append("=");
            this.append(SPACE);
        }
        this.append("EXEC");
        this.append(SPACE);
        this.append(obj.getProcedureName());
        this.append("(");
        boolean first = true;
        for (SPParameter param : obj.getParameters()) {
            boolean addParens;
            if (param.isUsingDefault() || param.getParameterType() == 4 || param.getParameterType() == 5 || param.getExpression() == null) continue;
            if (first) {
                first = false;
            } else {
                this.append(", ");
            }
            if (obj.displayNamedParameters()) {
                this.append(SQLStringVisitor.escapeSinglePart(Symbol.getShortName(param.getParameterSymbol().getOutputName())));
                this.append(" => ");
            }
            boolean bl = addParens = !obj.displayNamedParameters() && param.getExpression() instanceof CompareCriteria;
            if (addParens) {
                this.append("(");
            }
            this.visitNode(param.getExpression());
            if (!addParens) continue;
            this.append(")");
        }
        this.append(")");
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
    }

    public void addCacheHint(CacheHint obj) {
        if (obj == null) {
            return;
        }
        this.append(BEGIN_HINT);
        this.append(SPACE);
        this.append("cache");
        boolean addParens = false;
        if (obj.getPrefersMemory()) {
            this.append("(");
            addParens = true;
            this.append("pref_mem");
        }
        if (obj.getTtl() != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(SPACE);
            }
            this.append("ttl:");
            this.append(obj.getTtl());
        }
        if (obj.isUpdatable()) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(SPACE);
            }
            this.append("updatable");
        }
        if (obj.getScope() != null) {
            if (!addParens) {
                this.append("(");
                addParens = true;
            } else {
                this.append(SPACE);
            }
            this.append("scope:");
            this.append(obj.getScope());
        }
        if (addParens) {
            this.append(")");
        }
        this.append(SPACE);
        this.append(END_HINT);
        this.beginClause(0);
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.addHintComment(obj);
        if (obj.isTable()) {
            this.append("TABLE");
        }
        this.append("(");
        this.visitNode(obj.getCommand());
        this.append(")");
        this.append(" AS ");
        this.append(obj.getOutputName());
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.visitNode(obj.getExpression());
        this.append(SPACE);
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(SPACE);
        }
        this.append("IN");
        this.addSubqueryHint(obj.getSubqueryHint());
        this.append(" (");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    @Override
    public void visit(UnaryFromClause obj) {
        this.addHintComment(obj);
        this.visitNode(obj.getGroup());
    }

    @Override
    public void visit(Update obj) {
        this.append("UPDATE");
        this.addSourceHint(obj.getSourceHint());
        this.append(SPACE);
        this.visitNode(obj.getGroup());
        this.beginClause(1);
        this.append("SET");
        this.beginClause(2);
        this.visitNode(obj.getChangeList());
        if (obj.getCriteria() != null) {
            this.beginClause(1);
            this.visitCriteria("WHERE", obj.getCriteria());
        }
        if (obj.getOption() != null) {
            this.beginClause(1);
            this.visitNode(obj.getOption());
        }
    }

    @Override
    public void visit(Into obj) {
        this.append("INTO");
        this.append(SPACE);
        this.visitNode(obj.getGroup());
    }

    @Override
    public void visit(AggregateSymbol obj) {
        this.append(obj.getName());
        this.append("(");
        if (obj.isDistinct()) {
            this.append("DISTINCT");
            this.append(SPACE);
        } else if (obj.getAggregateFunction() == AggregateSymbol.Type.USER_DEFINED) {
            this.append("ALL");
            this.append(SPACE);
        }
        if (obj.getArgs().length == 0) {
            if (obj.getAggregateFunction() == AggregateSymbol.Type.COUNT) {
                this.append("*");
            }
        } else {
            this.registerNodes(obj.getArgs(), 0);
        }
        if (obj.getOrderBy() != null) {
            this.append(SPACE);
            this.visitNode(obj.getOrderBy());
        }
        this.append(")");
        if (obj.getCondition() != null) {
            this.append(SPACE);
            this.append("FILTER");
            this.append("(");
            this.append("WHERE");
            this.append(SPACE);
            this.append(obj.getCondition());
            this.append(")");
        }
    }

    @Override
    public void visit(AliasSymbol obj) {
        this.visitNode(obj.getSymbol());
        this.append(SPACE);
        this.append("AS");
        this.append(SPACE);
        this.append(SQLStringVisitor.escapeSinglePart(obj.getOutputName()));
    }

    @Override
    public void visit(MultipleElementSymbol obj) {
        if (obj.getGroup() == null) {
            this.append("*");
        } else {
            this.visitNode(obj.getGroup());
            this.append(".");
            this.append("*");
        }
    }

    @Override
    public void visit(Constant obj) {
        Class<?> type = obj.getType();
        String[] constantParts = null;
        if (obj.isMultiValued()) {
            constantParts = new String[]{"?"};
        } else if (obj.isNull()) {
            constantParts = type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN) ? new String[]{"UNKNOWN"} : new String[]{"null"};
        } else {
            if (Number.class.isAssignableFrom(type)) {
                constantParts = new String[]{obj.getValue().toString()};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
                constantParts = new String[]{obj.getValue().equals(Boolean.TRUE) ? "TRUE" : "FALSE"};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                constantParts = new String[]{"{ts'", obj.getValue().toString(), "'}"};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                constantParts = new String[]{"{t'", obj.getValue().toString(), "'}"};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                constantParts = new String[]{"{d'", obj.getValue().toString(), "'}"};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.VARBINARY)) {
                constantParts = new String[]{"X'", obj.getValue().toString(), "'"};
            }
            if (constantParts == null) {
                String strValue = obj.getValue().toString();
                strValue = SQLStringVisitor.escapeStringValue(strValue, "'");
                constantParts = new String[]{"'", strValue, "'"};
            }
        }
        for (String string : constantParts) {
            this.append(string);
        }
    }

    static String escapeStringValue(String str, String tick) {
        return StringUtil.replaceAll((String)str, (String)tick, (String)(tick + tick));
    }

    @Override
    public void visit(ElementSymbol obj) {
        if (obj.getDisplayMode().equals((Object)ElementSymbol.DisplayMode.SHORT_OUTPUT_NAME)) {
            this.outputShortName(obj);
            return;
        }
        String name = obj.getOutputName();
        if (obj.getDisplayMode().equals((Object)ElementSymbol.DisplayMode.FULLY_QUALIFIED)) {
            name = obj.getName();
        }
        this.outputDisplayName(name);
    }

    private void outputShortName(ElementSymbol obj) {
        this.outputDisplayName(Symbol.getShortName(obj.getOutputName()));
    }

    private void outputDisplayName(String name) {
        String[] pathParts = name.split("\\.");
        for (int i = 0; i < pathParts.length; ++i) {
            if (i > 0) {
                this.append(".");
            }
            this.append(SQLStringVisitor.escapeSinglePart(pathParts[i]));
        }
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        this.visitNode(obj.getExpression());
    }

    @Override
    public void visit(Function obj) {
        String name = obj.getName();
        LanguageObject[] args = obj.getArgs();
        if (obj.isImplicit()) {
            this.visitNode(args[0]);
        } else if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            this.append(name);
            this.append("(");
            if (args != null && args.length > 0) {
                this.visitNode(args[0]);
                if (name.equalsIgnoreCase("CONVERT")) {
                    this.append(", ");
                } else {
                    this.append(SPACE);
                    this.append("AS");
                    this.append(SPACE);
                }
                if (args.length < 2 || args[1] == null || !(args[1] instanceof Constant)) {
                    this.append(UNDEFINED);
                } else {
                    this.append(((Constant)args[1]).getValue());
                }
            }
            this.append(")");
        } else if (name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
            this.append("(");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    this.visitNode(args[i]);
                    if (i >= args.length - 1) continue;
                    this.append(SPACE);
                    this.append(name);
                    this.append(SPACE);
                }
            }
            this.append(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.append(name);
            this.append("(");
            if (args != null && args.length > 0) {
                this.append(((Constant)args[0]).getValue());
                this.registerNodes(args, 1);
            }
            this.append(")");
        } else if (name.equalsIgnoreCase("xmlpi")) {
            this.append(name);
            this.append("(NAME ");
            this.outputDisplayName((String)((Constant)args[0]).getValue());
            this.registerNodes(args, 1);
            this.append(")");
        } else if (name.equalsIgnoreCase("trim")) {
            this.append(name);
            this.append("(");
            String value = (String)((Constant)args[0]).getValue();
            if (!value.equalsIgnoreCase("BOTH")) {
                this.append(((Constant)args[0]).getValue());
                this.append(SPACE);
            }
            this.append(args[1]);
            this.append(SPACE);
            this.append("FROM");
            this.append(SPACE);
            this.append(args[2]);
            this.append(")");
        } else {
            this.append(name);
            this.append("(");
            this.registerNodes(args, 0);
            this.append(")");
        }
    }

    private void registerNodes(LanguageObject[] objects, int begin) {
        this.registerNodes(Arrays.asList(objects), begin);
    }

    private void registerNodes(List<? extends LanguageObject> objects, int begin) {
        for (int i = begin; i < objects.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            this.visitNode(objects.get(i));
        }
    }

    @Override
    public void visit(GroupSymbol obj) {
        String alias = null;
        String fullGroup = obj.getOutputName();
        if (obj.getOutputDefinition() != null) {
            alias = obj.getOutputName();
            fullGroup = obj.getOutputDefinition();
        }
        this.outputDisplayName(fullGroup);
        if (alias != null) {
            this.append(SPACE);
            this.append("AS");
            this.append(SPACE);
            this.append(SQLStringVisitor.escapeSinglePart(alias));
        }
    }

    @Override
    public void visit(Reference obj) {
        if (!obj.isPositional() && obj.getExpression() != null) {
            this.visitNode(obj.getExpression());
        } else {
            this.append("?");
        }
    }

    @Override
    public void visit(Block obj) {
        this.addLabel(obj);
        List<Statement> statements = obj.getStatements();
        this.append("BEGIN");
        if (obj.isAtomic()) {
            this.append(SPACE);
            this.append("ATOMIC");
        }
        this.append("\n");
        Iterator<Statement> stmtIter = statements.iterator();
        while (stmtIter.hasNext()) {
            this.addTabs(1);
            this.visitNode(stmtIter.next());
            this.append("\n");
        }
        this.addTabs(0);
        this.append("END");
    }

    private void addLabel(Statement.Labeled obj) {
        if (obj.getLabel() != null) {
            this.outputDisplayName(obj.getLabel());
            this.append(SPACE);
            this.append(":");
            this.append(SPACE);
        }
    }

    protected void addTabs(int level) {
    }

    @Override
    public void visit(CommandStatement obj) {
        this.visitNode(obj.getCommand());
        this.append(";");
    }

    @Override
    public void visit(CreateProcedureCommand obj) {
        this.addCacheHint(obj.getCacheHint());
        this.append("CREATE");
        this.append(SPACE);
        this.append("VIRTUAL");
        this.append(SPACE);
        this.append("PROCEDURE");
        this.append("\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
    }

    @Override
    public void visit(DeclareStatement obj) {
        this.append("DECLARE");
        this.append(SPACE);
        this.append(obj.getVariableType());
        this.append(SPACE);
        this.createAssignment(obj);
    }

    private void createAssignment(AssignmentStatement obj) {
        this.visitNode(obj.getVariable());
        if (obj.getExpression() != null) {
            this.append(" = ");
            this.visitNode(obj.getExpression());
        }
        this.append(";");
    }

    @Override
    public void visit(IfStatement obj) {
        this.append("IF");
        this.append("(");
        this.visitNode(obj.getCondition());
        this.append(")\n");
        this.addTabs(0);
        this.visitNode(obj.getIfBlock());
        if (obj.hasElseBlock()) {
            this.append("\n");
            this.addTabs(0);
            this.append("ELSE");
            this.append("\n");
            this.addTabs(0);
            this.visitNode(obj.getElseBlock());
        }
    }

    @Override
    public void visit(AssignmentStatement obj) {
        this.createAssignment(obj);
    }

    @Override
    public void visit(RaiseErrorStatement obj) {
        this.append("ERROR");
        this.append(SPACE);
        this.visitNode(obj.getExpression());
        this.append(";");
    }

    @Override
    public void visit(BranchingStatement obj) {
        switch (obj.getMode()) {
            case CONTINUE: {
                this.append("CONTINUE");
                break;
            }
            case BREAK: {
                this.append("BREAK");
                break;
            }
            case LEAVE: {
                this.append("LEAVE");
            }
        }
        if (obj.getLabel() != null) {
            this.append(SPACE);
            this.outputDisplayName(obj.getLabel());
        }
        this.append(";");
    }

    @Override
    public void visit(LoopStatement obj) {
        this.addLabel(obj);
        this.append("LOOP");
        this.append(SPACE);
        this.append("ON");
        this.append(" (");
        this.visitNode(obj.getCommand());
        this.append(") ");
        this.append("AS");
        this.append(SPACE);
        this.append(obj.getCursorName());
        this.append("\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
    }

    @Override
    public void visit(WhileStatement obj) {
        this.addLabel(obj);
        this.append("WHILE");
        this.append("(");
        this.visitNode(obj.getCondition());
        this.append(")\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
    }

    @Override
    public void visit(ExistsCriteria obj) {
        if (obj.isNegated()) {
            this.append("NOT");
            this.append(SPACE);
        }
        this.append("EXISTS");
        this.addSubqueryHint(obj.getSubqueryHint());
        this.append(" (");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    public void addSubqueryHint(ExistsCriteria.SubqueryHint hint) {
        if (hint.isNoUnnest()) {
            this.append(SPACE);
            this.append(BEGIN_HINT);
            this.append(SPACE);
            this.append(ExistsCriteria.SubqueryHint.NOUNNEST);
            this.append(SPACE);
            this.append(END_HINT);
        } else if (hint.isDepJoin()) {
            this.append(SPACE);
            this.append(BEGIN_HINT);
            this.append(SPACE);
            this.append(ExistsCriteria.SubqueryHint.DJ);
            this.append(SPACE);
            this.append(END_HINT);
        } else if (hint.isMergeJoin()) {
            this.append(SPACE);
            this.append(BEGIN_HINT);
            this.append(SPACE);
            this.append(ExistsCriteria.SubqueryHint.MJ);
            this.append(SPACE);
            this.append(END_HINT);
        }
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        Expression leftExpression = obj.getLeftExpression();
        this.visitNode(leftExpression);
        String operator = obj.getOperatorAsString();
        String quantifier = obj.getPredicateQuantifierAsString();
        this.append(SPACE);
        this.append(operator);
        this.append(SPACE);
        this.append(quantifier);
        this.append("(");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.append("(");
        this.visitNode(obj.getCommand());
        this.append(")");
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.append("XMLATTRIBUTES");
        this.append("(");
        this.registerNodes(obj.getArgs(), 0);
        this.append(")");
    }

    @Override
    public void visit(XMLElement obj) {
        this.append("XMLELEMENT");
        this.append("(NAME ");
        this.outputDisplayName(obj.getName());
        if (obj.getNamespaces() != null) {
            this.append(", ");
            this.visitNode(obj.getNamespaces());
        }
        if (obj.getAttributes() != null) {
            this.append(", ");
            this.visitNode(obj.getAttributes());
        }
        if (!obj.getContent().isEmpty()) {
            this.append(", ");
        }
        this.registerNodes(obj.getContent(), 0);
        this.append(")");
    }

    @Override
    public void visit(XMLForest obj) {
        this.append("XMLFOREST");
        this.append("(");
        if (obj.getNamespaces() != null) {
            this.visitNode(obj.getNamespaces());
            this.append(", ");
        }
        this.registerNodes(obj.getArgs(), 0);
        this.append(")");
    }

    @Override
    public void visit(TextLine obj) {
        this.append("FOR");
        this.append(SPACE);
        this.registerNodes(obj.getExpressions(), 0);
        if (obj.getDelimiter() != null) {
            this.append(SPACE);
            this.append("DELIMITER");
            this.append(SPACE);
            this.visitNode(new Constant(obj.getDelimiter()));
        }
        if (obj.getQuote() != null) {
            this.append(SPACE);
            this.append("QUOTE");
            this.append(SPACE);
            this.visitNode(new Constant(obj.getQuote()));
        }
        if (obj.isIncludeHeader()) {
            this.append(SPACE);
            this.append("HEADER");
        }
        if (obj.getEncoding() != null) {
            this.append(SPACE);
            this.append("ENCODING");
            this.append(SPACE);
            this.outputDisplayName(obj.getEncoding());
        }
    }

    @Override
    public void visit(XMLNamespaces obj) {
        this.append("XMLNAMESPACES");
        this.append("(");
        Iterator<XMLNamespaces.NamespaceItem> items = obj.getNamespaceItems().iterator();
        while (items.hasNext()) {
            XMLNamespaces.NamespaceItem item = items.next();
            if (item.getPrefix() == null) {
                if (item.getUri() == null) {
                    this.append("NO DEFAULT");
                } else {
                    this.append("DEFAULT ");
                    this.visitNode(new Constant(item.getUri()));
                }
            } else {
                this.visitNode(new Constant(item.getUri()));
                this.append(" AS ");
                this.outputDisplayName(item.getPrefix());
            }
            if (!items.hasNext()) continue;
            this.append(", ");
        }
        this.append(")");
    }

    @Override
    public void visit(Limit obj) {
        if (!obj.isStrict()) {
            this.append(BEGIN_HINT);
            this.append(SPACE);
            this.append(Limit.NON_STRICT);
            this.append(SPACE);
            this.append(END_HINT);
            this.append(SPACE);
        }
        if (obj.getRowLimit() == null) {
            this.append("OFFSET");
            this.append(SPACE);
            this.visitNode(obj.getOffset());
            this.append(SPACE);
            this.append("ROWS");
            return;
        }
        this.append("LIMIT");
        if (obj.getOffset() != null) {
            this.append(SPACE);
            this.visitNode(obj.getOffset());
            this.append(",");
        }
        this.append(SPACE);
        this.visitNode(obj.getRowLimit());
    }

    @Override
    public void visit(TextTable obj) {
        this.addHintComment(obj);
        this.append("TEXTTABLE(");
        this.visitNode(obj.getFile());
        if (obj.getSelector() != null) {
            this.append(SPACE);
            this.append("SELECTOR");
            this.append(SPACE);
            this.append(SQLStringVisitor.escapeSinglePart(obj.getSelector()));
        }
        this.append(SPACE);
        this.append("COLUMNS");
        Iterator<TextTable.TextColumn> cols = obj.getColumns().iterator();
        while (cols.hasNext()) {
            TextTable.TextColumn col = cols.next();
            this.append(SPACE);
            this.outputDisplayName(col.getName());
            this.append(SPACE);
            this.append(col.getType());
            if (col.getWidth() != null) {
                this.append(SPACE);
                this.append("WIDTH");
                this.append(SPACE);
                this.append(col.getWidth());
            }
            if (col.isNoTrim()) {
                this.append(SPACE);
                this.append("NO");
                this.append(SPACE);
                this.append("TRIM");
            }
            if (col.getSelector() != null) {
                this.append(SPACE);
                this.append("SELECTOR");
                this.append(SPACE);
                this.append(SQLStringVisitor.escapeSinglePart(col.getSelector()));
                this.append(SPACE);
                this.append(col.getPosition());
            }
            if (!cols.hasNext()) continue;
            this.append(",");
        }
        if (!obj.isUsingRowDelimiter()) {
            this.append(SPACE);
            this.append("NO");
            this.append(SPACE);
            this.append("ROW");
            this.append(SPACE);
            this.append("DELIMITER");
        }
        if (obj.getDelimiter() != null) {
            this.append(SPACE);
            this.append("DELIMITER");
            this.append(SPACE);
            this.visitNode(new Constant(obj.getDelimiter()));
        }
        if (obj.getQuote() != null) {
            this.append(SPACE);
            if (obj.isEscape()) {
                this.append("ESCAPE");
            } else {
                this.append("QUOTE");
            }
            this.append(SPACE);
            this.visitNode(new Constant(obj.getQuote()));
        }
        if (obj.getHeader() != null) {
            this.append(SPACE);
            this.append("HEADER");
            if (1 != obj.getHeader()) {
                this.append(SPACE);
                this.append(obj.getHeader());
            }
        }
        if (obj.getSkip() != null) {
            this.append(SPACE);
            this.append("SKIP");
            this.append(SPACE);
            this.append(obj.getSkip());
        }
        this.append(")");
        this.append(SPACE);
        this.append("AS");
        this.append(SPACE);
        this.outputDisplayName(obj.getName());
    }

    @Override
    public void visit(XMLTable obj) {
        this.addHintComment(obj);
        this.append("XMLTABLE(");
        if (obj.getNamespaces() != null) {
            this.visitNode(obj.getNamespaces());
            this.append(",");
            this.append(SPACE);
        }
        this.visitNode(new Constant(obj.getXquery()));
        if (!obj.getPassing().isEmpty()) {
            this.append(SPACE);
            this.append("PASSING");
            this.append(SPACE);
            this.registerNodes(obj.getPassing(), 0);
        }
        if (!obj.getColumns().isEmpty()) {
            this.append(SPACE);
            this.append("COLUMNS");
            Iterator<XMLTable.XMLColumn> cols = obj.getColumns().iterator();
            while (cols.hasNext()) {
                XMLTable.XMLColumn col = cols.next();
                this.append(SPACE);
                this.outputDisplayName(col.getName());
                this.append(SPACE);
                if (col.isOrdinal()) {
                    this.append("FOR");
                    this.append(SPACE);
                    this.append("ORDINALITY");
                } else {
                    this.append(col.getType());
                    if (col.getDefaultExpression() != null) {
                        this.append(SPACE);
                        this.append("DEFAULT");
                        this.append(SPACE);
                        this.visitNode(col.getDefaultExpression());
                    }
                    if (col.getPath() != null) {
                        this.append(SPACE);
                        this.append("PATH");
                        this.append(SPACE);
                        this.visitNode(new Constant(col.getPath()));
                    }
                }
                if (!cols.hasNext()) continue;
                this.append(",");
            }
        }
        this.append(")");
        this.append(SPACE);
        this.append("AS");
        this.append(SPACE);
        this.outputDisplayName(obj.getName());
    }

    @Override
    public void visit(XMLQuery obj) {
        this.append("XMLQUERY(");
        if (obj.getNamespaces() != null) {
            this.visitNode(obj.getNamespaces());
            this.append(",");
            this.append(SPACE);
        }
        this.visitNode(new Constant(obj.getXquery()));
        if (!obj.getPassing().isEmpty()) {
            this.append(SPACE);
            this.append("PASSING");
            this.append(SPACE);
            this.registerNodes(obj.getPassing(), 0);
        }
        if (obj.getEmptyOnEmpty() != null) {
            this.append(SPACE);
            if (obj.getEmptyOnEmpty().booleanValue()) {
                this.append("EMPTY");
            } else {
                this.append("NULL");
            }
            this.append(SPACE);
            this.append("ON");
            this.append(SPACE);
            this.append("EMPTY");
        }
        this.append(")");
    }

    @Override
    public void visit(DerivedColumn obj) {
        this.visitNode(obj.getExpression());
        if (obj.getAlias() != null) {
            this.append(SPACE);
            this.append("AS");
            this.append(SPACE);
            this.outputDisplayName(obj.getAlias());
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        this.append("XMLSERIALIZE");
        this.append("(");
        if (obj.isDocument() != null) {
            if (obj.isDocument().booleanValue()) {
                this.append("DOCUMENT");
            } else {
                this.append("CONTENT");
            }
            this.append(SPACE);
        }
        this.visitNode(obj.getExpression());
        if (obj.getTypeString() != null) {
            this.append(SPACE);
            this.append("AS");
            this.append(SPACE);
            this.append(obj.getTypeString());
        }
        this.append(")");
    }

    @Override
    public void visit(QueryString obj) {
        this.append("QUERYSTRING");
        this.append("(");
        this.visitNode(obj.getPath());
        if (!obj.getArgs().isEmpty()) {
            this.append(",");
            this.append(SPACE);
            this.registerNodes(obj.getArgs(), 0);
        }
        this.append(")");
    }

    @Override
    public void visit(XMLParse obj) {
        this.append("XMLPARSE");
        this.append("(");
        if (obj.isDocument()) {
            this.append("DOCUMENT");
        } else {
            this.append("CONTENT");
        }
        this.append(SPACE);
        this.visitNode(obj.getExpression());
        if (obj.isWellFormed()) {
            this.append(SPACE);
            this.append("WELLFORMED");
        }
        this.append(")");
    }

    @Override
    public void visit(ExpressionCriteria obj) {
        this.visitNode(obj.getExpression());
    }

    @Override
    public void visit(TriggerAction obj) {
        this.append("FOR");
        this.append(SPACE);
        this.append("EACH");
        this.append(SPACE);
        this.append("ROW");
        this.append("\n");
        this.addTabs(0);
        this.visitNode(obj.getBlock());
    }

    @Override
    public void visit(ArrayTable obj) {
        this.addHintComment(obj);
        this.append("ARRAYTABLE(");
        this.visitNode(obj.getArrayValue());
        this.append(SPACE);
        this.append("COLUMNS");
        Iterator<TableFunctionReference.ProjectedColumn> cols = obj.getColumns().iterator();
        while (cols.hasNext()) {
            TableFunctionReference.ProjectedColumn col = cols.next();
            this.append(SPACE);
            this.outputDisplayName(col.getName());
            this.append(SPACE);
            this.append(col.getType());
            if (!cols.hasNext()) continue;
            this.append(",");
        }
        this.append(")");
        this.append(SPACE);
        this.append("AS");
        this.append(SPACE);
        this.outputDisplayName(obj.getName());
    }

    @Override
    public void visit(AlterProcedure alterProcedure) {
        this.append("ALTER");
        this.append(SPACE);
        this.append("PROCEDURE");
        this.append(SPACE);
        this.append(alterProcedure.getTarget());
        this.beginClause(1);
        this.append("AS");
        this.addCacheHint(alterProcedure.getCacheHint());
        this.append(((CreateProcedureCommand)alterProcedure.getDefinition()).getBlock());
    }

    @Override
    public void visit(AlterTrigger alterTrigger) {
        if (alterTrigger.isCreate()) {
            this.append("CREATE");
        } else {
            this.append("ALTER");
        }
        this.append(SPACE);
        this.append("TRIGGER");
        this.append(SPACE);
        this.append("ON");
        this.append(SPACE);
        this.append(alterTrigger.getTarget());
        this.beginClause(0);
        this.append("INSTEAD");
        this.append(SPACE);
        this.append("OF");
        this.append(SPACE);
        this.append(alterTrigger.getEvent());
        if (alterTrigger.getDefinition() != null) {
            this.beginClause(0);
            this.append("AS");
            this.append("\n");
            this.addTabs(0);
            this.append(alterTrigger.getDefinition());
        } else {
            this.append(SPACE);
            this.append(alterTrigger.getEnabled() != false ? "ENABLED" : "DISABLED");
        }
    }

    @Override
    public void visit(AlterView alterView) {
        this.append("ALTER");
        this.append(SPACE);
        this.append("VIEW");
        this.append(SPACE);
        this.append(alterView.getTarget());
        this.beginClause(0);
        this.append("AS");
        this.append("\n");
        this.addTabs(0);
        this.append(alterView.getDefinition());
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        this.append(windowFunction.getFunction());
        this.append(SPACE);
        this.append("OVER");
        this.append(SPACE);
        this.append(windowFunction.getWindowSpecification());
    }

    @Override
    public void visit(WindowSpecification windowSpecification) {
        this.append("(");
        boolean needsSpace = false;
        if (windowSpecification.getPartition() != null) {
            this.append("PARTITION");
            this.append(SPACE);
            this.append("BY");
            this.append(SPACE);
            this.registerNodes(windowSpecification.getPartition(), 0);
            needsSpace = true;
        }
        if (windowSpecification.getOrderBy() != null) {
            if (needsSpace) {
                this.append(SPACE);
            }
            this.append(windowSpecification.getOrderBy());
        }
        this.append(")");
    }

    public static String escapeSinglePart(String part) {
        if (SQLStringVisitor.isReservedWord(part)) {
            return '\"' + part + '\"';
        }
        boolean escape = true;
        char start = part.charAt(0);
        if (start == '#' || start == '@' || StringUtil.isLetter((char)start)) {
            escape = false;
            for (int i = 1; !escape && i < part.length(); ++i) {
                char c = part.charAt(i);
                escape = !StringUtil.isLetterOrDigit((char)c) && c != '_';
            }
        }
        if (escape) {
            return '\"' + SQLStringVisitor.escapeStringValue(part, "\"") + '\"';
        }
        return part;
    }

    static boolean isReservedWord(String string) {
        if (string == null) {
            return false;
        }
        return SQLConstants.isReservedWord((String)string);
    }
}

