/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.security.auth.Subject;
import org.teiid.CommandListener;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.VDB;
import org.teiid.api.exception.query.QueryProcessingException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.ExecutorUtils;
import org.teiid.core.util.LRUCache;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.logging.LogManager;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.eval.SecurityFunctionEvaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.parser.ParseInfo;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.sql.lang.SourceHint;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.translator.ReusableExecution;

public class CommandContext
implements Cloneable,
org.teiid.CommandContext {
    private GlobalState globalState = new GlobalState();
    private VariableContext variableContext = new VariableContext();
    private TempTableStore tempTableStore;
    private LinkedList<String> recursionStack;
    private boolean nonBlocking;
    private HashSet<Object> planningObjects;
    private HashSet<Object> dataObjects = GlobalState.access$100(this.globalState);

    public CommandContext(Object processorID, String connectionID, String userName, Serializable commandPayload, String vdbName, int vdbVersion, boolean collectNodeStatistics) {
        this.setProcessorID(processorID);
        this.setConnectionID(connectionID);
        this.setUserName(userName);
        this.setCommandPayload(commandPayload);
        this.setVdbName(vdbName);
        this.setVdbVersion(vdbVersion);
        this.setCollectNodeStatistics(collectNodeStatistics);
    }

    public CommandContext(Object processorID, String connectionID, String userName, String vdbName, int vdbVersion) {
        this(processorID, connectionID, userName, null, vdbName, vdbVersion, false);
    }

    public CommandContext() {
    }

    private CommandContext(GlobalState state) {
        this.globalState = state;
        this.dataObjects = this.globalState.dataObjects;
    }

    public FunctionMethod.Determinism getDeterminismLevel() {
        return this.globalState.determinismLevel;
    }

    public FunctionMethod.Determinism resetDeterminismLevel() {
        FunctionMethod.Determinism result = this.globalState.determinismLevel;
        this.globalState.determinismLevel = FunctionMethod.Determinism.DETERMINISTIC;
        return result;
    }

    public void setDeterminismLevel(FunctionMethod.Determinism level) {
        if (this.globalState.determinismLevel == null || level.compareTo((Enum)this.globalState.determinismLevel) < 0) {
            this.globalState.determinismLevel = level;
        }
    }

    public Object getProcessorID() {
        return this.globalState.processorID;
    }

    public void setProcessorID(Object object) {
        ArgCheck.isNotNull((Object)object);
        this.globalState.processorID = object;
    }

    public CommandContext clone() {
        CommandContext clone = new CommandContext(this.globalState);
        clone.variableContext = this.variableContext;
        clone.tempTableStore = this.tempTableStore;
        if (this.recursionStack != null) {
            clone.recursionStack = new LinkedList<String>(this.recursionStack);
        }
        clone.setNonBlocking(this.nonBlocking);
        return clone;
    }

    public String toString() {
        return "CommandContext: " + this.globalState.processorID;
    }

    public String getConnectionId() {
        return this.globalState.connectionID;
    }

    public String getConnectionID() {
        return this.globalState.connectionID;
    }

    public String getUserName() {
        return this.globalState.userName;
    }

    public String getVdbName() {
        return this.globalState.vdbName;
    }

    public int getVdbVersion() {
        return this.globalState.vdbVersion;
    }

    public void setConnectionID(String connectionID) {
        this.globalState.connectionID = connectionID;
    }

    public void setUserName(String userName) {
        this.globalState.userName = userName;
    }

    public void setVdbName(String vdbName) {
        this.globalState.vdbName = vdbName;
    }

    public void setVdbVersion(int vdbVersion) {
        this.globalState.vdbVersion = vdbVersion;
    }

    public Serializable getCommandPayload() {
        return this.globalState.commandPayload;
    }

    public void setCommandPayload(Serializable commandPayload) {
        this.globalState.commandPayload = commandPayload;
    }

    public void setCollectNodeStatistics(boolean collectNodeStatistics) {
        this.globalState.collectNodeStatistics = collectNodeStatistics;
    }

    public boolean getCollectNodeStatistics() {
        return this.globalState.collectNodeStatistics;
    }

    public int getProcessorBatchSize() {
        return this.globalState.processorBatchSize;
    }

    public int getProcessorBatchSize(List<Expression> schema) {
        return this.globalState.bufferManager.getProcessorBatchSize(schema);
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.globalState.processorBatchSize = processorBatchSize;
    }

    public double getNextRand() {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        return this.globalState.random.nextDouble();
    }

    public double getNextRand(long seed) {
        if (this.globalState.random == null) {
            this.globalState.random = new Random();
        }
        this.globalState.random.setSeed(seed);
        return this.globalState.random.nextDouble();
    }

    void setRandom(Random random) {
        this.globalState.random = random;
    }

    public void pushCall(String value) throws QueryProcessingException {
        if (this.recursionStack == null) {
            this.recursionStack = new LinkedList();
        } else if (this.recursionStack.contains(value)) {
            throw new QueryProcessingException((BundleUtil.Event)QueryPlugin.Event.TEIID30347, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30347, new Object[]{value}));
        }
        this.recursionStack.push(value);
    }

    public int getCallStackDepth() {
        if (this.recursionStack == null) {
            return 0;
        }
        return this.recursionStack.size();
    }

    public void popCall() {
        if (this.recursionStack != null) {
            this.recursionStack.pop();
        }
    }

    public SecurityFunctionEvaluator getSecurityFunctionEvaluator() {
        return this.globalState.securityFunctionEvaluator;
    }

    public void setSecurityFunctionEvaluator(SecurityFunctionEvaluator securityFunctionEvaluator) {
        this.globalState.securityFunctionEvaluator = securityFunctionEvaluator;
    }

    public TempTableStore getTempTableStore() {
        return this.tempTableStore;
    }

    public void setTempTableStore(TempTableStore tempTableStore) {
        this.tempTableStore = tempTableStore;
    }

    public TimeZone getServerTimeZone() {
        return this.globalState.timezone;
    }

    public void setPlanToProcessConverter(PlanToProcessConverter planToProcessConverter) {
        this.globalState.planToProcessConverter = planToProcessConverter;
    }

    public PlanToProcessConverter getPlanToProcessConverter() {
        return this.globalState.planToProcessConverter;
    }

    public QueryProcessor.ProcessorFactory getQueryProcessorFactory() {
        return this.globalState.queryProcessorFactory;
    }

    public void setQueryProcessorFactory(QueryProcessor.ProcessorFactory queryProcessorFactory) {
        this.globalState.queryProcessorFactory = queryProcessorFactory;
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    public void setVariableContext(VariableContext variableContext) {
        this.variableContext = variableContext;
    }

    public void pushVariableContext(VariableContext toPush) {
        toPush.setParentContext(this.variableContext);
        this.variableContext = toPush;
    }

    public Object getFromContext(Expression expression) throws TeiidComponentException {
        if (this.variableContext == null || !(expression instanceof ElementSymbol)) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30348, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30348, new Object[]{expression, "No value was available"}));
        }
        Object value = this.variableContext.getValue((ElementSymbol)expression);
        if (value == null && !this.variableContext.containsVariable((ElementSymbol)expression)) {
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30349, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30349, new Object[]{expression, "No value was available"}));
        }
        return value;
    }

    public Set<String> getGroups() {
        if (this.globalState.groups == null) {
            this.globalState.groups = new HashSet();
        }
        return this.globalState.groups;
    }

    public long getTimeSliceEnd() {
        return this.globalState.timeSliceEnd;
    }

    public long getTimeoutEnd() {
        return this.globalState.timeoutEnd;
    }

    public void setTimeSliceEnd(long timeSliceEnd) {
        this.globalState.timeSliceEnd = timeSliceEnd;
    }

    public void setTimeoutEnd(long timeoutEnd) {
        this.globalState.timeoutEnd = timeoutEnd;
    }

    public void setMetadata(QueryMetadataInterface metadata) {
        this.globalState.metadata = metadata;
    }

    public QueryMetadataInterface getMetadata() {
        return this.globalState.metadata;
    }

    public void setValidateXML(boolean validateXML) {
        this.globalState.validateXML = validateXML;
    }

    public boolean validateXML() {
        return this.globalState.validateXML;
    }

    public BufferManager getBufferManager() {
        return this.globalState.bufferManager;
    }

    public void setBufferManager(BufferManager bm) {
        this.globalState.bufferManager = bm;
    }

    public GlobalTableStore getGlobalTableStore() {
        return this.globalState.globalTables;
    }

    public void setGlobalTableStore(GlobalTableStore tempTableStore) {
        this.globalState.globalTables = tempTableStore;
    }

    public boolean isNonBlocking() {
        return this.nonBlocking;
    }

    public void setNonBlocking(boolean nonBlocking) {
        this.nonBlocking = nonBlocking;
    }

    public void setPreparedPlanCache(SessionAwareCache<PreparedPlan> cache) {
        this.globalState.planCache = cache;
    }

    public PreparedPlan getPlan(String key) {
        if (this.globalState.planCache == null) {
            return null;
        }
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(new ParseInfo(), key, this.getVdbName(), this.getVdbVersion(), this.getConnectionId(), this.getUserName());
        PreparedPlan pp = (PreparedPlan)this.globalState.planCache.get(id);
        if (pp != null) {
            if (id.getSessionId() != null) {
                this.setDeterminismLevel(FunctionMethod.Determinism.USER_DETERMINISTIC);
            } else if (id.getUserName() != null) {
                this.setDeterminismLevel(FunctionMethod.Determinism.SESSION_DETERMINISTIC);
            }
            return pp;
        }
        return null;
    }

    public void putPlan(String key, PreparedPlan plan, FunctionMethod.Determinism determinismLevel) {
        if (this.globalState.planCache == null) {
            return;
        }
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(new ParseInfo(), key, this.getVdbName(), this.getVdbVersion(), this.getConnectionId(), this.getUserName());
        this.globalState.planCache.put(id, determinismLevel, plan, null);
    }

    public boolean isResultSetCacheEnabled() {
        return this.globalState.resultSetCacheEnabled;
    }

    public void setResultSetCacheEnabled(boolean resultSetCacheEnabled) {
        this.globalState.resultSetCacheEnabled = resultSetCacheEnabled;
    }

    public int getUserRequestSourceConcurrency() {
        return this.globalState.userRequestSourceConcurrency;
    }

    public void setUserRequestSourceConcurrency(int userRequestSourceConcurrency) {
        this.globalState.userRequestSourceConcurrency = userRequestSourceConcurrency;
    }

    public Subject getSubject() {
        return this.globalState.subject;
    }

    public void setSubject(Subject subject) {
        this.globalState.subject = subject;
    }

    public void accessedPlanningObject(Object id) {
        if (this.planningObjects == null) {
            this.planningObjects = new HashSet();
        }
        this.planningObjects.add(id);
    }

    public Set<Object> getPlanningObjects() {
        if (this.planningObjects == null) {
            return Collections.emptySet();
        }
        return this.planningObjects;
    }

    public void accessedDataObject(Object id) {
        if (this.dataObjects != null) {
            this.dataObjects.add(id);
        }
    }

    public Set<Object> getDataObjects() {
        return this.dataObjects;
    }

    public void setDataObjects(HashSet<Object> dataObjectsAccessed) {
        this.dataObjects = dataObjectsAccessed;
    }

    public Session getSession() {
        return this.globalState.session;
    }

    public void setSession(Session session) {
        this.globalState.session = session;
    }

    public String getRequestId() {
        return this.globalState.requestId != null ? this.globalState.requestId.toString() : null;
    }

    public void setRequestId(RequestID requestId) {
        this.globalState.requestId = requestId;
    }

    public void setDQPWorkContext(DQPWorkContext workContext) {
        this.globalState.dqpWorkContext = workContext;
    }

    public Map<String, DataPolicy> getAllowedDataPolicies() {
        return this.globalState.dqpWorkContext.getAllowedDataPolicies();
    }

    public VDB getVdb() {
        return this.globalState.dqpWorkContext.getVDB();
    }

    public DQPWorkContext getDQPWorkContext() {
        return this.globalState.dqpWorkContext;
    }

    public TransactionContext getTransactionContext() {
        return this.globalState.transactionContext;
    }

    public void setTransactionContext(TransactionContext transactionContext) {
        this.globalState.transactionContext = transactionContext;
    }

    public TransactionService getTransactionServer() {
        return this.globalState.transactionService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.globalState.transactionService = transactionService;
    }

    public SourceHint getSourceHint() {
        return this.globalState.sourceHint;
    }

    public void setSourceHint(SourceHint hint) {
        this.globalState.sourceHint = hint;
    }

    public Executor getExecutor() {
        return this.globalState.executor;
    }

    public void setExecutor(Executor e) {
        this.globalState.executor = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReusableExecution<?> getReusableExecution(String nodeId) {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            if (this.globalState.reusableExecutions == null) {
                return null;
            }
            return this.globalState.reusableExecutions.get(nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putReusableExecution(String nodeId, ReusableExecution<?> execution) {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            if (this.globalState.reusableExecutions == null) {
                this.globalState.reusableExecutions = new ConcurrentHashMap();
            }
            this.globalState.reusableExecutions.put(nodeId, execution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        GlobalState globalState = this.globalState;
        synchronized (globalState) {
            if (this.globalState.reusableExecutions != null) {
                for (ReusableExecution<?> reusableExecution : this.globalState.reusableExecutions.values()) {
                    try {
                        reusableExecution.dispose();
                    }
                    catch (Exception e) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30030, new Object[0]));
                    }
                }
                this.globalState.reusableExecutions.clear();
            }
            if (this.globalState.commandListeners != null) {
                for (CommandListener listener : this.globalState.commandListeners) {
                    try {
                        listener.commandClosed((org.teiid.CommandContext)this);
                    }
                    catch (Exception e) {
                        LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30031, new Object[0]));
                    }
                }
                this.globalState.commandListeners.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(CommandListener listener) {
        if (listener != null) {
            GlobalState globalState = this.globalState;
            synchronized (globalState) {
                if (this.globalState.commandListeners == null) {
                    this.globalState.commandListeners = Collections.newSetFromMap(new IdentityHashMap());
                }
                this.globalState.commandListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(CommandListener listener) {
        if (listener != null) {
            GlobalState globalState = this.globalState;
            synchronized (globalState) {
                if (this.globalState.commandListeners != null) {
                    this.globalState.commandListeners.remove(listener);
                }
            }
        }
    }

    public static DecimalFormat getDecimalFormat(CommandContext context, String format) {
        DecimalFormat result = null;
        if (context != null) {
            if (context.globalState.decimalFormatCache == null) {
                context.globalState.decimalFormatCache = new LRUCache(32);
            } else {
                result = (DecimalFormat)context.globalState.decimalFormatCache.get((Object)format);
            }
        }
        if (result == null) {
            result = new DecimalFormat(format);
            result.setParseBigDecimal(true);
            if (context != null) {
                context.globalState.decimalFormatCache.put((Object)format, (Object)result);
            }
        }
        return result;
    }

    public static SimpleDateFormat getDateFormat(CommandContext context, String format) {
        SimpleDateFormat result = null;
        if (context != null) {
            if (context.globalState.dateFormatCache == null) {
                context.globalState.dateFormatCache = new LRUCache(32);
            } else {
                result = (SimpleDateFormat)context.globalState.dateFormatCache.get((Object)format);
            }
        }
        if (result == null) {
            result = new SimpleDateFormat(format);
            if (context != null) {
                context.globalState.dateFormatCache.put((Object)format, (Object)result);
            }
        }
        return result;
    }

    private static class GlobalState {
        private Object processorID;
        private String connectionID;
        private int processorBatchSize = 256;
        private String userName;
        private Serializable commandPayload;
        private String vdbName = "";
        private int vdbVersion;
        private boolean collectNodeStatistics;
        private Random random = null;
        private SecurityFunctionEvaluator securityFunctionEvaluator;
        private TimeZone timezone = TimeZone.getDefault();
        private PlanToProcessConverter planToProcessConverter;
        private QueryProcessor.ProcessorFactory queryProcessorFactory;
        private FunctionMethod.Determinism determinismLevel = FunctionMethod.Determinism.DETERMINISTIC;
        private Set<String> groups;
        private long timeSliceEnd = Long.MAX_VALUE;
        private long timeoutEnd = Long.MAX_VALUE;
        private QueryMetadataInterface metadata;
        private boolean validateXML;
        private BufferManager bufferManager;
        private GlobalTableStore globalTables;
        private SessionAwareCache<PreparedPlan> planCache;
        private boolean resultSetCacheEnabled = true;
        private int userRequestSourceConcurrency;
        private Subject subject;
        private HashSet<Object> dataObjects;
        private Session session;
        private RequestID requestId;
        private DQPWorkContext dqpWorkContext;
        private TransactionContext transactionContext;
        private TransactionService transactionService;
        private SourceHint sourceHint;
        private Executor executor = ExecutorUtils.getDirectExecutor();
        Map<String, ReusableExecution<?>> reusableExecutions;
        Set<CommandListener> commandListeners = null;
        private LRUCache<String, DecimalFormat> decimalFormatCache;
        private LRUCache<String, SimpleDateFormat> dateFormatCache;

        private GlobalState() {
        }
    }
}

