/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.vdb.runtime;

import java.io.Serializable;
import org.teiid.core.util.HashCodeUtil;

public class VDBKey
implements Serializable,
Comparable<VDBKey> {
    private static final long serialVersionUID = -7249750823144856081L;
    private String name;
    private int version;

    public VDBKey(String name, String version) {
        this.name = name.toUpperCase();
        if (version != null) {
            this.version = Integer.parseInt(version);
        }
    }

    public VDBKey(String name, int version) {
        this.name = name.toUpperCase();
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.name.hashCode(), (int)this.version);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VDBKey)) {
            return false;
        }
        VDBKey other = (VDBKey)obj;
        return other.name.equals(this.name) && this.version == other.version;
    }

    public String toString() {
        return this.name + " " + this.version;
    }

    @Override
    public int compareTo(VDBKey o) {
        int compare = this.name.compareTo(o.name);
        if (compare == 0) {
            return this.version - o.version;
        }
        return compare;
    }
}

