/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.Arrays;
import java.util.List;
import javax.transaction.xa.Xid;
import junit.framework.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.client.RequestMessage;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.internal.datamgr.FakeConnector;
import org.teiid.dqp.internal.datamgr.FakeProcedureExecution;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.ProcedureBatchHandler;
import org.teiid.dqp.internal.datamgr.TestConnectorManager;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.language.Call;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;

public class TestConnectorWorkItem {
    private static final QueryMetadataInterface EXAMPLE_BQT = RealMetadataFactory.exampleBQTCached();

    private static Command helpGetCommand(String sql, QueryMetadataInterface metadata) throws Exception {
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        return command;
    }

    static AtomicRequestMessage createNewAtomicRequestMessage(int requestid, int nodeid) throws Exception {
        RequestMessage rm = new RequestMessage();
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext(EXAMPLE_BQT, RealMetadataFactory.exampleBQTVDB());
        workContext.getSession().setSessionId(String.valueOf(1));
        workContext.getSession().setUserName("foo");
        AtomicRequestMessage request = new AtomicRequestMessage(rm, workContext, nodeid);
        request.setCommand(TestConnectorWorkItem.helpGetCommand("SELECT BQT1.SmallA.INTKEY FROM BQT1.SmallA", EXAMPLE_BQT));
        request.setRequestID(new RequestID((long)requestid));
        request.setConnectorName("testing");
        request.setFetchSize(5);
        request.setCommandContext(new CommandContext());
        return request;
    }

    @Test
    public void testProcedureBatching() throws Exception {
        FakeProcedureExecution exec = new FakeProcedureExecution(2, 1);
        int total_columns = 3;
        StoredProcedure command = (StoredProcedure)TestConnectorWorkItem.helpGetCommand("{call pm2.spTest8(?)}", EXAMPLE_BQT);
        ((SPParameter)command.getInputParameters().get(0)).setExpression((Expression)new Constant((Object)1));
        Call proc = new LanguageBridgeFactory(EXAMPLE_BQT).translate(command);
        ProcedureBatchHandler pbh = new ProcedureBatchHandler(proc, (ProcedureExecution)exec);
        Assert.assertEquals((int)total_columns, (int)pbh.padRow(Arrays.asList(null, null)).size());
        List params = pbh.getParameterRow();
        Assert.assertEquals((int)total_columns, (int)params.size());
        Assert.assertEquals((Object)0, params.get(2));
        try {
            pbh.padRow(Arrays.asList(1));
            Assert.fail((String)"Expected exception from resultset mismatch");
        }
        catch (TranslatorException err) {
            Assert.assertEquals((String)"Error Code:TEIID30479 Message:TEIID30479 Could not process stored procedure results for EXEC spTest8(1).  Expected 2 result set columns, but was 1.  Please update your models to allow for stored procedure results batching.", (String)err.getMessage());
        }
    }

    @Test
    public void testUpdateExecution() throws Throwable {
        AtomicResultsMessage results = this.helpExecuteUpdate();
        Assert.assertEquals((Object)1, results.getResults()[0].get(0));
    }

    private AtomicResultsMessage helpExecuteUpdate() throws Exception, Throwable {
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        AtomicRequestMessage arm = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        arm.setCommand(command);
        ConnectorWorkItem synchConnectorWorkItem = new ConnectorWorkItem(arm, TestConnectorManager.getConnectorManager());
        return synchConnectorWorkItem.execute();
    }

    @Test
    public void testExecutionWarning() throws Throwable {
        AtomicResultsMessage results = this.helpExecuteUpdate();
        Assert.assertEquals((int)1, (int)results.getWarnings().size());
    }

    @Ignore
    @Test
    public void testIsImmutablePropertySucceeds() throws Exception {
        ConnectorManager cm = TestConnectorManager.getConnectorManager();
        ((FakeConnector)cm.getExecutionFactory()).setImmutable(true);
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        AtomicRequestMessage requestMsg = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        requestMsg.setCommand(command);
        requestMsg.setTransactionContext(new TransactionContext(){

            public Xid getXid() {
                return (Xid)Mockito.mock(Xid.class);
            }
        });
        new ConnectorWorkItem(requestMsg, cm);
    }

    @Ignore
    @Test(expected=TranslatorException.class)
    public void testIsImmutablePropertyFails() throws Exception {
        ConnectorManager cm = TestConnectorManager.getConnectorManager();
        ((FakeConnector)cm.getExecutionFactory()).setImmutable(false);
        Command command = TestConnectorWorkItem.helpGetCommand("update bqt1.smalla set stringkey = 1 where stringkey = 2", EXAMPLE_BQT);
        AtomicRequestMessage requestMsg = TestConnectorWorkItem.createNewAtomicRequestMessage(1, 1);
        requestMsg.setCommand(command);
        requestMsg.setTransactionContext(new TransactionContext(){

            public Xid getXid() {
                return (Xid)Mockito.mock(Xid.class);
            }
        });
        new ConnectorWorkItem(requestMsg, cm);
    }
}

