/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.dqp.internal.process.TestPreparedStatement;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.processor.HardcodedDataManager;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestCallableStatement {
    @Test
    public void testMissingInput() throws Exception {
        String sql = "{? = call pm4.spTest9()}";
        try {
            TestPreparedStatement.helpTestProcessing(sql, Collections.EMPTY_LIST, null, new HardcodedDataManager(), (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
            Assert.fail();
        }
        catch (QueryResolverException e) {
            Assert.assertEquals((Object)"Error Code:TEIID30089 Message:TEIID30089 Required parameter 'pm4.spTest9.inkey' has no value was set or is an invalid parameter.", (Object)e.getMessage());
        }
    }

    @Test
    public void testReturnParameter() throws Exception {
        String sql = "{? = call pm4.spTest9(?)}";
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(1);
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("? = EXEC pm4.spTest9(1)", expected);
        TestPreparedStatement.helpTestProcessing(sql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
    }

    @Test
    public void testNoReturnParameter() throws Exception {
        String sql = "{call pm4.spTest9(?)}";
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(1);
        List[] expected = new List[]{Arrays.asList(1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm4.spTest9(1)", expected);
        TestPreparedStatement.helpTestProcessing(sql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
    }

    @Test
    public void testOutParameter() throws Exception {
        String sql = "{call pm2.spTest8(?, ?)}";
        ArrayList<Integer> values = new ArrayList<Integer>();
        values.add(2);
        List[] expected = new List[]{Arrays.asList(null, null, 1)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm2.spTest8(2)", expected);
        TestPreparedStatement.helpTestProcessing(sql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
    }

    @Test(expected=QueryResolverException.class)
    public void testInvalidReturn() throws Exception {
        String sql = "{? = call pm2.spTest8(?, ?)}";
        List<Integer> values = Arrays.asList(2);
        List[] expected = new List[]{};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        TestPreparedStatement.helpTestProcessing(sql, values, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
    }

    @Test
    public void testInputExpression() throws Exception {
        String sql = "{call pm2.spTest8(1, ?)}";
        List[] expected = new List[]{Arrays.asList(null, null, 0)};
        HardcodedDataManager dataManager = new HardcodedDataManager();
        dataManager.addData("EXEC pm2.spTest8(1)", expected);
        TestPreparedStatement.helpTestProcessing(sql, null, expected, dataManager, (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached(), true, RealMetadataFactory.exampleBQTVDB());
    }
}

