/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.service;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.datamgr.ConnectorWorkItem;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;

public class AutoGenDataService
extends ConnectorManager {
    private int rows = 10;
    private SourceCapabilities caps;
    public boolean throwExceptionOnExecute;
    public int dataNotAvailable = -2;
    public int sleep;
    private final AtomicInteger executeCount = new AtomicInteger();
    private final AtomicInteger closeCount = new AtomicInteger();
    private boolean useIntCounter;
    public boolean addWarning;
    public boolean copyLobs;
    private static final String STRING_VAL = "ABCDEFG";
    private static final Integer INTEGER_VAL = new Integer(0);
    private static final Long LONG_VAL = new Long(0L);
    private static final Float FLOAT_VAL = new Float(0.0);
    private static final Short SHORT_VAL = new Short(0);
    private static final Double DOUBLE_VAL = new Double(0.0);
    private static final Character CHAR_VAL = new Character('c');
    private static final Byte BYTE_VAL = new Byte(0);
    private static final Clob CLOB_VAL = new ClobImpl(new InputStreamFactory(){

        public InputStream getInputStream() throws IOException {
            return new ByteArrayInputStream("hello world".getBytes(Streamable.CHARSET));
        }
    }, -1L);
    private static final Boolean BOOLEAN_VAL = Boolean.FALSE;
    private static final BigInteger BIG_INTEGER_VAL = new BigInteger("0");
    private static final BigDecimal BIG_DECIMAL_VAL = new BigDecimal("0");
    private static final Date SQL_DATE_VAL = new Date(0L);
    private static final Time TIME_VAL = new Time(0L);
    private static final Timestamp TIMESTAMP_VAL = new Timestamp(0L);

    public AutoGenDataService() {
        super("FakeConnector", "FakeConnector");
        this.caps = TestOptimizer.getTypicalCapabilities();
    }

    public void setUseIntCounter(boolean useIntCounter) {
        this.useIntCounter = useIntCounter;
    }

    public void setSleep(int sleep) {
        this.sleep = sleep;
    }

    public void setCaps(SourceCapabilities caps) {
        this.caps = caps;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public int getRows() {
        return this.rows;
    }

    public ConnectorWork registerRequest(AtomicRequestMessage message) throws TeiidComponentException {
        List projectedSymbols = message.getCommand().getProjectedSymbols();
        List[] results = this.createResults(projectedSymbols);
        if (RelationalNodeUtil.isUpdate((Command)message.getCommand())) {
            results = new List[]{Arrays.asList(1)};
        }
        final AtomicResultsMessage msg = ConnectorWorkItem.createResultsMessage((List[])results);
        msg.setFinalRow(this.rows);
        return new ConnectorWork(){
            RequestWorkItem item;
            boolean returnedInitial;

            public boolean isDataAvailable() {
                return true;
            }

            public void setRequestWorkItem(RequestWorkItem item) {
                this.item = item;
            }

            public AtomicResultsMessage more() throws TranslatorException {
                if (AutoGenDataService.this.dataNotAvailable == -1) {
                    AutoGenDataService.this.dataNotAvailable = -2;
                    this.item.moreWork();
                    throw DataNotAvailableException.NO_POLLING;
                }
                if (this.returnedInitial) {
                    return msg;
                }
                throw new RuntimeException("Should not be called");
            }

            public AtomicResultsMessage execute() throws TranslatorException {
                AutoGenDataService.this.executeCount.incrementAndGet();
                if (AutoGenDataService.this.sleep > 0) {
                    try {
                        Thread.sleep(AutoGenDataService.this.sleep);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (AutoGenDataService.this.throwExceptionOnExecute) {
                    throw new TranslatorException("Connector Exception");
                }
                if (AutoGenDataService.this.dataNotAvailable > -2) {
                    int delay = AutoGenDataService.this.dataNotAvailable;
                    if (delay == -1 && !this.returnedInitial) {
                        this.returnedInitial = true;
                        return ConnectorWorkItem.createResultsMessage((List[])new List[0]);
                    }
                    AutoGenDataService.this.dataNotAvailable = -2;
                    throw new DataNotAvailableException((long)delay);
                }
                if (AutoGenDataService.this.addWarning) {
                    msg.setWarnings(Arrays.asList(new Exception()));
                }
                return msg;
            }

            public void close() {
                AutoGenDataService.this.closeCount.incrementAndGet();
            }

            public void cancel() {
            }

            public boolean copyLobs() {
                return AutoGenDataService.this.copyLobs;
            }
        };
    }

    public AtomicInteger getExecuteCount() {
        return this.executeCount;
    }

    public AtomicInteger getCloseCount() {
        return this.closeCount;
    }

    private List[] createResults(List symbols) {
        List[] rows = new List[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (Expression symbol : symbols) {
                Class type = symbol.getType();
                row.add(this.getValue(type, i));
            }
            rows[i] = row;
        }
        return rows;
    }

    private Object getValue(Class<?> type, int row) {
        if (type.equals(DataTypeManager.DefaultDataClasses.STRING)) {
            return STRING_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.INTEGER)) {
            return this.useIntCounter ? row : INTEGER_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.SHORT)) {
            return SHORT_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.LONG)) {
            return LONG_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.FLOAT)) {
            return FLOAT_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DOUBLE)) {
            return DOUBLE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.CHAR)) {
            return CHAR_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BYTE)) {
            return BYTE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            return BOOLEAN_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_INTEGER)) {
            return BIG_INTEGER_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.BIG_DECIMAL)) {
            return BIG_DECIMAL_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            return SQL_DATE_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            return TIME_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            return TIMESTAMP_VAL;
        }
        if (type.equals(DataTypeManager.DefaultDataClasses.CLOB)) {
            return CLOB_VAL;
        }
        return null;
    }

    public SourceCapabilities getCapabilities() {
        return this.caps;
    }
}

