/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer;

import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.TestOptimizer;
import org.teiid.query.optimizer.capabilities.BasicSourceCapabilities;
import org.teiid.query.optimizer.capabilities.FakeCapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.validator.TestValidator;

public class TestComparableMetadataPushdown {
    @Test
    public void testCantPushSort() throws Exception {
        String sql = "select e3, e2 from test.group order by e3, e2";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("test", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata(), new String[]{"SELECT g_0.e3, g_0.e2 FROM test.\"group\" AS g_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCantPushGroupBy() throws Exception {
        String sql = "select e3, e2 from test.group group by e3, e2";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = TestOptimizer.getTypicalCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_GROUP_BY, true);
        capFinder.addCapabilities("test", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata(), new String[]{"SELECT g_0.e3, g_0.e2 FROM test.\"group\" AS g_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCantPushDup() throws Exception {
        String sql = "select distinct e3, e2 from test.group";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        capFinder.addCapabilities("test", (SourceCapabilities)TestOptimizer.getTypicalCapabilities());
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata(), new String[]{"SELECT g_0.e3, g_0.e2 FROM test.\"group\" AS g_0"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }

    @Test
    public void testCantPushSetOp() throws Exception {
        String sql = "select e3, e2 from test.group union select e0, e1 from test.group2";
        FakeCapabilitiesFinder capFinder = new FakeCapabilitiesFinder();
        BasicSourceCapabilities caps = new BasicSourceCapabilities();
        caps.setCapabilitySupport(SourceCapabilities.Capability.QUERY_UNION, true);
        capFinder.addCapabilities("test", (SourceCapabilities)caps);
        TestOptimizer.helpPlan(sql, (QueryMetadataInterface)TestValidator.exampleMetadata(), new String[]{"SELECT test.\"group\".e3, test.\"group\".e2 FROM test.\"group\"", "SELECT test.group2.e0, test.group2.e1 FROM test.group2"}, capFinder, TestOptimizer.ComparisonMode.EXACT_COMMAND_STRING);
    }
}

