/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.processor.FakeTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.BatchedUpdateCommand;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.TranslatableProcedureContainer;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ReferenceCollectorVisitor;
import org.teiid.query.util.CommandContext;

public class FakeDataManager
implements ProcessorDataManager {
    private Map<String, TupleInfo> tuples = new HashMap<String, TupleInfo>();
    private Map<String, List<List<?>>[]> procTuples = new HashMap<String, List<List<?>>[]>();
    private static final String LOG_CONTEXT = "FAKE_DATA_MANAGER";
    private boolean blockOnce;
    private Map<String, Map> codeTableValues = new HashMap<String, Map>();
    private boolean throwBlocked = false;
    private Map<String, Boolean> blockedState = new HashMap<String, Boolean>();
    private List<String> queries = new ArrayList<String>();
    private boolean recordingCommands = true;

    public List<String> getQueries() {
        return this.queries;
    }

    public List<String> clearQueries() {
        ArrayList<String> rc = new ArrayList<String>(this.getQueries());
        this.queries.clear();
        return rc;
    }

    public void registerProcTuples(String proc, List[] data) {
        this.procTuples.put(proc, data);
    }

    public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID, int limit) throws TeiidComponentException {
        LogManager.logTrace((String)LOG_CONTEXT, (Object[])new Object[]{"Register Request:", command, ",processorID:", context.getProcessorID(), ",model name:", modelName, ",TupleSourceID nodeID:", new Integer(nodeID)});
        if (this.recordingCommands && !(command instanceof BatchedUpdateCommand)) {
            this.queries.add(command.toString());
        }
        if (ReferenceCollectorVisitor.getReferences((LanguageObject)command).size() > 0) {
            throw new IllegalArgumentException("Found references in the command registered with the DataManager.");
        }
        GroupSymbol group = null;
        if (command instanceof Query) {
            group = this.getQueryGroup((Query)command);
        } else if (command instanceof SetQuery) {
            SetQuery union = (SetQuery)command;
            group = this.getQueryGroup(union.getProjectedQuery());
        } else {
            if (command instanceof StoredProcedure) {
                Object id = ((StoredProcedure)command).getProcedureID();
                List[] data = this.procTuples.get(id);
                if (data == null) {
                    throw new AssertionError((Object)("Undefined results for " + command));
                }
                FakeTupleSource ts = new FakeTupleSource(command.getProjectedSymbols(), data);
                if (this.blockOnce) {
                    ts.setBlockOnce();
                }
                return ts;
            }
            if (command instanceof ProcedureContainer) {
                group = ((ProcedureContainer)command).getGroup();
            } else if (command instanceof BatchedUpdateCommand) {
                BatchedUpdateCommand buc = (BatchedUpdateCommand)command;
                if (buc.getUpdateCommands().get(0) instanceof Update) {
                    group = ((Update)buc.getUpdateCommands().get(0)).getGroup();
                }
                if (this.recordingCommands) {
                    Iterator it = ((BatchedUpdateCommand)command).getUpdateCommands().iterator();
                    while (it.hasNext()) {
                        this.queries.add(((Command)it.next()).toString());
                    }
                }
            }
        }
        TupleInfo tupleInfo = this.tuples.get(group.getNonCorrelationName().toUpperCase());
        List elements = tupleInfo.elements;
        List[] data = tupleInfo.data;
        List projectedSymbols = command.getProjectedSymbols();
        int[] columnMap = this.getColumnMap(tupleInfo.elements, projectedSymbols);
        ArrayList<Command> updateCommands = new ArrayList<Command>();
        if (command instanceof Query) {
            Query query = (Query)command;
            if (query.getCriteria() != null) {
                Expression element;
                int i;
                HashMap lookupMap = new HashMap();
                for (i = 0; i < elements.size(); ++i) {
                    element = (Expression)elements.get(i);
                    this.mapElementToIndex(lookupMap, element, i, group);
                }
                for (i = 0; i < projectedSymbols.size(); ++i) {
                    element = (Expression)projectedSymbols.get(i);
                    this.mapElementToIndex(lookupMap, element, columnMap[i], group);
                }
                ArrayList<List> filteredTuples = new ArrayList<List>();
                for (int i2 = 0; i2 < data.length; ++i2) {
                    try {
                        if (!new Evaluator(lookupMap, null, null).evaluate(query.getCriteria(), data[i2])) continue;
                        filteredTuples.add(data[i2]);
                        continue;
                    }
                    catch (ExpressionEvaluationException e) {
                        throw new TeiidComponentException((Throwable)e, e.getMessage());
                    }
                }
                data = new List[filteredTuples.size()];
                filteredTuples.toArray(data);
            }
        } else if (command instanceof Insert || command instanceof Update || command instanceof Delete) {
            updateCommands.add(command);
        } else if (command instanceof BatchedUpdateCommand) {
            updateCommands.addAll(((BatchedUpdateCommand)command).getUpdateCommands());
        }
        if (updateCommands.size() > 0) {
            ArrayList<List<Object>> filteredTuples = new ArrayList<List<Object>>();
            for (int c = 0; c < updateCommands.size(); ++c) {
                Command cmd = (Command)updateCommands.get(c);
                if (cmd instanceof TranslatableProcedureContainer) {
                    Expression element;
                    int i;
                    TranslatableProcedureContainer update = (TranslatableProcedureContainer)cmd;
                    if (update.getCriteria() == null) continue;
                    HashMap lookupMap = new HashMap();
                    for (i = 0; i < elements.size(); ++i) {
                        element = (Expression)elements.get(i);
                        this.mapElementToIndex(lookupMap, element, new Integer(i), group);
                    }
                    for (i = 0; i < projectedSymbols.size(); ++i) {
                        element = (Expression)projectedSymbols.get(i);
                        this.mapElementToIndex(lookupMap, element, new Integer(columnMap[i]), group);
                    }
                    int updated = 0;
                    for (int i3 = 0; i3 < data.length; ++i3) {
                        try {
                            if (!new Evaluator(lookupMap, null, null).evaluate(update.getCriteria(), data[i3])) continue;
                            ++updated;
                            continue;
                        }
                        catch (ExpressionEvaluationException e) {
                            throw new TeiidComponentException((Throwable)e, e.getMessage());
                        }
                    }
                    ArrayList<Integer> updateTuple = new ArrayList<Integer>(1);
                    updateTuple.add(new Integer(updated));
                    filteredTuples.add(updateTuple);
                    continue;
                }
                filteredTuples.add(Arrays.asList(1));
            }
            data = new List[filteredTuples.size()];
            filteredTuples.toArray(data);
            elements = Command.getUpdateCommandSymbol();
            columnMap[0] = 0;
        }
        FakeTupleSource ts = new FakeTupleSource(elements, data, projectedSymbols, columnMap);
        if (this.blockOnce) {
            ts.setBlockOnce();
        }
        return ts;
    }

    private GroupSymbol getQueryGroup(Query query) throws TeiidComponentException {
        From from = query.getFrom();
        List groups = from.getGroups();
        if (groups.size() != 1) {
            throw new TeiidComponentException("Cannot build fake tuple source for command: " + query);
        }
        GroupSymbol group = (GroupSymbol)groups.get(0);
        for (Object symbol : query.getSelect().getProjectedSymbols()) {
            if (!(symbol instanceof ElementSymbol)) continue;
            ElementSymbol elementSymbol = (ElementSymbol)symbol;
            GroupSymbol g = elementSymbol.getGroupSymbol();
            if (!g.equals((Object)group)) {
                throw new TeiidComponentException("Illegal symbol " + elementSymbol + " in SELECT of command: " + query);
            }
            if (elementSymbol.getMetadataID() == null) {
                throw new TeiidComponentException("Illegal null metadata ID in ElementSymbol " + elementSymbol + " in SELECT of command: " + query);
            }
            if (!(elementSymbol.getMetadataID() instanceof TempMetadataID)) continue;
            throw new TeiidComponentException("Illegal TempMetadataID in ElementSymbol " + elementSymbol + " in SELECT of command: " + query);
        }
        return group;
    }

    private void mapElementToIndex(Map lookupMap, Expression element, Integer index, GroupSymbol group) {
        ElementSymbol elementSymbol = (ElementSymbol)SymbolMap.getExpression((Expression)element);
        if (group.getDefinition() != null) {
            String groupAlias = group.getName();
            elementSymbol = elementSymbol.clone();
            elementSymbol.getGroupSymbol().setName(groupAlias);
        }
        lookupMap.put(elementSymbol, index);
    }

    private int[] getColumnMap(List<ElementSymbol> allElements, List<? extends Expression> expectedElements) {
        int[] map = new int[expectedElements.size()];
        for (int i = 0; i < expectedElements.size(); ++i) {
            Expression symbol = SymbolMap.getExpression((Expression)expectedElements.get(i));
            boolean foundMatch = false;
            if (symbol instanceof ElementSymbol) {
                for (int j = 0; j < allElements.size(); ++j) {
                    ElementSymbol es = allElements.get(j);
                    if (!es.getShortName().equalsIgnoreCase(((ElementSymbol)symbol).getShortName())) continue;
                    map[i] = j;
                    foundMatch = true;
                    break;
                }
            }
            if (foundMatch) continue;
            map[i] = -1;
        }
        return map;
    }

    public void setThrowBlocked(boolean throwBlocked) {
        this.throwBlocked = throwBlocked;
    }

    public void defineCodeTable(String tableName, String keyCol, String retCol, Map values) {
        String key = tableName.toUpperCase() + keyCol.toUpperCase() + retCol.toUpperCase();
        this.codeTableValues.put(key, values);
        this.blockedState.put(key, Boolean.FALSE);
    }

    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException {
        String tableKey = codeTableName.toUpperCase() + keyElementName.toUpperCase() + returnElementName.toUpperCase();
        if (!this.codeTableValues.containsKey(tableKey)) {
            throw new TeiidComponentException("Unknown code table: " + codeTableName);
        }
        if (this.throwBlocked && this.blockedState.get(tableKey).equals(Boolean.FALSE)) {
            this.blockedState.put(tableKey, Boolean.TRUE);
            throw BlockedException.INSTANCE;
        }
        Map values = this.codeTableValues.get(tableKey);
        return values.get(keyValue);
    }

    public void setBlockOnce() {
        this.blockOnce = true;
    }

    public boolean isRecordingCommands() {
        return this.recordingCommands;
    }

    public void setRecordingCommands(boolean shouldRecord) {
        this.recordingCommands = shouldRecord;
    }

    public void registerTuples(QueryMetadataInterface metadata, String groupName, List<?>[] data) throws QueryResolverException, TeiidComponentException {
        GroupSymbol group = new GroupSymbol(groupName);
        ResolverUtil.resolveGroup((GroupSymbol)group, (QueryMetadataInterface)metadata);
        List elementSymbols = ResolverUtil.resolveElementsInGroup((GroupSymbol)group, (QueryMetadataInterface)metadata);
        this.tuples.put(group.getName().toUpperCase(), new TupleInfo(elementSymbols, data));
    }

    public EventDistributor getEventDistributor() {
        return null;
    }

    static class TupleInfo {
        List<ElementSymbol> elements;
        List<?>[] data;

        public TupleInfo(List<ElementSymbol> elements, List<?>[] data) {
            this.elements = elements;
            this.data = data;
        }
    }
}

