/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.eval;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.function.FunctionDescriptor;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.resolver.TestFunctionResolving;
import org.teiid.query.sql.lang.CollectionValueIterator;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TestCaseExpression;
import org.teiid.query.sql.symbol.TestSearchedCaseExpression;
import org.teiid.query.sql.util.ValueIterator;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.util.CommandContext;

public class TestExpressionEvaluator {
    public void helpTestEval(Expression expr, Expression[] elementList, Object[] valueList, ProcessorDataManager dataMgr, CommandContext context, Object expectedValue) {
        try {
            Object actualValue = this.helpEval(expr, elementList, valueList, dataMgr, context);
            Assert.assertEquals((String)"Did not get expected result", (Object)expectedValue, (Object)actualValue);
        }
        catch (TeiidException e) {
            Assert.fail((String)("Received unexpected exception: " + e.getFullMessage()));
        }
    }

    public Object helpEval(Expression expr, Expression[] elementList, Object[] valueList, ProcessorDataManager dataMgr, CommandContext context) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        HashMap<Expression, Integer> elements = new HashMap<Expression, Integer>();
        if (elementList != null) {
            for (int i = 0; i < elementList.length; ++i) {
                elements.put(elementList[i], new Integer(i));
            }
        }
        ArrayList<Object> tuple = new ArrayList<Object>();
        if (valueList != null) {
            for (int i = 0; i < valueList.length; ++i) {
                tuple.add(valueList[i]);
            }
        }
        return new Evaluator(elements, dataMgr, context).evaluate(expr, tuple);
    }

    @Test
    public void testCaseExpression1() {
        CaseExpression expr = TestCaseExpression.example(3);
        expr.setExpression((Expression)new Constant((Object)"a"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(0));
        expr.setExpression((Expression)new Constant((Object)"b"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(1));
        expr.setExpression((Expression)new Constant((Object)"c"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(2));
        expr.setExpression((Expression)new Constant((Object)"d"));
        this.helpTestEval((Expression)expr, null, null, null, null, new Integer(9999));
    }

    @Test
    public void testSearchedCaseExpression1() {
        SearchedCaseExpression expr = TestSearchedCaseExpression.example(3);
        this.helpTestEval((Expression)expr, new Expression[]{new ElementSymbol("x")}, new Object[]{new Integer(0)}, null, null, new Integer(0));
        this.helpTestEval((Expression)expr, new Expression[]{new ElementSymbol("x")}, new Object[]{new Integer(1)}, null, null, new Integer(1));
        this.helpTestEval((Expression)expr, new Expression[]{new ElementSymbol("x")}, new Object[]{new Integer(2)}, null, null, new Integer(2));
        this.helpTestEval((Expression)expr, new Expression[]{new ElementSymbol("x")}, new Object[]{new Integer(3)}, null, null, new Integer(9999));
    }

    @Test
    public void testConstant() {
        this.helpTestEval((Expression)new Constant((Object)"xyz", String.class), new Expression[0], new Object[0], null, null, "xyz");
    }

    @Test
    public void testElement1() {
        ElementSymbol e1 = new ElementSymbol("e1");
        ElementSymbol e2 = new ElementSymbol("e2");
        Expression[] elements = new Expression[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)e1, elements, values, null, null, "xyz");
    }

    @Test
    public void testElement2() {
        ElementSymbol e1 = new ElementSymbol("e1");
        ElementSymbol e2 = new ElementSymbol("e2");
        Expression[] elements = new Expression[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)e2, elements, values, null, null, "abc");
    }

    @Test
    public void testElement3() throws Exception {
        ElementSymbol e2 = new ElementSymbol("e2");
        Expression[] elements = new Expression[]{};
        Object[] values = new Object[]{"xyz", "abc"};
        try {
            this.helpEval((Expression)e2, elements, values, null, null);
            Assert.fail((String)"Exception expected");
        }
        catch (TeiidComponentException e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)"Error Code:TEIID30346 Message:TEIID30346 Unable to evaluate e2: No value was available");
        }
    }

    @Test
    public void testFunction1() {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setType(String.class);
        ElementSymbol e2 = new ElementSymbol("e2");
        e2.setType(String.class);
        Function func = new Function("concat", new Expression[]{e1, e2});
        FunctionDescriptor desc = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("concat", new Class[]{String.class, String.class});
        func.setFunctionDescriptor(desc);
        Expression[] elements = new Expression[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)func, elements, values, null, null, "xyzabc");
    }

    @Test
    public void testFunction2() {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setType(String.class);
        ElementSymbol e2 = new ElementSymbol("e2");
        e2.setType(String.class);
        Function func = new Function("concat", new Expression[]{e2, e1});
        FunctionDescriptor desc = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("concat", new Class[]{String.class, String.class});
        func.setFunctionDescriptor(desc);
        Expression[] elements = new Expression[]{e1, e2};
        Object[] values = new Object[]{"xyz", "abc"};
        this.helpTestEval((Expression)func, elements, values, null, null, "abcxyz");
    }

    @Test
    public void testLookupFunction() {
        ElementSymbol e1 = new ElementSymbol("e1");
        e1.setType(String.class);
        ElementSymbol e2 = new ElementSymbol("e2");
        e1.setType(Integer.class);
        Function func = new Function("lookup", new Expression[]{new Constant((Object)"pm1.g1"), new Constant((Object)"e2"), new Constant((Object)"e1"), e1});
        FunctionDescriptor desc = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("lookup", new Class[]{String.class, String.class, String.class, String.class});
        func.setFunctionDescriptor(desc);
        Expression[] elements = new Expression[]{e1, e2};
        Object[] values = new Object[]{"xyz", new Integer(5)};
        FakeDataManager dataMgr = new FakeDataManager();
        HashMap<String, Integer> valueMap = new HashMap<String, Integer>();
        valueMap.put("xyz", new Integer(5));
        dataMgr.defineCodeTable("pm1.g1", "e1", "e2", valueMap);
        this.helpTestEval((Expression)func, elements, values, dataMgr, null, new Integer(5));
    }

    @Test
    public void testScalarSubquery() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((QueryCommand)new Query());
        ArrayList<String> values = new ArrayList<String>(1);
        values.add("a");
        String expected = "a";
        this.helpTestWithValueIterator(expr, values, expected);
    }

    private void helpTestWithValueIterator(ScalarSubquery expr, List<?> values, Object expected) throws BlockedException, TeiidComponentException, ExpressionEvaluationException {
        final CollectionValueIterator valueIter = new CollectionValueIterator(values);
        CommandContext cc = new CommandContext();
        Assert.assertEquals((Object)expected, (Object)new Evaluator(Collections.emptyMap(), null, cc){

            protected ValueIterator evaluateSubquery(SubqueryContainer container, List tuple) throws TeiidProcessingException, BlockedException, TeiidComponentException {
                return valueIter;
            }
        }.evaluate((Expression)expr, null));
    }

    @Test
    public void testScalarSubquery2() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((QueryCommand)new Query());
        ArrayList<Object> values = new ArrayList<Object>(1);
        values.add(null);
        this.helpTestWithValueIterator(expr, values, null);
    }

    @Test
    public void testScalarSubquery3() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((QueryCommand)new Query());
        this.helpTestWithValueIterator(expr, Collections.emptyList(), null);
    }

    @Test
    public void testScalarSubqueryFails() throws Exception {
        ScalarSubquery expr = new ScalarSubquery((QueryCommand)QueryParser.getQueryParser().parseCommand("select x from y"));
        ArrayList<String> values = new ArrayList<String>(2);
        values.add("a");
        values.add("b");
        try {
            this.helpTestWithValueIterator(expr, values, null);
            Assert.fail((String)"Expected ExpressionEvaluationException but got none");
        }
        catch (ExpressionEvaluationException e) {
            Assert.assertEquals((Object)"Error Code:TEIID30328 Message:TEIID30328 Unable to evaluate (SELECT x FROM y): Error Code:TEIID30345 Message:TEIID30345 The command of this scalar subquery returned more than one value: SELECT x FROM y", (Object)e.getMessage());
        }
    }

    @Test
    public void testUser() throws Exception {
        Function func = new Function("user", new Expression[0]);
        FunctionDescriptor desc = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("user", new Class[0]);
        func.setFunctionDescriptor(desc);
        FakeDataManager dataMgr = new FakeDataManager();
        CommandContext context = new CommandContext((Object)new Long(1L), null, null, null, 0);
        context.setUserName("logon");
        Assert.assertEquals((Object)context.getUserName(), (Object)new Evaluator(Collections.emptyMap(), (ProcessorDataManager)dataMgr, context).evaluate((Expression)func, Collections.emptyList()));
    }

    public void helpTestCommandPayload(Serializable payload, String property, String expectedValue) throws Exception {
        Function func = new Function("commandpayload", new Expression[0]);
        Class[] parameterSignature = null;
        parameterSignature = property == null ? new Class[]{} : new Class[]{String.class};
        FunctionDescriptor desc = RealMetadataFactory.SFM.getSystemFunctionLibrary().findFunction("commandpayload", parameterSignature);
        func.setFunctionDescriptor(desc);
        FakeDataManager dataMgr = new FakeDataManager();
        CommandContext context = new CommandContext((Object)new Long(-1L), null, "user", payload, "vdb", 1, false);
        if (property != null) {
            func.setArgs(new Expression[]{new Constant((Object)property)});
        }
        String actual = (String)new Evaluator(Collections.emptyMap(), (ProcessorDataManager)dataMgr, context).evaluate((Expression)func, Collections.emptyList());
        Assert.assertEquals((Object)expectedValue, (Object)actual);
    }

    @Test
    public void testCommandPayloadNoArgsWithPayload() throws Exception {
        this.helpTestCommandPayload((Serializable)((Object)"blah"), null, "blah");
    }

    @Test
    public void testCommandPayloadNoArgsWithoutPayload() throws Exception {
        this.helpTestCommandPayload(null, null, null);
    }

    @Test
    public void testCommandPayloadNoArgsWithNonStringPayload() throws Exception {
        this.helpTestCommandPayload(Boolean.TRUE, null, "true");
    }

    @Test
    public void testCommandPayloadArgWithPayload() throws Exception {
        Properties props = new Properties();
        props.setProperty("p1", "v1");
        props.setProperty("p2", "v2");
        this.helpTestCommandPayload(props, "p1", "v1");
    }

    @Test
    public void testCommandPayloadArgWithPayloadMissingProp() throws Exception {
        Properties props = new Properties();
        props.setProperty("p1", "v1");
        props.setProperty("p2", "v2");
        this.helpTestCommandPayload(props, "BOGUS", null);
    }

    @Test
    public void testCommandPayloadArgWithoutPayload() throws Exception {
        Properties props = new Properties();
        props.setProperty("p1", "v1");
        props.setProperty("p2", "v2");
        this.helpTestCommandPayload(null, "BOGUS", null);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testCommandPayloadArgWithBadPayload() throws Exception {
        this.helpTestCommandPayload(Boolean.TRUE, "BOGUS", null);
    }

    @Test
    public void testBigDecimalFromDoubleDivision() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("convert(1.0, bigdecimal)/3");
        Assert.assertEquals((Object)new BigDecimal("0.3333333333333333"), (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testBigDecimalDivision() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("1/convert('3.0', bigdecimal)");
        Assert.assertEquals((Object)new BigDecimal("0.3333333333333333"), (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testIsNull() throws Exception {
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Criteria)new IsNullCriteria((Expression)new Constant(null, DataTypeManager.DefaultDataClasses.BOOLEAN))));
    }

    @Test
    public void testIsNull1() throws Exception {
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Criteria)new IsNullCriteria((Expression)new Constant((Object)Boolean.TRUE, DataTypeManager.DefaultDataClasses.BOOLEAN))));
    }

    @Test
    public void testIsNull3() throws Exception {
        IsNullCriteria inc = new IsNullCriteria((Expression)new Constant(null, DataTypeManager.DefaultDataClasses.BOOLEAN));
        inc.setNegated(true);
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Criteria)inc));
    }

    @Test
    public void testIsNull4() throws Exception {
        IsNullCriteria inc = new IsNullCriteria((Expression)new Constant((Object)Boolean.TRUE, DataTypeManager.DefaultDataClasses.BOOLEAN));
        inc.setNegated(true);
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Criteria)inc));
    }

    @Test
    public void testSubstring() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("substring('abcd' from 2 for 2)");
        Assert.assertEquals((Object)"bc", (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testExtract() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("extract(year from cast('2011-01-01' as date))");
        Assert.assertEquals((Object)2011, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testExtract1() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("extract(day from cast('2011-01-01' as date))");
        Assert.assertEquals((Object)1, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testSimilarTo() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'aaaxy' similar to 'a+%'");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testSimilarTo1() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xaay' similar to 'xa{2,3}y'");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testSimilarTo2() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xay' similar to 'xa{2,3}y'");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testSimilarTo3() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xay' similar to '{'");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testSimilarTo4() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xay' similar to 'xa{2,}y'");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testSimilarTo5() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'x1y' similar to 'x([a-z]+|[0-9])_'");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testSimilarTo6() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xx' similar to 'x([a-z]+|[0-9])_'");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testLikeRegex() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'aaaxy' like_regex 'a+.*'");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testLikeRegex1() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xaay' similar to 'xa{2,3}y'");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testLikeRegex2() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xay' like_regex 'xa{2,3}y'");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testLikeRegex3() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xay' like_regex '{'");
        Assert.assertEquals((Object)Boolean.FALSE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testLikeRegex4() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'xay' like_regex 'a'");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Expression)ex));
    }

    @Test
    public void testLikePlus() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("'+' like '+'");
        Assert.assertEquals((Object)Boolean.TRUE, (Object)Evaluator.evaluate((Expression)ex));
    }
}

