/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.XMLSerialize;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestFunctionResolving {
    @Test
    public void testResolveBadConvert() throws Exception {
        Function function = new Function("convert", new Expression[]{new Constant((Object)new Character('a')), new Constant((Object)"date")});
        try {
            ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
            Assert.fail((String)"excpetion expected");
        }
        catch (QueryResolverException err) {
            Assert.assertEquals((Object)"Error Code:TEIID30071 Message:TEIID30071 The conversion from char to date is not allowed.", (Object)err.getMessage());
        }
    }

    @Test
    public void testResolvesClosestType() throws Exception {
        ElementSymbol e1 = new ElementSymbol("pm1.g1.e1");
        e1.setType(DataTypeManager.DefaultDataClasses.BYTE);
        e1.setMetadataID(new Object());
        Function function = new Function("abs", new Expression[]{e1});
        ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)function.getType());
    }

    @Test
    public void testResolveConvertReference() throws Exception {
        Function function = new Function("convert", new Expression[]{new Reference(0), new Constant((Object)"boolean")});
        ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.BOOLEAN, (Object)function.getType());
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.BOOLEAN, (Object)function.getArgs()[0].getType());
    }

    @Test
    public void testResolveAmbiguousFunction() throws Exception {
        Function function = new Function("LCASE", new Expression[]{new Reference(0)});
        try {
            ResolverVisitor.resolveLanguageObject((LanguageObject)function, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
            Assert.fail((String)"excpetion expected");
        }
        catch (QueryResolverException err) {
            Assert.assertEquals((Object)"Error Code:TEIID30069 Message:TEIID30069 The function 'LCASE(?)' has more than one possible signature.", (Object)err.getMessage());
        }
    }

    @Test
    public void testResolveCoalesce() throws Exception {
        String sql = "coalesce('', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce1() throws Exception {
        String sql = "coalesce('', '', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce1a() throws Exception {
        String sql = "coalesce('', '', '', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce2() throws Exception {
        String sql = "coalesce('', 1, '', '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce3() throws Exception {
        String sql = "coalesce('', 1, null, '')";
        this.helpResolveFunction(sql);
    }

    @Test
    public void testResolveCoalesce4() throws Exception {
        String sql = "coalesce({d'2009-03-11'}, 1)";
        this.helpResolveFunction(sql);
    }

    private Function helpResolveFunction(String sql) throws QueryParserException, QueryResolverException, TeiidComponentException {
        Function func = (Function)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)func.getType());
        return func;
    }

    public static Expression getExpression(String sql) throws QueryParserException, TeiidComponentException, QueryResolverException {
        Expression func = QueryParser.getQueryParser().parseExpression(sql);
        ResolverVisitor.resolveLanguageObject((LanguageObject)func, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        return func;
    }

    @Test
    public void testLookupTypeConversion() throws Exception {
        String sql = "lookup('pm1.g1', 'e2', 'e1', 1)";
        Function f = (Function)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.STRING, (Object)f.getArg(3).getType());
    }

    @Test
    public void testXMLSerialize() throws Exception {
        String sql = "xmlserialize(DOCUMENT '<a/>' as clob)";
        XMLSerialize xs = (XMLSerialize)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.CLOB, (Object)xs.getType());
    }

    @Test(expected=QueryResolverException.class)
    public void testXMLSerialize_1() throws Exception {
        String sql = "xmlserialize(DOCUMENT 1 as clob)";
        XMLSerialize xs = (XMLSerialize)TestFunctionResolving.getExpression(sql);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.CLOB, (Object)xs.getType());
    }
}

