/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestXMLResolver {
    public Command helpResolve(String sql) {
        Command cmd = TestResolver.helpResolve(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        ResolverUtil.fullyQualifyElements((Command)cmd);
        return cmd;
    }

    public void helpResolveException(String sql) {
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached());
    }

    public void helpResolveException(String sql, String expectedMessage) {
        TestResolver.helpResolveException(sql, (QueryMetadataInterface)RealMetadataFactory.example1Cached(), expectedMessage);
    }

    @Test
    public void testXMLCriteriaShortElement() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where node1 = 'yyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testXMLCriteriaLongElement1() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", gs);
        es.setGroupSymbol(gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where root.node1 = 'yyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testXMLCriteriaLongElement2() {
        CompareCriteria expected1 = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc4");
        ElementSymbol es1 = new ElementSymbol("root.node1", gs);
        expected1.setLeftExpression((Expression)es1);
        expected1.setOperator(1);
        expected1.setRightExpression((Expression)new Constant((Object)"xyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc4 where root.node1 = 'xyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected1, (Object)actual);
    }

    @Test
    public void testXMLCriteriaLongElement3() {
        GroupSymbol gs = new GroupSymbol("xmltest.doc4");
        CompareCriteria expected2 = new CompareCriteria();
        ElementSymbol es2 = new ElementSymbol("root.node1.@node2", gs);
        es2.setGroupSymbol(gs);
        expected2.setLeftExpression((Expression)es2);
        expected2.setOperator(1);
        expected2.setRightExpression((Expression)new Constant((Object)"xyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'xyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected2, (Object)actual);
    }

    @Test
    public void testXMLCriteriaLongElement4() {
        GroupSymbol gs = new GroupSymbol("xmltest.doc4");
        CompareCriteria expected3 = new CompareCriteria();
        ElementSymbol es3 = new ElementSymbol("root.node3", gs);
        expected3.setLeftExpression((Expression)es3);
        expected3.setOperator(1);
        expected3.setRightExpression((Expression)new Constant((Object)"xyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc4 where root.node3 = 'xyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected3, (Object)actual);
    }

    @Test
    public void testXMLCriteriaLongElement5() {
        this.helpResolve("select * from xmltest.doc4 where root.node1 = 'yyz'");
    }

    @Test
    public void testXMLCriteriaLongElement6() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'yyz'");
    }

    @Test
    public void testXMLCriteriaLongElement7() {
        this.helpResolve("select * from xmltest.doc4 where root.node3 = 'yyz'");
    }

    @Test
    public void testXMLCriteriaLongElement8() {
        this.helpResolve("select * from xmltest.doc4 where node3 = 'yyz'");
    }

    @Test
    public void testXMLCriteriaLongElementFail1() {
        this.helpResolveException("select * from xmltest.doc4 where node3.node1.node2 = 'xyz'");
    }

    @Test
    public void testXMLCriteriaLongElementFail2() {
        this.helpResolveException("select * from xmltest.doc4 where root.node1.node2.node3 = 'xyz'");
    }

    @Test
    public void testXMLCriteriaLongElementFail3() {
        this.helpResolveException("select * from xmltest.doc4 where root.node1.node3 = 'xyz'");
    }

    @Test
    public void testXMLCriteriaLongElementFail4() {
        this.helpResolveException("select * from xmltest.doc4 where node2.node1.node2 = 'xyz'");
    }

    @Test
    public void testXMLCriteriaTempElement1() {
        this.helpResolve("select * from xmltest.doc4 where tm1.g1.e1 = 'x'");
    }

    @Test
    public void testXMLCriteriaTempElement2() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'yyz' and tm1.g1.e2 = 'y'");
    }

    @Test
    public void testXMLCriteriaTempElement3() {
        this.helpResolve("select * from xmltest.doc4 where tm1.g1.e1 = 'x' and tm1.g1.e2 = 'y'");
    }

    @Test
    public void testXMLCriteriaTempElementFail1() {
        this.helpResolveException("select * from xmltest.doc4 where tm1.g2.e1 = 'xyz'");
    }

    @Test
    public void testXMLCriteriaTempElementFail2() {
        this.helpResolveException("select * from xmltest.doc4 where root.node1.node2.node3 = 'xyz' and e1 = 'x'");
    }

    @Test
    public void testXMLCriteriaTempElementFail3() {
        this.helpResolveException("select * from xmltest.doc4 where e3 = 'xyz' and tm1.g2.e4='m'");
    }

    @Test
    public void testXMLAmbiguousName1() {
        this.helpResolve("select * from xmltest.doc4 where root.node1 is null");
    }

    @Test
    public void testXMLAmbiguousName2() {
        this.helpResolve("select * from xmltest.doc4 where tm1.g1.node1 = 'yyz'");
    }

    @Test
    public void testXMLAmbiguousName3() {
        this.helpResolveException("select * from xmltest.doc4 where node1 = 'yyz'");
    }

    @Test
    public void testXMLCriteriaLongElementInAnonymous() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc2");
        ElementSymbol es = new ElementSymbol("root.node1.node3", gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc2 where root.node1.node3 = 'yyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testXMLAmbiguousShortName() {
        this.helpResolveException("select * from xmltest.doc3 where node2 = 'yyz'");
    }

    @Test
    public void testXMLAttributeInCriteria() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.@node2 = 'x'");
    }

    @Test
    public void testXMLAttributeInCriteria2() {
        this.helpResolve("select * from xmltest.doc4 where root.node1.node2 = 'x'");
    }

    @Test
    public void testXMLAttributeInCriteria3() {
        this.helpResolve("select * from xmltest.doc4 where node2 = 'x'");
    }

    @Test
    public void testXMLAttributeElementAmbiguity1() {
        this.helpResolve("select * from xmltest.doc4 where root.node3.node4 = 'x'");
    }

    @Test
    public void testXMLAttributeElementAmbiguity2() {
        this.helpResolve("select * from xmltest.doc4 where root.node3.@node4 = 'x'");
    }

    @Test
    public void testXMLAttributeElementAmbiguity3() {
        this.helpResolve("select * from xmltest.doc4 where root.node3.node4 = 'x' and root.node3.@node4='y'");
    }

    @Test
    public void testXMLAttributeElementAmbiguity4() {
        this.helpResolve("select * from xmltest.doc4 where root.node6 = 'x'");
    }

    @Test
    public void testXMLAttributeElementAmbiguity5() {
        this.helpResolve("select * from xmltest.doc4 where root.@node6 = 'x'");
    }

    @Test
    public void testXMLAttributeFullPath() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.@node6 = 'x'");
    }

    @Test
    public void testXMLCriteriaLongElementWithGroup1() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.node1 = 'yyz'");
    }

    @Test
    public void testXMLCriteriaLongElementWithGroup2() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.node1.@node2 = 'yyz'");
    }

    @Test
    public void testXMLCriteriaLongElementWithGroup3() {
        this.helpResolve("select * from xmltest.doc4 where xmltest.doc4.root.node3 = 'yyz'");
    }

    @Test
    public void testXMLSelect() {
        this.helpResolve("select root.node3.@node4 from xmltest.doc4");
    }

    @Test
    public void testXMLSelect2() {
        this.helpResolve("select root.node3.node4 from xmltest.doc4");
    }

    @Test
    public void testXMLSelect3() {
        this.helpResolve("select root.@node6 from xmltest.doc4");
    }

    @Test
    public void testXMLSelect4() {
        this.helpResolve("select root.node6 from xmltest.doc4");
    }

    @Test
    public void testXMLSelect5() {
        this.helpResolve("select node2 from xmltest.doc4");
    }

    @Test
    public void testDEFECT_19771() {
        this.helpResolveException("select node2 AS NODE2 from xmltest.doc4");
    }

    @Test
    public void testContext() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1.node2.node3", gs1);
        ElementSymbol es2 = new ElementSymbol("root.node1", gs1);
        Expression[] exprs = new Expression[]{es1, es2};
        Function context = new Function("context", exprs);
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)context);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where context(node3, node1) = 'yyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testRowLimit() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1.node2.node3", gs1);
        es1.setGroupSymbol(gs1);
        Expression[] exprs = new Expression[]{es1};
        Function context = new Function("rowlimit", exprs);
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)context);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)new Integer(2)));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where rowlimit(node3) = 2");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testRowLimitException() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1.node2.node3", gs1);
        Expression[] exprs = new Expression[]{es1};
        Function context = new Function("rowlimitexception", exprs);
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)context);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)new Integer(2)));
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where rowlimitexception(node3) = 2");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testXMLQueryFail1() {
        this.helpResolveException("SELECT DISTINCT * FROM vm1.doc1");
    }

    @Test
    public void testXMLQueryFail2() {
        this.helpResolveException("SELECT a2 FROM vm1.doc1");
    }

    @Test
    public void testXMLQueryFail3() {
        this.helpResolveException("SELECT * FROM vm1.doc1, vm1.doc2");
    }

    @Test
    public void testXMLWithOrderBy1() {
        this.helpResolveException("select * from xmltest.doc4 order by node1");
    }

    @Test
    public void testConversionInXML() {
        GroupSymbol gs1 = new GroupSymbol("xmltest.doc1");
        ElementSymbol es1 = new ElementSymbol("root.node1", gs1);
        Function convert = new Function("convert", new Expression[]{new Constant((Object)new Integer(5)), new Constant((Object)"string")});
        CompareCriteria expected = new CompareCriteria();
        expected.setLeftExpression((Expression)es1);
        expected.setOperator(1);
        expected.setRightExpression((Expression)convert);
        Query query = (Query)this.helpResolve("select * from xmltest.doc1 where node1 = convert(5, string)");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
        Function actualRightExpr = (Function)((CompareCriteria)actual).getRightExpression();
        Assert.assertNotNull((String)"Failed to resolve function", (Object)actualRightExpr.getFunctionDescriptor());
    }

    @Test
    public void testXMLWithSelect1() throws Exception {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)TestResolver.helpResolve(QueryParser.getQueryParser().parseCommand("select \"xml\" from xmltest.doc1 where node1 = 'yyz'"), (QueryMetadataInterface)RealMetadataFactory.example1Cached());
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }

    @Test
    public void testXMLWithSelect1a() {
        this.helpResolveException("select 'a' from xmltest.doc1 where node1 = 'yyz'", "Error Code:TEIID30134 Message:TEIID30134 Expressions cannot be selected by XML Queries");
    }

    @Test
    public void testXMLWithSelect2() {
        CompareCriteria expected = new CompareCriteria();
        GroupSymbol gs = new GroupSymbol("xmltest.doc1");
        ElementSymbol es = new ElementSymbol("root.node1", gs);
        expected.setLeftExpression((Expression)es);
        expected.setOperator(1);
        expected.setRightExpression((Expression)new Constant((Object)"yyz"));
        Query query = (Query)this.helpResolve("select xmltest.doc1.xml from xmltest.doc1 where node1 = 'yyz'");
        Criteria actual = query.getCriteria();
        Assert.assertEquals((String)"Did not match expected criteria", (Object)expected, (Object)actual);
    }
}

