/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class TestCriteria
extends TestCase {
    public TestCriteria(String arg0) {
        super(arg0);
    }

    public CompareCriteria exampleCompareCrit(int num) {
        return new CompareCriteria((Expression)new ElementSymbol("" + num), 1, (Expression)new Constant((Object)("" + num)));
    }

    public void helpTestSeparateCriteria(Criteria originalCrit, Criteria[] partsArray) {
        List<Criteria> expectedParts = Arrays.asList(partsArray);
        List actualParts = Criteria.separateCriteriaByAnd((Criteria)originalCrit);
        TestCriteria.assertEquals((String)"Didn't get the same parts ", expectedParts, (Object)actualParts);
    }

    public void testSeparateCriteriaByAnd1() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        this.helpTestSeparateCriteria((Criteria)crit1, new Criteria[]{crit1});
    }

    public void testSeparateCriteriaByAnd2() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        CompareCriteria crit2 = this.exampleCompareCrit(2);
        CompoundCriteria compCrit = new CompoundCriteria();
        compCrit.setOperator(0);
        compCrit.addCriteria((Criteria)crit1);
        compCrit.addCriteria((Criteria)crit2);
        this.helpTestSeparateCriteria((Criteria)compCrit, new Criteria[]{crit1, crit2});
    }

    public void testSeparateCriteriaByAnd3() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        CompareCriteria crit2 = this.exampleCompareCrit(2);
        CompareCriteria crit3 = this.exampleCompareCrit(3);
        CompoundCriteria compCrit1 = new CompoundCriteria();
        compCrit1.setOperator(0);
        compCrit1.addCriteria((Criteria)crit2);
        compCrit1.addCriteria((Criteria)crit3);
        CompoundCriteria compCrit2 = new CompoundCriteria();
        compCrit2.setOperator(0);
        compCrit2.addCriteria((Criteria)crit1);
        compCrit2.addCriteria((Criteria)compCrit1);
        this.helpTestSeparateCriteria((Criteria)compCrit2, new Criteria[]{crit1, crit2, crit3});
    }

    public void testSeparateCriteriaByAnd4() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        CompareCriteria crit2 = this.exampleCompareCrit(2);
        CompareCriteria crit3 = this.exampleCompareCrit(3);
        CompoundCriteria compCrit1 = new CompoundCriteria();
        compCrit1.setOperator(1);
        compCrit1.addCriteria((Criteria)crit2);
        compCrit1.addCriteria((Criteria)crit3);
        CompoundCriteria compCrit2 = new CompoundCriteria();
        compCrit2.setOperator(0);
        compCrit2.addCriteria((Criteria)crit1);
        compCrit2.addCriteria((Criteria)compCrit1);
        this.helpTestSeparateCriteria((Criteria)compCrit2, new Criteria[]{crit1, compCrit1});
    }

    public void testSeparateCriteriaByAnd5() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        CompareCriteria crit2 = this.exampleCompareCrit(2);
        CompareCriteria crit3 = this.exampleCompareCrit(3);
        CompoundCriteria compCrit1 = new CompoundCriteria();
        compCrit1.setOperator(0);
        compCrit1.addCriteria((Criteria)crit2);
        compCrit1.addCriteria((Criteria)crit3);
        NotCriteria notCrit = new NotCriteria((Criteria)compCrit1);
        CompoundCriteria compCrit2 = new CompoundCriteria();
        compCrit2.setOperator(0);
        compCrit2.addCriteria((Criteria)crit1);
        compCrit2.addCriteria((Criteria)notCrit);
        this.helpTestSeparateCriteria((Criteria)compCrit2, new Criteria[]{crit1, notCrit});
    }

    public void helpTestCombineCriteria(Criteria crit1, Criteria crit2, Criteria expected) {
        Criteria actual = Criteria.combineCriteria((Criteria)crit1, (Criteria)crit2);
        TestCriteria.assertEquals((String)"Didn't combine the criteria correctly ", (Object)expected, (Object)actual);
    }

    public void testCombineCriteria1() {
        this.helpTestCombineCriteria(null, null, null);
    }

    public void testCombineCriteria2() {
        this.helpTestCombineCriteria((Criteria)this.exampleCompareCrit(1), null, (Criteria)this.exampleCompareCrit(1));
    }

    public void testCombineCriteria3() {
        this.helpTestCombineCriteria(null, (Criteria)this.exampleCompareCrit(1), (Criteria)this.exampleCompareCrit(1));
    }

    public void testCombineCriteria4() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        CompareCriteria crit2 = this.exampleCompareCrit(2);
        CompoundCriteria compCrit = new CompoundCriteria();
        compCrit.setOperator(0);
        compCrit.addCriteria((Criteria)crit1);
        compCrit.addCriteria((Criteria)crit2);
        this.helpTestCombineCriteria((Criteria)crit1, (Criteria)crit2, (Criteria)compCrit);
    }

    public void testCombineCriteria5() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        CompareCriteria crit2 = this.exampleCompareCrit(2);
        CompareCriteria crit3 = this.exampleCompareCrit(3);
        CompoundCriteria compCrit = new CompoundCriteria();
        compCrit.setOperator(0);
        compCrit.addCriteria((Criteria)crit1);
        compCrit.addCriteria((Criteria)crit2);
        CompoundCriteria compCrit2 = new CompoundCriteria();
        compCrit2.setOperator(0);
        compCrit2.addCriteria((Criteria)crit1);
        compCrit2.addCriteria((Criteria)crit2);
        compCrit2.addCriteria((Criteria)crit3);
        this.helpTestCombineCriteria((Criteria)compCrit, (Criteria)crit3, (Criteria)compCrit2);
    }

    public void testCombineCriteria6() {
        CompareCriteria crit1 = this.exampleCompareCrit(1);
        CompareCriteria crit2 = this.exampleCompareCrit(2);
        CompareCriteria crit3 = this.exampleCompareCrit(3);
        CompoundCriteria compCrit = new CompoundCriteria();
        compCrit.setOperator(0);
        compCrit.addCriteria((Criteria)crit1);
        compCrit.addCriteria((Criteria)crit2);
        CompoundCriteria compCrit2 = new CompoundCriteria();
        compCrit2.setOperator(0);
        compCrit2.addCriteria((Criteria)crit3);
        compCrit2.addCriteria((Criteria)crit1);
        compCrit2.addCriteria((Criteria)crit2);
        this.helpTestCombineCriteria((Criteria)crit3, (Criteria)compCrit, (Criteria)compCrit2);
    }
}

