/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.teiid.core.TeiidException;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;

public class TestDeepGroupCollectorVisitor
extends TestCase {
    public TestDeepGroupCollectorVisitor(String name) {
        super(name);
    }

    public void helpTestVisitor(String sql, String[] expectedGroups) {
        Command obj = null;
        try {
            QueryParser parser = new QueryParser();
            obj = parser.parseCommand(sql);
        }
        catch (TeiidException e) {
            TestDeepGroupCollectorVisitor.fail((String)("Unexpected exception while parsing: " + e.getFullMessage()));
        }
        Collection actualGroups = GroupCollectorVisitor.getGroupsIgnoreInlineViews((LanguageObject)obj, (boolean)false);
        TestDeepGroupCollectorVisitor.assertEquals((String)"Did not get expected number of groups", (int)expectedGroups.length, (int)actualGroups.size());
        Iterator iter = actualGroups.iterator();
        int i = 0;
        while (iter.hasNext()) {
            GroupSymbol group = (GroupSymbol)iter.next();
            TestDeepGroupCollectorVisitor.assertTrue((String)("Expected group did not match, expected=" + expectedGroups[i] + ", actual=" + group), (boolean)group.getName().equalsIgnoreCase(expectedGroups[i]));
            ++i;
        }
    }

    public void testQuery1() {
        this.helpTestVisitor("SELECT * FROM pm1.g1", new String[]{"pm1.g1"});
    }

    public void testSubquery1() {
        this.helpTestVisitor("SELECT * FROM (SELECT * FROM pm1.g1) AS x", new String[]{"pm1.g1"});
    }

    public void testSubquery2() {
        this.helpTestVisitor("SELECT * FROM (SELECT * FROM pm1.g1) AS x, pm1.g2", new String[]{"pm1.g1", "pm1.g2"});
    }

    public void testSubquery3() {
        this.helpTestVisitor("SELECT * FROM pm1.g2 WHERE e1 IN (SELECT * FROM pm1.g1)", new String[]{"pm1.g2", "pm1.g1"});
    }

    public void testSubquery4() {
        this.helpTestVisitor("SELECT * FROM pm1.g2 WHERE e1 IN (SELECT * FROM pm1.g1, (SELECT * FROM pm1.g3) AS x)", new String[]{"pm1.g2", "pm1.g1", "pm1.g3"});
    }

    public void testExec1() {
        this.helpTestVisitor("EXEC pm1.sq1()", new String[]{"pm1.sq1"});
    }

    public void testSubqueryExec1() {
        this.helpTestVisitor("SELECT * FROM (EXEC pm1.sq1()) AS x", new String[]{"pm1.sq1"});
    }

    public void testUnionInSubquery() {
        this.helpTestVisitor("SELECT x.intkey FROM (SELECT intkey FROM BQT1.SmallA UNION SELECT intkey FROM BQT1.SmallB) AS x", new String[]{"BQT1.SmallA", "BQT1.SmallB"});
    }

    public void testUnionOfSubquery() {
        this.helpTestVisitor("SELECT x.intkey FROM (SELECT intkey FROM BQT1.SmallA) AS x UNION SELECT intkey FROM BQT1.SmallB", new String[]{"BQT1.SmallA", "BQT1.SmallB"});
    }

    public void testSubqueryInCriteria() {
        this.helpTestVisitor("SELECT * FROM BQT1.SmallA WHERE intkey IN (SELECT intkey FROM BQT1.SmallB)", new String[]{"BQT1.SmallA", "BQT1.SmallB"});
    }

    public void testUnionSubqueryInCriteria() {
        this.helpTestVisitor("SELECT * FROM BQT1.SmallA WHERE intkey IN (SELECT intkey FROM BQT1.SmallB UNION SELECT intkey FROM BQT2.SmallA)", new String[]{"BQT1.SmallA", "BQT1.SmallB", "BQT2.SmallA"});
    }
}

