/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.TestCaseExpression;
import org.teiid.query.sql.symbol.TestSearchedCaseExpression;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public class TestExpressionMappingVisitor {
    public void helpTest(LanguageObject original, Map map, LanguageObject expected) {
        ExpressionMappingVisitor.mapExpressions((LanguageObject)original, (Map)map);
        Assert.assertEquals((String)"Did not get expected mapped expression", (Object)expected, (Object)original);
    }

    @Test
    public void testCompareCriteria1() {
        ElementSymbol e1 = new ElementSymbol("e1");
        Function f = new Function("+", new Expression[]{new Constant((Object)new Integer(2)), new Constant((Object)new Integer(5))});
        HashMap<ElementSymbol, Function> map = new HashMap<ElementSymbol, Function>();
        map.put(e1, f);
        CompareCriteria before = new CompareCriteria((Expression)e1, 1, (Expression)new Constant((Object)"xyz"));
        CompareCriteria after = new CompareCriteria((Expression)f, 1, (Expression)new Constant((Object)"xyz"));
        this.helpTest((LanguageObject)before, map, (LanguageObject)after);
    }

    @Test
    public void testCompareCriteria2() {
        ElementSymbol e1 = new ElementSymbol("e1");
        Function f = new Function("+", new Expression[]{new Constant((Object)new Integer(2)), new Constant((Object)new Integer(5))});
        HashMap<ElementSymbol, Function> map = new HashMap<ElementSymbol, Function>();
        map.put(e1, f);
        CompareCriteria before = new CompareCriteria((Expression)new Constant((Object)"xyz"), 1, (Expression)e1);
        CompareCriteria after = new CompareCriteria((Expression)new Constant((Object)"xyz"), 1, (Expression)f);
        this.helpTest((LanguageObject)before, map, (LanguageObject)after);
    }

    @Test
    public void testFunction1() {
        ElementSymbol e1 = new ElementSymbol("e1");
        ElementSymbol e2 = new ElementSymbol("e2");
        ElementSymbol e3 = new ElementSymbol("e3");
        ElementSymbol e4 = new ElementSymbol("e4");
        Function f1 = new Function("+", new Expression[]{e1, e2});
        Function f2 = new Function("+", new Expression[]{f1, e3});
        Function f3 = new Function("+", new Expression[]{f2, e4});
        ElementSymbol e5 = new ElementSymbol("e5");
        ElementSymbol e6 = new ElementSymbol("e6");
        ElementSymbol e7 = new ElementSymbol("e7");
        Function f4 = new Function("*", new Expression[]{e5, e6});
        HashMap<ElementSymbol, Object> map = new HashMap<ElementSymbol, Object>();
        map.put(e3, f4);
        map.put(e2, e7);
        Function f5 = new Function("+", new Expression[]{e1, e7});
        Function f6 = new Function("+", new Expression[]{f5, f4});
        Function f7 = new Function("+", new Expression[]{f6, e4});
        this.helpTest((LanguageObject)f3, map, (LanguageObject)f7);
    }

    @Test
    public void testSetCriteria() {
        ElementSymbol e1 = new ElementSymbol("e1");
        ElementSymbol e2 = new ElementSymbol("e2");
        Constant c1 = new Constant((Object)"xyz");
        Constant c2 = new Constant((Object)"abc");
        Constant c3 = new Constant((Object)"def");
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(c1);
        values.add(c2);
        ArrayList<Constant> mappedValues = new ArrayList<Constant>();
        mappedValues.add(c1);
        mappedValues.add(c3);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(e1, e2);
        map.put(c2, c3);
        SetCriteria before = new SetCriteria((Expression)e1, values);
        SetCriteria after = new SetCriteria((Expression)e2, mappedValues);
        this.helpTest((LanguageObject)before, map, (LanguageObject)after);
    }

    @Test
    public void testCaseExpression1() {
        ElementSymbol x = new ElementSymbol("x");
        ElementSymbol y = new ElementSymbol("y");
        Constant a = new Constant((Object)String.valueOf('a'));
        Constant z = new Constant((Object)String.valueOf('z'));
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(x, y);
        map.put(a, z);
        ArrayList<Constant> whens = new ArrayList<Constant>();
        ArrayList<Constant> thens = new ArrayList<Constant>();
        whens.add(new Constant((Object)String.valueOf('z')));
        thens.add(new Constant((Object)new Integer(0)));
        whens.add(new Constant((Object)String.valueOf('b')));
        thens.add(new Constant((Object)new Integer(1)));
        whens.add(new Constant((Object)String.valueOf('c')));
        thens.add(new Constant((Object)new Integer(2)));
        CaseExpression mapped = new CaseExpression((Expression)y, whens, thens);
        mapped.setElseExpression((Expression)new Constant((Object)new Integer(9999)));
        this.helpTest((LanguageObject)TestCaseExpression.example(3), map, (LanguageObject)mapped);
    }

    @Test
    public void testCaseExpression2() {
        ElementSymbol x = new ElementSymbol("x");
        ElementSymbol y = new ElementSymbol("y");
        HashMap<ElementSymbol, ElementSymbol> map = new HashMap<ElementSymbol, ElementSymbol>();
        map.put(x, y);
        ArrayList<CompareCriteria> whens = new ArrayList<CompareCriteria>();
        ArrayList<Constant> thens = new ArrayList<Constant>();
        whens.add(new CompareCriteria((Expression)y, 1, (Expression)new Constant((Object)new Integer(0))));
        thens.add(new Constant((Object)new Integer(0)));
        whens.add(new CompareCriteria((Expression)y, 1, (Expression)new Constant((Object)new Integer(1))));
        thens.add(new Constant((Object)new Integer(1)));
        whens.add(new CompareCriteria((Expression)y, 1, (Expression)new Constant((Object)new Integer(2))));
        thens.add(new Constant((Object)new Integer(2)));
        SearchedCaseExpression mapped = new SearchedCaseExpression(whens, thens);
        mapped.setElseExpression((Expression)new Constant((Object)new Integer(9999)));
        this.helpTest((LanguageObject)TestSearchedCaseExpression.example(3), map, (LanguageObject)mapped);
    }

    @Test
    public void testSelectAlias() {
        ElementSymbol x = new ElementSymbol("y.x");
        ElementSymbol y = new ElementSymbol("z.X");
        HashMap<ElementSymbol, ElementSymbol> map = new HashMap<ElementSymbol, ElementSymbol>();
        map.put(x, y);
        Select toMap = new Select(Arrays.asList(x));
        ExpressionMappingVisitor.mapExpressions((LanguageObject)toMap, map);
        Assert.assertEquals((String)"Did not get expected mapped expression", (Object)" z.X AS x", (Object)toMap.toString());
    }

    @Test
    public void testSelectAlias1() {
        ElementSymbol x = new ElementSymbol("y.x");
        ElementSymbol y = new ElementSymbol("z.x");
        HashMap<ElementSymbol, ElementSymbol> map = new HashMap<ElementSymbol, ElementSymbol>();
        map.put(x, y);
        Select toMap = new Select(Arrays.asList(x));
        ExpressionMappingVisitor.mapExpressions((LanguageObject)toMap, map);
        Assert.assertEquals((String)"Did not get expected mapped expression", (Object)" z.x", (Object)toMap.toString());
    }

    @Test
    public void testRecursionDetection() {
        ElementSymbol e1 = new ElementSymbol("g1.e1");
        AggregateSymbol a1 = new AggregateSymbol("SUM", false, (Expression)e1);
        Function f = new Function("+", new Expression[]{a1, a1});
        HashMap<AggregateSymbol, AggregateSymbol> map = new HashMap<AggregateSymbol, AggregateSymbol>();
        map.put(a1, new AggregateSymbol("SUM", false, (Expression)a1));
        ExpressionMappingVisitor.mapExpressions((LanguageObject)f, map);
        Assert.assertEquals((Object)"(SUM(SUM(g1.e1)) + SUM(SUM(g1.e1)))", (Object)f.toString());
    }
}

