/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types;

import java.sql.SQLXML;
import junit.framework.TestCase;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.UnitTestUtil;

public class TestXMLValue
extends TestCase {
    public void testXMLValue() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        TestXMLValue.assertEquals((String)testString, (String)xv.getString());
    }

    public void testXMLValuePersistence() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        String key = xv.getReferenceStreamId();
        XMLType read = UnitTestUtil.helpSerialize(xv);
        TestXMLValue.assertEquals((String)key, (String)read.getReferenceStreamId());
        TestXMLValue.assertNull((Object)read.getReference());
    }

    public void testReferencePersistence() throws Exception {
        String testString = "<foo>this is an xml value test</foo>";
        SQLXMLImpl xml = new SQLXMLImpl(testString);
        XMLType xv = new XMLType((SQLXML)xml);
        xv.setReferenceStreamId(null);
        XMLType read = UnitTestUtil.helpSerialize(xv);
        TestXMLValue.assertEquals((String)testString, (String)read.getString());
    }
}

