/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.sql.DriverPropertyInfo;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.jdbc.TeiidDriver;

public class TestTeiidDriver {
    TeiidDriver drv = new TeiidDriver();
    public String localhost = "localhost";

    @Test
    public void testAccepts() throws Exception {
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345;user=foo;password=bar"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@/foo/blah/deploy.properties"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345;user=foo;password=bar"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@/foo/blah/deploy.properties"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:8294601c-9fe9-4244-9499-4a012c5e1476_vdb"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:8294601c-9fe9-4244-9499-4a012c5e1476_vdb@mm://localhost:12345"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb@mm://local-host:12345"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb@mm://local_host:12345"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb.1@mm://local_host:12345"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb.10@mm://local_host:12345"));
    }

    @Test
    public void testAcceptsURL1() throws Exception {
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@mm://localhost:1234"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@mms://localhost:1234"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://127.0.0.1:1234;logLevel=2"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://127.0.0.1:1234"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://127.0.0.1:1234,localhost.mydomain.com:63636;logLevel=2"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://my-host.mydomain.com:53535,127.0.0.1:1234"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://123.123.123.123:53535,127.0.0.1:1234"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@c:/dqp.properties;version=1"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@/foo/dqp.properties;version=1"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@../foo/dqp.properties;version=1"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@mm://localhost:port"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@localhost:port;version=x"));
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;stickyConnections=false;socketsPerVM=4") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://my_host.mydomain.com:53535,127.0.0.1:1234"));
        Assert.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;version=x;useJDBC4ColumnNameAndLabelSemantics=false"));
    }

    @Test
    public void testAcceptsURL2() throws Exception {
        Assert.assertTrue((!this.drv.acceptsURL("jdbc:matamatrix:test") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("metamatrix:test") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc&matamatrix:test") ? 1 : 0) != 0);
        Assert.assertTrue((!this.drv.acceptsURL("jdbc;metamatrix:test") ? 1 : 0) != 0);
    }

    @Test
    public void testParseURL() throws Exception {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234"));
        Assert.assertEquals((long)3L, (long)p.size());
    }

    @Test
    public void testParseURL2() throws Exception {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mms://slwxp157:1234;version=3", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mms://slwxp157:1234"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("3"));
        Assert.assertTrue((boolean)p.getProperty("ApplicationName").equals("JDBC"));
        Assert.assertEquals((long)5L, (long)p.size());
    }

    @Test
    public void testParseURL3() throws Exception {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302;version=4;autoCommitTxn=ON;partialResultsMode=YES;ApplicationName=Client", (Properties)p);
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assert.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        Assert.assertTrue((boolean)p.getProperty("autoCommitTxn").equals("ON"));
        Assert.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        Assert.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302"));
        Assert.assertTrue((boolean)p.getProperty("version").equals("4"));
        Assert.assertTrue((boolean)p.getProperty("ApplicationName").equals("Client"));
        Assert.assertEquals((long)7L, (long)p.size());
    }

    @Test
    public void testGetPropertyInfo1() throws Exception {
        DriverPropertyInfo[] info = this.drv.getPropertyInfo("jdbc:teiid:vdb@mm://localhost:12345;applicationName=x", null);
        Assert.assertEquals((long)25L, (long)info.length);
        Assert.assertEquals((Object)false, (Object)info[0].required);
        Assert.assertEquals((Object)"ApplicationName", (Object)info[0].name);
        Assert.assertEquals((Object)"x", (Object)info[0].value);
    }
}

