/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminshell;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.ObjectConverterUtil;

public class MigrationUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        File file;
        if (args.length != 1) {
            System.err.println("Teiid 7.0 VDB Migration Utility\n\nUsage:\n  A vdb or .def file must be specified as the only argument.\n\nResult:\n  7.0 compatible replacement files will be created in the same directory \n  as your file.\n  If you supply a vdb, the new vdb file will have a _70.vdb suffix.\n  If you supply a dynamic vdb file, <file name>-vdb.xml is created \n\nNote: This program will create translator names by Connector's Component Type name\n  As they are not gureented to match; recheck their for their validity\n\nNote: this program will NOT create the -ds.xml files needed by JBoss to \n      create underlying DataSource connection pools.\n      You will need to manually create one -ds.xml for each JDBC DataSource \n      with a JNDI name of <connector binding name>DS, \n      where any spaces in the name are replace by _");
            System.exit(-1);
        }
        if (!(file = new File(args[0])).exists()) {
            System.err.println(args[0] + " does not exist.");
            System.exit(-1);
        }
        String fullName = file.getName();
        String fileName = fullName.substring(0, fullName.length() - 4);
        String ext = FileUtils.getExtension((File)file);
        if (ext == null) {
            System.err.println(fullName + " is not a vdb or xml file.");
            System.exit(-1);
        }
        if ((ext = ext.toLowerCase()).endsWith("vdb")) {
            File dir = MigrationUtil.createTempDirectory();
            try {
                MigrationUtil.extract(file, dir);
                File metainf = new File(dir, "META-INF");
                File config = new File(dir, "ConfigurationInfo.def");
                File manifest = new File(dir, "MetaMatrix-VdbManifestModel.xmi");
                if (manifest.exists()) {
                    String configStr = ObjectConverterUtil.convertFileToString((File)config);
                    String manifestStr = ObjectConverterUtil.convertFileToString((File)manifest);
                    int index = configStr.lastIndexOf("</VDB>");
                    int manifestBegin = manifestStr.indexOf("<xmi");
                    configStr = configStr.substring(0, index) + manifestStr.substring(manifestBegin) + "</VDB>";
                    FileUtils.write((byte[])configStr.getBytes(), (File)config);
                    manifest.delete();
                }
                MigrationUtil.transformConfig(config, "/vdb.xsl", new StreamResult(new File(metainf, "vdb.xml")));
                config.delete();
                FileOutputStream out = new FileOutputStream(new File(file.getParent(), fileName + "_70.vdb"));
                ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(out));
                int parentLength = dir.getPath().length();
                MigrationUtil.addDirectory(dir, zos, parentLength);
                zos.close();
            }
            finally {
                FileUtils.removeDirectoryAndChildren((File)dir);
            }
        } else if (ext.endsWith("xml") || ext.endsWith("def")) {
            File parent = file.getParentFile();
            MigrationUtil.transformConfig(file, "/vdb.xsl", new StreamResult(new File(parent, fileName + "-vdb.xml")));
        } else {
            System.err.println(fullName + " is not a vdb or xml file.  Run with no arguments for help.");
            System.exit(-1);
        }
    }

    private static void addDirectory(File dir, ZipOutputStream zos, int parentLength) throws IOException {
        String[] files;
        for (String entry : files = dir.list()) {
            File f = new File(dir, entry);
            if (f.isDirectory()) {
                MigrationUtil.addDirectory(f, zos, parentLength);
                continue;
            }
            ZipEntry e = new ZipEntry(f.getPath().substring(parentLength));
            zos.putNextEntry(e);
            FileUtils.write((File)f, (OutputStream)zos);
            zos.closeEntry();
        }
    }

    private static void transformConfig(File config, String styleSheet, Result target) throws TransformerFactoryConfigurationError, TransformerConfigurationException, TransformerException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = tf.newTransformer(new StreamSource(MigrationUtil.class.getResourceAsStream(styleSheet)));
        t.setParameter("version", ApplicationInfo.getInstance().getReleaseNumber());
        t.transform(new StreamSource(config), target);
    }

    static void extract(File sourceZipFile, File unzipDestinationDirectory) throws IOException {
        ZipFile zipFile = new ZipFile(sourceZipFile, 1);
        Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            String currentEntry = entry.getName();
            File destFile = new File(unzipDestinationDirectory, currentEntry);
            File destinationParent = destFile.getParentFile();
            destinationParent.mkdirs();
            if (entry.isDirectory()) continue;
            ObjectConverterUtil.write((InputStream)zipFile.getInputStream(entry), (File)destFile);
        }
        zipFile.close();
    }

    static File createTempDirectory() throws IOException {
        File temp = File.createTempFile("temp", Long.toString(System.nanoTime()));
        temp.delete();
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

