/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.dqp.internal.datamgr.LanguageBridgeFactory;
import org.teiid.dqp.internal.datamgr.TestLiteralImpl;
import org.teiid.dqp.internal.datamgr.TstLanguageBridgeFactory;
import org.teiid.language.AndOr;
import org.teiid.language.In;
import org.teiid.language.Literal;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestInCriteriaImpl {
    public static SetCriteria helpExample(boolean negated) {
        ArrayList<Constant> values = new ArrayList<Constant>();
        values.add(TestLiteralImpl.helpExample(100));
        values.add(TestLiteralImpl.helpExample(200));
        values.add(TestLiteralImpl.helpExample(300));
        values.add(TestLiteralImpl.helpExample(400));
        SetCriteria crit = new SetCriteria((Expression)TestLiteralImpl.helpExample(300), values);
        crit.setNegated(negated);
        return crit;
    }

    public static In example(boolean negated) throws Exception {
        return (In)TstLanguageBridgeFactory.factory.translate(TestInCriteriaImpl.helpExample(negated));
    }

    @Test
    public void testGetLeftExpression() throws Exception {
        In inCriteria = TestInCriteriaImpl.example(false);
        Assert.assertNotNull((Object)inCriteria.getLeftExpression());
        Assert.assertTrue((boolean)(inCriteria.getLeftExpression() instanceof Literal));
        Assert.assertEquals((Object)new Integer(300), (Object)((Literal)inCriteria.getLeftExpression()).getValue());
    }

    @Test
    public void testExpansion() throws Exception {
        SetCriteria inCriteria = TestInCriteriaImpl.helpExample(false);
        LanguageBridgeFactory lbf = new LanguageBridgeFactory((QueryMetadataInterface)RealMetadataFactory.example1Cached());
        lbf.setConvertIn(true);
        AndOr or = (AndOr)lbf.translate(inCriteria);
        Assert.assertEquals((Object)AndOr.Operator.OR, (Object)or.getOperator());
        inCriteria.setNegated(true);
        AndOr and = (AndOr)lbf.translate(inCriteria);
        Assert.assertEquals((Object)AndOr.Operator.AND, (Object)and.getOperator());
    }

    @Test
    public void testGetRightExpressions() throws Exception {
        List values = TestInCriteriaImpl.example(false).getRightExpressions();
        Assert.assertNotNull((Object)values);
        Assert.assertEquals((long)4L, (long)values.size());
    }

    @Test
    public void testIsNegated() throws Exception {
        Assert.assertTrue((boolean)TestInCriteriaImpl.example(true).isNegated());
        Assert.assertFalse((boolean)TestInCriteriaImpl.example(false).isNegated());
    }
}

