/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.mockito.Mockito;
import org.teiid.PolicyDecider;
import org.teiid.client.RequestMessage;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.FakeTransactionService;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataRolePolicyDecider;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.dqp.internal.process.PreparedPlan;
import org.teiid.dqp.internal.process.PreparedStatementRequest;
import org.teiid.dqp.internal.process.Request;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.service.AutoGenDataService;
import org.teiid.dqp.service.TransactionService;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestRequest
extends TestCase {
    private static final TempTableStore TEMP_TABLE_STORE = new TempTableStore("1", TempTableStore.TransactionMode.ISOLATE_WRITES);
    private static final String QUERY = "SELECT * FROM pm1.g1";

    public TestRequest(String name) {
        super(name);
    }

    public void testValidateEntitlement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        Request request = new Request();
        Command command = QueryParser.getQueryParser().parseCommand(QUERY);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
        RequestMessage message = new RequestMessage();
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, RealMetadataFactory.example1VDB());
        request.initialize(message, BufferManagerFactory.getStandaloneBufferManager(), null, (TransactionService)new FakeTransactionService(), TEMP_TABLE_STORE, workContext, null);
        request.initMetadata();
        DefaultAuthorizationValidator drav = new DefaultAuthorizationValidator();
        DataRolePolicyDecider drpd = new DataRolePolicyDecider();
        drpd.setAllowCreateTemporaryTablesByDefault(true);
        drpd.setAllowFunctionCallsByDefault(true);
        drav.setPolicyDecider((PolicyDecider)drpd);
        request.setAuthorizationValidator((AuthorizationValidator)drav);
        request.validateAccess(new String[]{QUERY}, command, AuthorizationValidator.CommandType.USER);
    }

    public void testProcessRequest() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        RequestMessage message = new RequestMessage(QUERY);
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, RealMetadataFactory.example1VDB());
        this.helpProcessMessage(message, null, workContext);
        message = new RequestMessage(QUERY);
        this.helpProcessMessage(message, null, workContext);
    }

    public void testCommandContext() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        RequestMessage message = new RequestMessage(QUERY);
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, RealMetadataFactory.example1VDB());
        Request request = this.helpProcessMessage(message, null, workContext);
        TestRequest.assertEquals((String)"1", (String)request.context.getConnectionId());
    }

    private Request helpProcessMessage(RequestMessage message, SessionAwareCache<PreparedPlan> cache, DQPWorkContext workContext) throws TeiidComponentException, TeiidProcessingException {
        Object request = null;
        request = cache != null ? new PreparedStatementRequest(cache) : new Request();
        ConnectorManagerRepository repo = (ConnectorManagerRepository)Mockito.mock(ConnectorManagerRepository.class);
        workContext.getVDB().addAttchment(ConnectorManagerRepository.class, (Object)repo);
        Mockito.stub((Object)repo.getConnectorManager(Mockito.anyString())).toReturn((Object)new AutoGenDataService());
        request.initialize(message, (BufferManager)Mockito.mock(BufferManager.class), (ProcessorDataManager)new FakeDataManager(), (TransactionService)new FakeTransactionService(), TEMP_TABLE_STORE, workContext, null);
        DefaultAuthorizationValidator drav = new DefaultAuthorizationValidator();
        request.setAuthorizationValidator((AuthorizationValidator)drav);
        request.processRequest();
        return request;
    }

    public void testProcessRequestPreparedStatement() throws Exception {
        TransformationMetadata metadata = RealMetadataFactory.example1Cached();
        SessionAwareCache cache = new SessionAwareCache();
        RequestMessage message = new RequestMessage(QUERY);
        DQPWorkContext workContext = RealMetadataFactory.buildWorkContext((QueryMetadataInterface)metadata, RealMetadataFactory.example1VDB());
        message.setStatementType(RequestMessage.StatementType.PREPARED);
        message.setParameterValues(new ArrayList());
        this.helpProcessMessage(message, (SessionAwareCache<PreparedPlan>)cache, workContext);
        message = new RequestMessage(QUERY);
        message.setStatementType(RequestMessage.StatementType.PREPARED);
        message.setParameterValues(new ArrayList());
        this.helpProcessMessage(message, (SessionAwareCache<PreparedPlan>)cache, workContext);
    }
}

