/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.progress.VerificationMode;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.cache.Cachable;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.parser.ParseInfo;

public class TestSessionAwareCache {
    @Test
    public void testSessionSpecfic() {
        SessionAwareCache cache = new SessionAwareCache();
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        cache.put(id, FunctionMethod.Determinism.SESSION_DETERMINISTIC, (Object)result, null);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).prepare((TupleBufferCache)((BufferManager)Matchers.anyObject()));
        Object c = cache.get(id);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).restore((TupleBufferCache)((BufferManager)Matchers.anyObject()));
        Assert.assertTrue((result == c ? 1 : 0) != 0);
    }

    @Test
    public void testUserSpecfic() {
        SessionAwareCache cache = new SessionAwareCache();
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Mockito.stub((Object)result.prepare((TupleBufferCache)((BufferManager)Matchers.anyObject()))).toReturn((Object)true);
        Mockito.stub((Object)result.restore((TupleBufferCache)((BufferManager)Matchers.anyObject()))).toReturn((Object)true);
        cache.put(id, FunctionMethod.Determinism.USER_DETERMINISTIC, (Object)result, null);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).prepare((TupleBufferCache)((BufferManager)Matchers.anyObject()));
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Object c = cache.get(id);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).restore((TupleBufferCache)((BufferManager)Matchers.anyObject()));
        Assert.assertTrue((result == c ? 1 : 0) != 0);
    }

    @Test
    public void testNoScope() {
        SessionAwareCache cache = new SessionAwareCache();
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Mockito.stub((Object)result.prepare((TupleBufferCache)((BufferManager)Matchers.anyObject()))).toReturn((Object)true);
        Mockito.stub((Object)result.restore((TupleBufferCache)((BufferManager)Matchers.anyObject()))).toReturn((Object)true);
        cache.put(id, FunctionMethod.Determinism.VDB_DETERMINISTIC, (Object)result, null);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).prepare((TupleBufferCache)((BufferManager)Matchers.anyObject()));
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Object c = cache.get(id);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).restore((TupleBufferCache)((BufferManager)Matchers.anyObject()));
        Assert.assertTrue((result == c ? 1 : 0) != 0);
    }

    @Test
    public void testVDBRemoval() {
        SessionAwareCache cache = new SessionAwareCache();
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Mockito.stub((Object)result.prepare((TupleBufferCache)((BufferManager)Matchers.anyObject()))).toReturn((Object)true);
        Mockito.stub((Object)result.restore((TupleBufferCache)((BufferManager)Matchers.anyObject()))).toReturn((Object)true);
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        cache.put(id, FunctionMethod.Determinism.VDB_DETERMINISTIC, (Object)result, null);
        Object c = cache.get(id);
        Assert.assertTrue((result == c ? 1 : 0) != 0);
        cache.clearForVDB("vdb-name", 1);
        Assert.assertNull((Object)cache.get(id));
    }

    public static DQPWorkContext buildWorkContext() {
        DQPWorkContext workContext = new DQPWorkContext();
        SessionMetadata session = new SessionMetadata();
        workContext.setSession(session);
        session.setVDBName("vdb-name");
        session.setVDBVersion(1);
        session.setSessionId(String.valueOf(1));
        session.setUserName("foo");
        return workContext;
    }
}

