/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Date;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.unittest.TimestampUtil;

public class TestFunctionMethods {
    @BeforeClass
    public static void oneTimeSetup() {
        TimestampWithTimezone.ISO8601_WEEK = true;
        TimestampWithTimezone.resetCalendar(null);
    }

    @AfterClass
    public static void oneTimeTearDown() {
        TimestampWithTimezone.ISO8601_WEEK = false;
        TimestampWithTimezone.resetCalendar(null);
    }

    @Test
    public void testUnescape() {
        Assert.assertEquals((Object)"a\t\n\n%6", (Object)FunctionMethods.unescape((String)"a\\t\\n\\012\\456"));
    }

    @Test
    public void testUnescape1() {
        Assert.assertEquals((Object)"a\u45aa'", (Object)FunctionMethods.unescape((String)"a\\u45Aa'"));
    }

    @Test
    public void testIso8601Week() {
        Assert.assertEquals((long)53L, (long)FunctionMethods.week((Date)TimestampUtil.createDate((int)105, (int)0, (int)1)));
    }

    @Test
    public void testIso8601Week1() {
        Assert.assertEquals((long)52L, (long)FunctionMethods.week((Date)TimestampUtil.createDate((int)106, (int)0, (int)1)));
    }

    @Test
    public void testIso8601Week2() {
        Assert.assertEquals((long)1L, (long)FunctionMethods.dayOfWeek((Date)TimestampUtil.createDate((int)111, (int)10, (int)28)));
    }
}

