/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import org.jboss.vfs.VFS;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.StoredProcedureInfo;
import org.teiid.query.metadata.SystemMetadata;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.TranslatorException;

public class TestTransformationMetadata {
    @Test
    public void testAmbiguousProc() throws Exception {
        TransformationMetadata tm = this.exampleTransformationMetadata();
        try {
            tm.getStoredProcedureInfoForProcedure("y");
            Assert.fail((String)"expected exception");
        }
        catch (QueryMetadataException e) {
            Assert.assertEquals((Object)"TEIID30358 Procedure 'y' is ambiguous, use the fully qualified name instead", (Object)e.getMessage());
        }
    }

    @Test
    public void testProcVisibility() throws Exception {
        TransformationMetadata tm = this.exampleTransformationMetadata();
        VDBMetaData vdb = tm.getVdbMetaData();
        vdb.getModel("x").setVisible(Boolean.valueOf(false));
        StoredProcedureInfo spi = tm.getStoredProcedureInfoForProcedure("y");
        Assert.assertEquals((Object)"x1.y", (Object)spi.getProcedureCallableName());
        spi = tm.getStoredProcedureInfoForProcedure("x.y");
        Assert.assertEquals((Object)"x.y", (Object)spi.getProcedureCallableName());
    }

    private TransformationMetadata exampleTransformationMetadata() throws TranslatorException {
        HashMap<String, Datatype> datatypes = new HashMap<String, Datatype>();
        Datatype dt = new Datatype();
        dt.setName("string");
        dt.setJavaClassName(String.class.getCanonicalName());
        datatypes.put("string", dt);
        MetadataFactory mf = new MetadataFactory(null, 1, "x", datatypes, new Properties(), null);
        mf.addProcedure("y");
        Table t = mf.addTable("foo");
        mf.addColumn("col", "string", (ColumnSet)t);
        MetadataFactory mf1 = new MetadataFactory(null, 1, "x1", datatypes, new Properties(), null);
        mf1.addProcedure("y");
        Table table = mf1.addTable("doc");
        table.setSchemaPaths(Arrays.asList("../../x.xsd"));
        table.setResourcePath("/a/b/doc.xmi");
        HashMap<String, TransformationMetadata.Resource> resources = new HashMap<String, TransformationMetadata.Resource>();
        resources.put("/x.xsd", new TransformationMetadata.Resource(VFS.getRootVirtualFile(), true));
        CompositeMetadataStore cms = new CompositeMetadataStore(Arrays.asList(mf.asMetadataStore(), mf1.asMetadataStore()));
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("vdb");
        vdb.setVersion(1);
        vdb.addModel(this.buildModel("x"));
        vdb.addModel(this.buildModel("x1"));
        vdb.addModel(this.buildModel("y"));
        return new TransformationMetadata(vdb, cms, resources, RealMetadataFactory.SFM.getSystemFunctions(), null);
    }

    ModelMetaData buildModel(String name) {
        ModelMetaData model = new ModelMetaData();
        model.setName(name);
        model.setModelType(Model.Type.PHYSICAL);
        model.setVisible(Boolean.valueOf(true));
        return model;
    }

    @Test
    public void testAmbiguousTableWithPrivateModel() throws Exception {
        HashMap<String, Datatype> datatypes = new HashMap<String, Datatype>();
        Datatype dt = new Datatype();
        dt.setName("string");
        dt.setJavaClassName(String.class.getCanonicalName());
        datatypes.put("string", dt);
        MetadataFactory mf = new MetadataFactory(null, 1, "x", datatypes, new Properties(), null);
        mf.addTable("y");
        MetadataFactory mf1 = new MetadataFactory(null, 1, "x1", datatypes, new Properties(), null);
        mf1.addTable("y");
        CompositeMetadataStore cms = new CompositeMetadataStore(Arrays.asList(mf.asMetadataStore(), mf1.asMetadataStore()));
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("foo");
        vdb.setVersion(1);
        ModelMetaData model = new ModelMetaData();
        model.setName("x1");
        vdb.addModel(model);
        ModelMetaData model2 = new ModelMetaData();
        model2.setName("x");
        model2.setVisible(Boolean.valueOf(true));
        vdb.addModel(model2);
        TransformationMetadata tm = new TransformationMetadata(vdb, cms, null, RealMetadataFactory.SFM.getSystemFunctions(), null);
        Collection result = tm.getGroupsForPartialName("y");
        Assert.assertEquals((long)2L, (long)result.size());
        RealMetadataFactory.buildWorkContext((QueryMetadataInterface)tm, vdb);
        model.setVisible(Boolean.valueOf(false));
        tm = new TransformationMetadata(vdb, cms, null, RealMetadataFactory.SFM.getSystemFunctions(), null);
        result = tm.getGroupsForPartialName("y");
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testElementId() throws Exception {
        TransformationMetadata tm = this.exampleTransformationMetadata();
        tm.getElementID("x.FoO.coL");
    }

    @Test
    public void testRelativeSchemas() throws Exception {
        TransformationMetadata tm = this.exampleTransformationMetadata();
        Assert.assertEquals((long)1L, (long)tm.getXMLSchemas((Object)tm.getGroupID("x1.doc")).size());
    }

    @Test
    public void testTypeCorrection() throws Exception {
        MetadataFactory mf = new MetadataFactory(null, 1, "x", SystemMetadata.getInstance().getBuiltinTypeMap(), new Properties(), null);
        mf.setBuiltinDataTypes(SystemMetadata.getInstance().getSystemStore().getDatatypes());
        Table t = mf.addTable("y");
        mf.addColumn("test", "string", (ColumnSet)t);
        MetadataFactory mf1 = (MetadataFactory)UnitTestUtil.helpSerialize((Serializable)mf);
        Column column = (Column)mf1.getSchema().getTable("y").getColumns().get(0);
        Datatype dt = column.getDatatype();
        Assert.assertNotSame(mf.getBuiltinDataTypes().get(dt.getName()), (Object)column.getDatatype());
        mf1.correctDatatypes(mf.getDataTypes(), mf.getBuiltinDataTypes());
        Assert.assertSame(mf.getBuiltinDataTypes().get(dt.getName()), (Object)column.getDatatype());
    }
}

