/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import junit.framework.TestCase;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.TestResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.proc.CreateProcedureCommand;
import org.teiid.query.sql.proc.TestBlock;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestCreateUpdateProcedureCommand
extends TestCase {
    public TestCreateUpdateProcedureCommand(String name) {
        super(name);
    }

    public static final CreateProcedureCommand sample1() {
        return new CreateProcedureCommand(TestBlock.sample1());
    }

    public static final CreateProcedureCommand sample2() {
        return new CreateProcedureCommand(TestBlock.sample2());
    }

    public static final CreateProcedureCommand sample3() {
        return new CreateProcedureCommand(TestBlock.sample1());
    }

    public void testGetBlock() {
        CreateProcedureCommand b1 = TestCreateUpdateProcedureCommand.sample1();
        TestCreateUpdateProcedureCommand.assertTrue((String)"Incorrect Block on command", (boolean)b1.getBlock().equals((Object)TestBlock.sample1()));
    }

    public void testSetBlock() {
        CreateProcedureCommand b1 = (CreateProcedureCommand)TestCreateUpdateProcedureCommand.sample1().clone();
        b1.setBlock(TestBlock.sample2());
        TestCreateUpdateProcedureCommand.assertTrue((String)"Incorrect Block on command", (boolean)b1.getBlock().equals((Object)TestBlock.sample2()));
    }

    public void testSelfEquivalence() {
        CreateProcedureCommand s1 = TestCreateUpdateProcedureCommand.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1);
    }

    public void testEquivalence() {
        CreateProcedureCommand s1 = TestCreateUpdateProcedureCommand.sample1();
        CreateProcedureCommand s1a = TestCreateUpdateProcedureCommand.sample1();
        int equals = 0;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s1a);
    }

    public void testNonEquivalence() {
        CreateProcedureCommand s1 = TestCreateUpdateProcedureCommand.sample1();
        CreateProcedureCommand s2 = TestCreateUpdateProcedureCommand.sample2();
        int equals = -1;
        UnitTestUtil.helpTestEquivalence((int)equals, (Object)s1, (Object)s2);
    }

    public void testCloneMethod3() {
        CreateProcedureCommand s1 = new CreateProcedureCommand();
        CreateProcedureCommand s2 = (CreateProcedureCommand)s1.clone();
        UnitTestUtil.helpTestEquivalence((int)0, (Object)s1, (Object)s2);
    }

    public void testProjectedSymbols() {
        CreateProcedureCommand cupc = new CreateProcedureCommand();
        StoredProcedure sp = (StoredProcedure)TestResolver.helpResolve("call TEIIDSP9(p1=>1, p2=>?)", (QueryMetadataInterface)RealMetadataFactory.exampleBQTCached());
        sp.setCallableStatement(true);
        cupc.setResultsCommand((Command)sp);
        TestCreateUpdateProcedureCommand.assertEquals((int)1, (int)cupc.getProjectedSymbols().size());
    }
}

