/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TupleBatch {
    private static final long serialVersionUID = 6304443387337336957L;
    private int rowOffset;
    protected List<List<?>> tuples;
    private boolean terminationFlag = false;

    public TupleBatch() {
    }

    public TupleBatch(int beginRow, List<?>[] tuples) {
        this.rowOffset = beginRow;
        this.tuples = Arrays.asList(tuples);
    }

    public TupleBatch(int beginRow, List listOfTupleLists) {
        this.rowOffset = beginRow;
        this.tuples = new ArrayList(listOfTupleLists);
    }

    public int getBeginRow() {
        return this.rowOffset;
    }

    public int getEndRow() {
        return this.rowOffset + this.tuples.size() - 1;
    }

    public int getRowCount() {
        return this.tuples.size();
    }

    public List getTuple(int rowIndex) {
        return this.tuples.get(rowIndex - this.rowOffset);
    }

    public List<List<?>> getTuples() {
        return this.tuples;
    }

    public List[] getAllTuples() {
        return this.tuples.toArray(new List[this.tuples.size()]);
    }

    public boolean getTerminationFlag() {
        return this.terminationFlag;
    }

    public void setTerminationFlag(boolean terminationFlag) {
        this.terminationFlag = terminationFlag;
    }

    public boolean containsRow(int row) {
        return this.rowOffset <= row && this.getEndRow() >= row;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("TupleBatch; beginning row=");
        s.append(this.rowOffset);
        s.append(", number of rows=");
        s.append(this.tuples.size());
        s.append(", lastBatch=");
        s.append(this.terminationFlag);
        return s.toString();
    }

    public void setRowOffset(int rowOffset) {
        this.rowOffset = rowOffset;
    }
}

