/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.teiid.client.BatchSerializer;
import org.teiid.client.ResizingArrayList;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.common.buffer.BatchManager;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.CacheEntry;
import org.teiid.common.buffer.CacheKey;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.LobManager;
import org.teiid.common.buffer.STree;
import org.teiid.common.buffer.Serializer;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.TupleBuffer;
import org.teiid.common.buffer.impl.LrfuEvictionQueue;
import org.teiid.common.buffer.impl.SizeUtility;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Streamable;
import org.teiid.dqp.internal.process.SerializableTupleBatch;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.ReplicatedObject;
import org.teiid.query.processor.relational.ListNestedSortComparator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public class BufferManagerImpl
implements BufferManager,
StorageManager,
ReplicatedObject<String> {
    private static final long BATCH_OVERHEAD = 128L;
    static final int CONCURRENCY_LEVEL = 32;
    private static final int TARGET_BYTES_PER_ROW = 2048;
    private static ReferenceQueue<CacheEntry> SOFT_QUEUE = new ReferenceQueue();
    private int connectorBatchSize = 512;
    private int processorBatchSize = 256;
    private int maxProcessingBytes = 0x200000;
    private Integer maxProcessingBytesOrig;
    AtomicLong maxReserveBytes = new AtomicLong(0x10000000L);
    AtomicLong reserveBatchBytes = new AtomicLong();
    private int maxActivePlans = 20;
    private boolean useWeakReferences = true;
    private boolean inlineLobs = true;
    private int targetBytesPerRow = 2048;
    private int maxSoftReferences;
    private ReentrantLock lock = new ReentrantLock(true);
    private Condition batchesFreed = this.lock.newCondition();
    AtomicLong activeBatchBytes = new AtomicLong();
    private AtomicLong readAttempts = new AtomicLong();
    LrfuEvictionQueue<CacheEntry> evictionQueue = new LrfuEvictionQueue(this.readAttempts);
    ConcurrentHashMap<Long, CacheEntry> memoryEntries = new ConcurrentHashMap(16, 0.75f, 32);
    private ThreadLocal<Integer> reservedByThread = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private DataTypeManager.WeakReferenceHashedValueCache<CacheEntry> weakReferenceCache;
    private Map<Long, BatchSoftReference> softCache = Collections.synchronizedMap(new LinkedHashMap<Long, BatchSoftReference>(16, 0.75f, false){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, BatchSoftReference> eldest) {
            if (this.size() > BufferManagerImpl.this.maxSoftReferences) {
                BatchSoftReference bsr = eldest.getValue();
                BufferManagerImpl.this.clearSoftReference(bsr);
                return true;
            }
            return false;
        }
    });
    private Cache cache;
    private Map<String, TupleReference> tupleBufferMap = new ConcurrentHashMap<String, TupleReference>();
    private ReferenceQueue<TupleBuffer> tupleBufferQueue = new ReferenceQueue();
    private AtomicLong tsId = new AtomicLong();
    private AtomicLong batchAdded = new AtomicLong();
    private AtomicLong readCount = new AtomicLong();
    private AtomicLong writeCount = new AtomicLong();
    private AtomicLong referenceHit = new AtomicLong();
    private static final Timer timer = new Timer("BufferManager Cleaner", true);
    AtomicInteger removed = new AtomicInteger();

    public BufferManagerImpl() {
        timer.schedule((TimerTask)new Cleaner(this), 15000L, 15000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearSoftReference(BatchSoftReference bsr) {
        BatchSoftReference batchSoftReference = bsr;
        synchronized (batchSoftReference) {
            this.maxReserveBytes.addAndGet(bsr.sizeEstimate);
            this.reserveBatchBytes.addAndGet(bsr.sizeEstimate);
            bsr.sizeEstimate = 0;
        }
        bsr.clear();
    }

    void removeFromCache(Long gid, Long batch) {
        if (this.cache.remove(gid, batch)) {
            this.maxReserveBytes.addAndGet(128L);
            this.reserveBatchBytes.addAndGet(128L);
        }
    }

    public long getBatchesAdded() {
        return this.batchAdded.get();
    }

    public long getReadCount() {
        return this.readCount.get();
    }

    public long getWriteCount() {
        return this.writeCount.get();
    }

    public long getReadAttempts() {
        return this.readAttempts.get();
    }

    @Override
    public int getMaxProcessingSize() {
        return this.maxProcessingBytes;
    }

    public long getReserveBatchBytes() {
        return this.reserveBatchBytes.get();
    }

    @Override
    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    @Override
    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public void setConnectorBatchSize(int connectorBatchSize) {
        this.connectorBatchSize = connectorBatchSize;
    }

    public void setTargetBytesPerRow(int targetBytesPerRow) {
        this.targetBytesPerRow = targetBytesPerRow;
    }

    public void setProcessorBatchSize(int processorBatchSize) {
        this.processorBatchSize = processorBatchSize;
    }

    @Override
    public TupleBuffer createTupleBuffer(List elements, String groupName, BufferManager.TupleSourceType tupleSourceType) {
        Long newID = this.tsId.getAndIncrement();
        int[] lobIndexes = LobManager.getLobIndexes(elements);
        Object[] types = BufferManagerImpl.getTypeClasses(elements);
        BatchManagerImpl batchManager = this.createBatchManager(newID, (Class<?>[])types);
        LobManager lobManager = null;
        FileStore lobStore = null;
        if (lobIndexes != null) {
            lobStore = this.createFileStore(newID + "_lobs");
            lobManager = new LobManager(lobIndexes, lobStore);
            batchManager.setLobManager(lobManager);
        }
        TupleBuffer tupleBuffer = new TupleBuffer(batchManager, String.valueOf(newID), elements, lobManager, this.getProcessorBatchSize(elements));
        if (lobStore != null) {
            AutoCleanupUtil.setCleanupReference(batchManager, lobStore);
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating TupleBuffer:", newID, elements, Arrays.toString(types), "of type", tupleSourceType});
        }
        tupleBuffer.setInlineLobs(this.inlineLobs);
        return tupleBuffer;
    }

    @Override
    public STree createSTree(List<? extends Expression> elements, String groupName, int keyLength) {
        Long newID = this.tsId.getAndIncrement();
        int[] lobIndexes = LobManager.getLobIndexes(elements);
        Class<?>[] types = BufferManagerImpl.getTypeClasses(elements);
        BatchManagerImpl bm = this.createBatchManager(newID, types);
        LobManager lobManager = null;
        if (lobIndexes != null) {
            lobManager = new LobManager(lobIndexes, null);
            bm.setLobManager(lobManager);
        }
        BatchManagerImpl keyManager = this.createBatchManager(this.tsId.getAndIncrement(), Arrays.copyOf(types, keyLength));
        int[] compareIndexes = new int[keyLength];
        for (int i = 1; i < compareIndexes.length; ++i) {
            compareIndexes[i] = i;
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating STree:", newID});
        }
        return new STree(keyManager, bm, new ListNestedSortComparator(compareIndexes), this.getProcessorBatchSize(elements.subList(0, keyLength)), this.getProcessorBatchSize(elements), keyLength, lobManager);
    }

    private static Class<?>[] getTypeClasses(List<? extends Expression> elements) {
        Class[] types = new Class[elements.size()];
        ListIterator<? extends Expression> i = elements.listIterator();
        while (i.hasNext()) {
            Expression expr = i.next();
            types[i.previousIndex()] = expr.getType();
        }
        return types;
    }

    private BatchManagerImpl createBatchManager(final Long newID, Class<?>[] types) {
        BatchManagerImpl bm = new BatchManagerImpl(newID, types);
        final AtomicBoolean prefersMemory = bm.prefersMemory;
        AutoCleanupUtil.setCleanupReference(bm, new AutoCleanupUtil.Removable(){

            @Override
            public void remove() {
                BufferManagerImpl.this.removeCacheGroup(newID, prefersMemory.get());
            }
        });
        return bm;
    }

    @Override
    public FileStore createFileStore(String name) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Creating FileStore:", name});
        }
        return this.cache.createFileStore(name);
    }

    public Cache getCache() {
        return this.cache;
    }

    @Override
    public void setMaxActivePlans(int maxActivePlans) {
        this.maxActivePlans = maxActivePlans;
    }

    public void setMaxProcessingKB(int maxProcessingKB) {
        this.maxProcessingBytes = maxProcessingKB > -1 ? maxProcessingKB << 10 : -1;
    }

    public void setMaxReserveKB(int maxReserveBatchKB) {
        if (maxReserveBatchKB > -1) {
            int maxReserve = maxReserveBatchKB << 10;
            this.maxReserveBytes.set(maxReserve);
            this.reserveBatchBytes.set(maxReserve);
        } else {
            this.maxReserveBytes.set(-1L);
        }
    }

    @Override
    public void initialize() throws TeiidComponentException {
        long maxMemory = Runtime.getRuntime().maxMemory();
        maxMemory = Math.max(0L, maxMemory - 314572800L);
        if (this.getMaxReserveKB() < 0) {
            this.maxReserveBytes.set(0L);
            int one_gig = 0x40000000;
            if (maxMemory > (long)one_gig) {
                this.maxReserveBytes.addAndGet((long)Math.max(0.0, (double)(maxMemory - (long)one_gig) * 0.75));
            }
            this.maxReserveBytes.addAndGet(Math.max(0L, Math.min((long)one_gig, maxMemory) >> 1));
        }
        this.reserveBatchBytes.set(this.maxReserveBytes.get());
        if (this.maxProcessingBytesOrig == null) {
            this.maxProcessingBytesOrig = this.maxProcessingBytes;
        }
        if (this.maxProcessingBytesOrig < 0) {
            this.maxProcessingBytes = (int)Math.min(Math.max((double)((long)(this.processorBatchSize * this.targetBytesPerRow) * 8L), 0.1 * (double)maxMemory / (double)this.maxActivePlans), 2.147483647E9);
        }
        long memoryBatches = maxMemory / (long)(this.processorBatchSize * this.targetBytesPerRow);
        int logSize = 67 - Long.numberOfLeadingZeros(memoryBatches);
        if (this.useWeakReferences) {
            this.weakReferenceCache = new DataTypeManager.WeakReferenceHashedValueCache(Math.min(30, logSize));
        }
        this.maxSoftReferences = 1 << Math.min(30, logSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseBuffers(int count) {
        if (count < 1) {
            return;
        }
        this.reservedByThread.set(this.reservedByThread.get() - count);
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Releasing buffer space", count});
        }
        this.lock.lock();
        try {
            this.reserveBatchBytes.addAndGet(count);
            this.batchesFreed.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int reserveAdditionalBuffers(int additional) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Reserving buffer space", additional, "WAIT"});
        }
        this.lock.lock();
        try {
            int committed;
            int result;
            int waitCount = Math.min(additional, this.getMaxReserveKB() - this.reservedByThread.get());
            for (committed = 0; waitCount > 0 && (long)waitCount > this.reserveBatchBytes.get() && committed < additional; committed += result) {
                long reserveBatchSample = this.reserveBatchBytes.get();
                try {
                    this.batchesFreed.await(100L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30053, (Throwable)e);
                }
                waitCount = reserveBatchSample >= this.reserveBatchBytes.get() ? (waitCount >>= 3) : (waitCount >>= 1);
                result = this.noWaitReserve(additional - committed, false);
            }
            int n = committed;
            return n;
        }
        finally {
            this.lock.unlock();
            this.persistBatchReferences();
        }
    }

    @Override
    public int reserveBuffers(int count, BufferManager.BufferReserveMode mode) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Reserving buffer space", count, mode});
        }
        int result = count;
        if (mode == BufferManager.BufferReserveMode.FORCE) {
            this.reserveBatchBytes.addAndGet(-count);
        } else {
            result = this.noWaitReserve(count, true);
        }
        this.reservedByThread.set(this.reservedByThread.get() + result);
        this.persistBatchReferences();
        return result;
    }

    private int noWaitReserve(int count, boolean allOrNothing) {
        for (int i = 0; i < 2; ++i) {
            long reserveBatch = this.reserveBatchBytes.get();
            if (allOrNothing && (long)count > reserveBatch) {
                return 0;
            }
            if ((count = (int)Math.min((long)count, Math.max(0L, reserveBatch))) == 0) {
                return 0;
            }
            if (!this.reserveBatchBytes.compareAndSet(reserveBatch, reserveBatch - (long)count)) continue;
            return count;
        }
        this.reserveBatchBytes.addAndGet(-count);
        return count;
    }

    void persistBatchReferences() {
        long reserveBatch;
        long activeBatch = this.activeBatchBytes.get();
        if (activeBatch <= (reserveBatch = this.reserveBatchBytes.get())) {
            long memoryCount = activeBatch + (long)this.getMaxReserveKB() - reserveBatch;
            if (DataTypeManager.isValueCacheEnabled()) {
                if (memoryCount < (long)(this.getMaxReserveKB() / 8)) {
                    DataTypeManager.setValueCacheEnabled((boolean)false);
                }
            } else if (memoryCount > (long)(this.getMaxReserveKB() / 2)) {
                DataTypeManager.setValueCacheEnabled((boolean)true);
            }
            return;
        }
        long maxToFree = Math.max((long)(this.maxProcessingBytes >> 1), reserveBatch >> 3);
        this.doEvictions(maxToFree, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doEvictions(long maxToFree, boolean checkActiveBatch) {
        CacheEntry ce;
        int freed = 0;
        while ((long)freed <= maxToFree && (!checkActiveBatch || (double)this.activeBatchBytes.get() > (double)this.reserveBatchBytes.get() * 0.8) && (ce = this.evictionQueue.firstEntry(true)) != null) {
            CacheEntry cacheEntry = ce;
            synchronized (cacheEntry) {
                if (!this.memoryEntries.containsKey(ce.getId())) {
                    continue;
                }
            }
            boolean evicted = true;
            try {
                evicted = this.evict(ce);
            }
            catch (Throwable e) {
                LogManager.logError((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30017, new Object[]{ce.getId()}));
            }
            finally {
                CacheEntry cacheEntry2 = ce;
                synchronized (cacheEntry2) {
                    if (evicted && this.memoryEntries.remove(ce.getId()) != null) {
                        freed += ce.getSizeEstimate();
                        this.activeBatchBytes.addAndGet(-ce.getSizeEstimate());
                        this.evictionQueue.remove(ce);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean evict(CacheEntry ce) throws Exception {
        Serializer<?> s = ce.getSerializer();
        if (s == null) {
            return true;
        }
        boolean persist = false;
        CacheEntry cacheEntry = ce;
        synchronized (cacheEntry) {
            if (!ce.isPersistent()) {
                persist = true;
                ce.setPersistent(true);
            }
        }
        if (persist) {
            long count = this.writeCount.incrementAndGet();
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{ce.getId(), "writing batch to storage, total writes: ", count});
            }
        }
        boolean result = this.cache.add(ce, s);
        if (s.useSoftCache()) {
            this.createSoftReference(ce);
        } else if (this.useWeakReferences) {
            this.weakReferenceCache.getValue((Object)ce);
        }
        return result;
    }

    private void createSoftReference(CacheEntry ce) {
        int sizeEstimate = ce.getSizeEstimate() / 2;
        BatchSoftReference ref = new BatchSoftReference(ce, SOFT_QUEUE, sizeEstimate);
        this.softCache.put(ce.getId(), ref);
        this.maxReserveBytes.addAndGet(-sizeEstimate);
        this.reserveBatchBytes.addAndGet(-sizeEstimate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheEntry fastGet(Long batch, boolean prefersMemory, boolean retain) {
        CacheEntry ce = null;
        ce = retain ? this.memoryEntries.get(batch) : this.memoryEntries.remove(batch);
        if (ce != null) {
            CacheEntry cacheEntry = ce;
            synchronized (cacheEntry) {
                if (retain) {
                    if (this.memoryEntries.containsKey(batch)) {
                        this.evictionQueue.touch(ce);
                    }
                } else {
                    this.evictionQueue.remove(ce);
                }
            }
            if (!retain) {
                this.remove(ce, true);
            }
            return ce;
        }
        if (prefersMemory) {
            BatchSoftReference bsr = this.softCache.remove(batch);
            if (bsr != null && (ce = (CacheEntry)bsr.get()) != null) {
                this.clearSoftReference(bsr);
            }
        } else if (this.useWeakReferences && ((ce = (CacheEntry)this.weakReferenceCache.getByHash((Object)batch)) == null || !ce.getId().equals(batch))) {
            return null;
        }
        if (ce != null && ce.getObject() != null) {
            this.referenceHit.getAndIncrement();
            if (retain) {
                this.addMemoryEntry(ce, false);
            } else {
                this.remove(ce, false);
            }
            return ce;
        }
        return null;
    }

    CacheEntry remove(Long gid, Long batch, boolean prefersMemory) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
            LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Removing batch from BufferManager", batch});
        }
        this.cleanSoftReferences();
        CacheEntry ce = this.fastGet(batch, prefersMemory, false);
        if (ce == null) {
            this.removeFromCache(gid, batch);
        } else {
            ce.nullOut();
        }
        return ce;
    }

    private void remove(CacheEntry ce, boolean inMemory) {
        Serializer<?> s;
        if (inMemory) {
            this.activeBatchBytes.addAndGet(-ce.getSizeEstimate());
        }
        if ((s = ce.getSerializer()) != null) {
            this.removeFromCache(s.getId(), ce.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMemoryEntry(CacheEntry ce, boolean initial) {
        this.persistBatchReferences();
        CacheEntry cacheEntry = ce;
        synchronized (cacheEntry) {
            boolean added;
            boolean bl = added = this.memoryEntries.put(ce.getId(), ce) == null;
            if (initial) {
                this.evictionQueue.add(ce);
            } else if (added) {
                this.evictionQueue.recordAccess(ce);
                this.evictionQueue.add(ce);
            } else {
                this.evictionQueue.touch(ce);
            }
        }
        this.activeBatchBytes.getAndAdd(ce.getSizeEstimate());
    }

    void removeCacheGroup(Long id, boolean prefersMemory) {
        this.cleanSoftReferences();
        Collection<Long> vals = this.cache.removeCacheGroup(id);
        long overhead = (long)vals.size() * 128L;
        this.maxReserveBytes.addAndGet(overhead);
        this.reserveBatchBytes.addAndGet(overhead);
        for (Long val : vals) {
            this.fastGet(val, prefersMemory, false);
        }
    }

    void cleanSoftReferences() {
        BatchSoftReference ref;
        for (int i = 0; i < 10 && (ref = (BatchSoftReference)SOFT_QUEUE.poll()) != null; ++i) {
            this.softCache.remove(ref.key);
            this.clearSoftReference(ref);
        }
    }

    @Override
    public int getProcessorBatchSize(List<? extends Expression> schema) {
        return this.getSizeEstimates(schema)[0];
    }

    private int[] getSizeEstimates(List<? extends Expression> elements) {
        int total = 0;
        boolean isValueCacheEnabled = DataTypeManager.isValueCacheEnabled();
        for (Expression expression : elements) {
            Class<?> type = expression.getType();
            total += SizeUtility.getSize(isValueCacheEnabled, type);
        }
        int totalCopy = total += 8 * elements.size() + 36;
        boolean bl = totalCopy < this.targetBytesPerRow;
        int rowCount = this.processorBatchSize;
        for (int i = 0; i < 3; ++i) {
            totalCopy = bl ? (totalCopy <<= 1) : (totalCopy >>= 2);
            if (bl && totalCopy > this.targetBytesPerRow || !bl && totalCopy < this.targetBytesPerRow) break;
            if (bl) {
                rowCount <<= 1;
                continue;
            }
            rowCount >>= 1;
        }
        rowCount = Math.max(1, rowCount);
        return new int[]{rowCount, Math.max(1, total *= rowCount)};
    }

    @Override
    public int getSchemaSize(List<? extends Expression> elements) {
        return this.getSizeEstimates(elements)[1];
    }

    public void shutdown() {
    }

    @Override
    public void addTupleBuffer(TupleBuffer tb) {
        this.cleanDefunctTupleBuffers();
        this.tupleBufferMap.put(tb.getId(), new TupleReference(tb, this.tupleBufferQueue));
    }

    @Override
    public void distributeTupleBuffer(String uuid, TupleBuffer tb) {
        tb.setId(uuid);
        this.addTupleBuffer(tb);
    }

    @Override
    public TupleBuffer getTupleBuffer(String id) {
        this.cleanDefunctTupleBuffers();
        Reference r = this.tupleBufferMap.get(id);
        if (r != null) {
            return (TupleBuffer)r.get();
        }
        return null;
    }

    private void cleanDefunctTupleBuffers() {
        Reference<TupleBuffer> r;
        while ((r = this.tupleBufferQueue.poll()) != null) {
            this.tupleBufferMap.remove(((TupleReference)r).id);
        }
    }

    public void setUseWeakReferences(boolean useWeakReferences) {
        this.useWeakReferences = useWeakReferences;
    }

    @Override
    public void getState(OutputStream ostream) {
    }

    @Override
    public void getState(String state_id, OutputStream ostream) {
        TupleBuffer buffer = this.getTupleBuffer(state_id);
        if (buffer != null) {
            try {
                ObjectOutputStream out = new ObjectOutputStream(ostream);
                this.getTupleBufferState(out, buffer);
            }
            catch (TeiidComponentException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30054, (Throwable)e);
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30055, (Throwable)e);
            }
        }
    }

    private void getTupleBufferState(ObjectOutputStream out, TupleBuffer buffer) throws TeiidComponentException, IOException {
        out.writeInt(buffer.getRowCount());
        out.writeInt(buffer.getBatchSize());
        out.writeObject(buffer.getTypes());
        for (int row = 1; row <= buffer.getRowCount(); row += buffer.getBatchSize()) {
            TupleBatch b = buffer.getBatch(row);
            out.writeObject(new SerializableTupleBatch(b, buffer.getTypes()));
        }
    }

    @Override
    public void setState(InputStream istream) {
    }

    @Override
    public void setState(String state_id, InputStream istream) {
        TupleBuffer buffer = this.getTupleBuffer(state_id);
        if (buffer == null) {
            try {
                ObjectInputStream in = new ObjectInputStream(istream);
                this.setTupleBufferState(state_id, in);
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30056, (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30057, (Throwable)e);
            }
            catch (TeiidComponentException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30058, (Throwable)e);
            }
        }
    }

    private void setTupleBufferState(String state_id, ObjectInputStream in) throws IOException, ClassNotFoundException, TeiidComponentException {
        int rowCount = in.readInt();
        int batchSize = in.readInt();
        String[] types = (String[])in.readObject();
        ArrayList<ElementSymbol> schema = new ArrayList<ElementSymbol>(types.length);
        for (String type : types) {
            ElementSymbol es = new ElementSymbol("x");
            es.setType(DataTypeManager.getDataTypeClass((String)type));
            schema.add(es);
        }
        TupleBuffer buffer = this.createTupleBuffer(schema, "cached", BufferManager.TupleSourceType.FINAL);
        buffer.setBatchSize(batchSize);
        buffer.setId(state_id);
        for (int row = 1; row <= rowCount; row += batchSize) {
            TupleBatch batch = (TupleBatch)in.readObject();
            if (batch == null) {
                buffer.remove();
                throw new IOException(QueryPlugin.Util.getString("not_found_cache"));
            }
            buffer.addTupleBatch(batch, true);
        }
        buffer.close();
        this.addTupleBuffer(buffer);
    }

    @Override
    public void setAddress(Serializable address) {
    }

    @Override
    public void droppedMembers(Collection<Serializable> addresses) {
    }

    public void setInlineLobs(boolean inlineLobs) {
        this.inlineLobs = inlineLobs;
    }

    public int getMaxReserveKB() {
        return (int)this.maxReserveBytes.get() >> 10;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public int getMemoryCacheEntries() {
        return this.memoryEntries.size();
    }

    @Override
    public boolean hasState(String stateId) {
        return this.getTupleBuffer(stateId) != null;
    }

    @Override
    public Streamable<?> persistLob(Streamable<?> lob, FileStore store, byte[] bytes) throws TeiidComponentException {
        return LobManager.persistLob(lob, store, bytes, this.inlineLobs, 8192);
    }

    static class TupleReference
    extends WeakReference<TupleBuffer> {
        String id;

        public TupleReference(TupleBuffer referent, ReferenceQueue<? super TupleBuffer> q) {
            super(referent, q);
            this.id = referent.getId();
        }
    }

    private static class BatchSoftReference
    extends SoftReference<CacheEntry> {
        private int sizeEstimate;
        private Long key;

        public BatchSoftReference(CacheEntry referent, ReferenceQueue<? super CacheEntry> q, int sizeEstimate) {
            super(referent, q);
            this.sizeEstimate = sizeEstimate;
            this.key = referent.getId();
        }
    }

    final class BatchManagerImpl
    implements BatchManager,
    Serializer<List<? extends List<?>>> {
        final Long id;
        SizeUtility sizeUtility;
        private WeakReference<BatchManagerImpl> ref = new WeakReference<BatchManagerImpl>(this);
        AtomicBoolean prefersMemory = new AtomicBoolean();
        String[] types;
        private LobManager lobManager;

        private BatchManagerImpl(Long newID, Class<?>[] types) {
            this.id = newID;
            this.sizeUtility = new SizeUtility(types);
            this.types = new String[types.length];
            for (int i = 0; i < types.length; ++i) {
                this.types[i] = DataTypeManager.getDataTypeName(types[i]);
            }
            BufferManagerImpl.this.cache.createCacheGroup(newID);
        }

        @Override
        public Long getId() {
            return this.id;
        }

        public void setLobManager(LobManager lobManager) {
            this.lobManager = lobManager;
        }

        @Override
        public String[] getTypes() {
            return this.types;
        }

        @Override
        public boolean prefersMemory() {
            return this.prefersMemory.get();
        }

        @Override
        public void setPrefersMemory(boolean prefers) {
            this.prefersMemory.set(prefers);
        }

        @Override
        public boolean useSoftCache() {
            return this.prefersMemory.get();
        }

        @Override
        public Reference<? extends BatchManager> getBatchManagerReference() {
            return this.ref;
        }

        @Override
        public Long createManagedBatch(List<? extends List<?>> batch, Long previous, boolean removeOld) throws TeiidComponentException {
            int sizeEstimate = this.getSizeEstimate(batch);
            Long oid = BufferManagerImpl.this.batchAdded.getAndIncrement();
            CacheEntry old = null;
            if (previous != null) {
                old = removeOld ? BufferManagerImpl.this.remove(this.id, previous, this.prefersMemory.get()) : BufferManagerImpl.this.fastGet(previous, this.prefersMemory.get(), true);
            }
            CacheKey key = new CacheKey(oid, (int)BufferManagerImpl.this.readAttempts.get(), old != null ? old.getKey().getOrderingValue() : 0L);
            CacheEntry ce = new CacheEntry(key, sizeEstimate, batch, this.ref, false);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Add batch to BufferManager", ce.getId(), "with size estimate", ce.getSizeEstimate()});
            }
            BufferManagerImpl.this.maxReserveBytes.addAndGet(-128L);
            BufferManagerImpl.this.reserveBatchBytes.addAndGet(-128L);
            BufferManagerImpl.this.cache.addToCacheGroup(this.id, ce.getId());
            BufferManagerImpl.this.addMemoryEntry(ce, true);
            return oid;
        }

        @Override
        public List<? extends List<?>> deserialize(ObjectInput ois) throws IOException, ClassNotFoundException {
            List batch = BatchSerializer.readBatch((ObjectInput)ois, (String[])this.types);
            if (this.lobManager != null) {
                for (List list : batch) {
                    try {
                        this.lobManager.updateReferences(list, LobManager.ReferenceMode.ATTACH);
                    }
                    catch (TeiidComponentException e) {
                        throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30052, (Throwable)e);
                    }
                }
            }
            return batch;
        }

        @Override
        public void serialize(List<? extends List<?>> obj, ObjectOutput oos) throws IOException {
            block3: {
                int expectedModCount = 0;
                ResizingArrayList list = null;
                if (obj instanceof ResizingArrayList) {
                    list = (ResizingArrayList)obj;
                }
                try {
                    BatchSerializer.writeBatch((ObjectOutput)oos, (String[])this.types, obj);
                }
                catch (RuntimeException e) {
                    if (list != null && list.getModCount() != expectedModCount) break block3;
                    throw e;
                }
            }
        }

        public int getSizeEstimate(List<? extends List<?>> obj) {
            return (int)Math.max(1L, this.sizeUtility.getBatchSize(DataTypeManager.isValueCacheEnabled(), obj));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<List<?>> getBatch(Long batch, boolean retain) throws TeiidComponentException {
            CacheEntry ce;
            BufferManagerImpl.this.cleanSoftReferences();
            long reads = BufferManagerImpl.this.readAttempts.incrementAndGet();
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, "getting batch", batch, "total reads", reads, "reference hits", BufferManagerImpl.this.referenceHit.get()});
            }
            if ((ce = BufferManagerImpl.this.fastGet(batch, this.prefersMemory.get(), retain)) != null) {
                return (List)(!retain ? ce.nullOut() : ce.getObject());
            }
            Object o = BufferManagerImpl.this.cache.lockForLoad(batch, this);
            try {
                ce = BufferManagerImpl.this.fastGet(batch, this.prefersMemory.get(), retain);
                if (ce != null) {
                    List list = (List)(!retain ? ce.nullOut() : ce.getObject());
                    return list;
                }
                long count = BufferManagerImpl.this.readCount.incrementAndGet();
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{this.id, "reading batch", batch, "from storage, total reads:", count});
                }
                if ((ce = BufferManagerImpl.this.cache.get(o, batch, this.ref)) == null) {
                    throw new AssertionError((Object)("Batch not found in storage " + batch));
                }
                if (!retain) {
                    BufferManagerImpl.this.removeFromCache(this.id, batch);
                } else {
                    BufferManagerImpl.this.addMemoryEntry(ce, false);
                }
            }
            finally {
                BufferManagerImpl.this.cache.unlockForLoad(o);
            }
            return (List)ce.getObject();
        }

        @Override
        public void remove(Long batch) {
            BufferManagerImpl.this.remove(this.id, batch, this.prefersMemory.get());
        }

        @Override
        public void remove() {
            BufferManagerImpl.this.removeCacheGroup(this.id, this.prefersMemory.get());
        }

        public String toString() {
            return this.id.toString();
        }
    }

    private static final class Cleaner
    extends TimerTask {
        private static final int MAX_READ_AGE = 0x10000000;
        WeakReference<BufferManagerImpl> bufferRef;

        public Cleaner(BufferManagerImpl bufferManagerImpl) {
            this.bufferRef = new WeakReference<BufferManagerImpl>(bufferManagerImpl);
        }

        @Override
        public void run() {
            while (true) {
                BufferManagerImpl impl;
                if ((impl = (BufferManagerImpl)this.bufferRef.get()) == null) {
                    this.cancel();
                    return;
                }
                boolean agingOut = false;
                if ((double)impl.reserveBatchBytes.get() < (double)impl.maxReserveBytes.get() * 0.9 || (double)impl.activeBatchBytes.get() < (double)impl.maxReserveBytes.get() * 0.7) {
                    CacheEntry entry = impl.evictionQueue.firstEntry(false);
                    if (entry == null) {
                        return;
                    }
                    long lastAccess = entry.getKey().getLastAccess();
                    long currentTime = impl.readAttempts.get();
                    if (currentTime - lastAccess < 0x10000000L) {
                        return;
                    }
                    agingOut = true;
                }
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Asynch eviction run", impl.reserveBatchBytes.get(), impl.maxReserveBytes.get(), impl.activeBatchBytes.get()});
                }
                impl.doEvictions(0L, false);
                if (agingOut) continue;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30051, (Throwable)e);
                }
            }
        }
    }
}

