/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.proc;

import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.proc.ProcedurePlan;
import org.teiid.query.processor.proc.ProgramInstruction;
import org.teiid.query.sql.symbol.ElementSymbol;

public class CreateCursorResultSetInstruction
extends ProgramInstruction {
    public static final String RS_NAME = "EXECSQL_INSTRUCTION";
    protected String rsName;
    protected ProcessorPlan plan;
    private boolean update;
    private Map<ElementSymbol, ElementSymbol> procAssignments;

    public CreateCursorResultSetInstruction(String rsName, ProcessorPlan plan, boolean update) {
        this.rsName = rsName;
        this.plan = plan;
        this.update = update;
    }

    public void setProcAssignments(Map<ElementSymbol, ElementSymbol> procAssignments) {
        this.procAssignments = procAssignments;
    }

    @Override
    public void process(ProcedurePlan procEnv) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (procEnv.resultSetExists(this.rsName)) {
            procEnv.removeResults(this.rsName);
        }
        procEnv.executePlan(this.plan, this.rsName, this.procAssignments, !this.update);
        if (this.update) {
            boolean hasNext = procEnv.iterateCursor(this.rsName);
            if (hasNext) {
                procEnv.getCurrentVariableContext().setValue(ProcedurePlan.ROWCOUNT, procEnv.getCurrentRow(this.rsName).get(0));
            } else {
                procEnv.getCurrentVariableContext().setValue(ProcedurePlan.ROWCOUNT, 0);
            }
            procEnv.removeResults(this.rsName);
        }
    }

    @Override
    public CreateCursorResultSetInstruction clone() {
        ProcessorPlan clonedPlan = this.plan.clone();
        CreateCursorResultSetInstruction clone = new CreateCursorResultSetInstruction(this.rsName, clonedPlan, this.update);
        clone.setProcAssignments(this.procAssignments);
        return clone;
    }

    public String toString() {
        return "CREATE CURSOR RESULTSET INSTRUCTION - " + this.rsName;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = new PlanNode("CREATE CURSOR");
        props.addProperty("Result Set", this.rsName);
        props.addProperty("Query", this.plan.getDescriptionProperties());
        return props;
    }

    public ProcessorPlan getCommand() {
        return this.plan;
    }

    @Override
    public void getChildPlans(List<ProcessorPlan> plans) {
        plans.add(this.plan);
    }
}

