/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.List;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentProcedureCriteriaProcessor;
import org.teiid.query.processor.relational.DependentProcedureExecutionNode;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.util.VariableContext;
import org.teiid.query.util.CommandContext;

public class DependentProcedureAccessNode
extends AccessNode {
    private Criteria inputCriteria;
    private List inputReferences;
    private List inputDefaults;
    private DependentProcedureCriteriaProcessor criteriaProcessor;

    public DependentProcedureAccessNode(int nodeID, Criteria crit, List references, List defaults) {
        super(nodeID);
        this.inputCriteria = crit;
        this.inputDefaults = defaults;
        this.inputReferences = references;
    }

    @Override
    public Object clone() {
        DependentProcedureAccessNode copy = new DependentProcedureAccessNode(this.getID(), this.inputCriteria, this.inputReferences, this.inputDefaults);
        this.copyTo(copy);
        return copy;
    }

    @Override
    public void reset() {
        super.reset();
        this.criteriaProcessor = null;
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        if (this.criteriaProcessor != null) {
            this.criteriaProcessor.close();
        }
    }

    @Override
    public void open() throws TeiidComponentException, TeiidProcessingException {
        CommandContext context = this.getContext().clone();
        context.pushVariableContext(new VariableContext());
        this.setContext(context);
        DependentProcedureExecutionNode.shareVariableContext(this, context);
        super.open();
    }

    @Override
    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        if (this.criteriaProcessor == null) {
            this.criteriaProcessor = new DependentProcedureCriteriaProcessor(this, (Criteria)this.inputCriteria.clone(), this.inputReferences, this.inputDefaults);
        }
        if (this.criteriaProcessor.prepareNextCommand(this.getContext().getVariableContext())) {
            return super.prepareNextCommand(atomicCommand);
        }
        return false;
    }

    @Override
    protected boolean processCommandsIndividually() {
        return true;
    }

    @Override
    protected boolean hasNextCommand() {
        return this.criteriaProcessor.hasNextCommand();
    }

    public Criteria getInputCriteria() {
        return this.inputCriteria;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        return true;
    }
}

