/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.arquillian;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.postgresql.Driver;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminFactory;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.arquillian.AdminUtil;
import org.teiid.arquillian.SampleExecutionFactory;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;

@RunWith(value=Arquillian.class)
public class IntegrationTestDeployment {
    private Admin admin;

    @Before
    public void setup() throws Exception {
        this.admin = AdminFactory.getInstance().createAdmin("localhost", 9999, "admin", "admin".toCharArray());
    }

    @After
    public void teardown() throws AdminException {
        AdminUtil.cleanUp(this.admin);
        this.admin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChainedDelegates() throws Exception {
        Properties props = new Properties();
        props.setProperty("connection-url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        props.setProperty("user-name", "sa");
        props.setProperty("password", "sa");
        AdminUtil.createDataSource(this.admin, "Oracle11_PushDS", "h2", props);
        this.admin.deploy("fake.jar", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"fake.jar")));
        try {
            this.admin.deploy("chained-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"chained-vdb.xml")));
        }
        finally {
            this.admin.undeploy("fake.jar");
        }
    }

    @Test
    public void testVDBDeployment() throws Exception {
        Collection vdbs = this.admin.getVDBs();
        Assert.assertTrue((boolean)vdbs.isEmpty());
        Collection dsNames = this.admin.getDataSourceNames();
        if (dsNames.contains("Oracle11_PushDS")) {
            this.admin.deleteDataSource("Oracle11_PushDS");
        }
        this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
        vdbs = this.admin.getVDBs();
        Assert.assertFalse((boolean)vdbs.isEmpty());
        VDB vdb = this.admin.getVDB("bqt", 1);
        Assert.assertFalse((boolean)vdb.isValid());
        Assert.assertTrue((boolean)AdminUtil.waitForVDBLoad(this.admin, "bqt", 1, 3));
        Assert.assertFalse((boolean)vdb.isValid());
        Properties props = new Properties();
        props.setProperty("connection-url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        props.setProperty("user-name", "sa");
        props.setProperty("password", "sa");
        props.setProperty("connection-properties", "foo=bar,blah=blah");
        this.admin.createDataSource("Oracle11_PushDS", "h2", props);
        vdb = this.admin.getVDB("bqt", 1);
        Assert.assertTrue((boolean)vdb.isValid());
        Assert.assertTrue((boolean)vdb.getStatus().equals((Object)VDB.Status.ACTIVE));
        dsNames = this.admin.getDataSourceNames();
        Assert.assertTrue((boolean)dsNames.contains("Oracle11_PushDS"));
        this.admin.deleteDataSource("Oracle11_PushDS");
        vdb = this.admin.getVDB("bqt", 1);
        Assert.assertFalse((boolean)vdb.isValid());
        this.admin.deploy("bqt.2.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
        vdb = this.admin.getVDB("bqt", 2);
        Assert.assertEquals((long)2L, (long)vdb.getVersion());
    }

    @Test
    public void testGetDatasourceProperties() throws Exception {
        String jdbcSource = "jdbc-source";
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(jdbcSource));
        Properties props = new Properties();
        props.setProperty("connection-url", "jdbc:h2:mem:test;DB_CLOSE_DELAY=-1");
        props.setProperty("user-name", "sa");
        props.setProperty("password", "sa");
        props.setProperty("connection-properties", "foo=bar,blah=blah");
        props.setProperty("max-pool-size", "4");
        this.admin.createDataSource(jdbcSource, "h2", props);
        Assert.assertTrue((boolean)this.admin.getDataSourceNames().contains(jdbcSource));
        Properties p = this.admin.getDataSource(jdbcSource);
        Assert.assertEquals((Object)"4", (Object)p.getProperty("max-pool-size"));
        Assert.assertEquals((Object)"jdbc:h2:mem:test;DB_CLOSE_DELAY=-1", (Object)p.getProperty("connection-url"));
        Assert.assertEquals((Object)"h2", (Object)p.getProperty("driver-name"));
        this.admin.deleteDataSource("jdbc-source");
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(jdbcSource));
        Assert.assertTrue((boolean)this.admin.getDataSourceTemplateNames().contains("webservice"));
        String raSource = "ra-source";
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(raSource));
        p = new Properties();
        p.setProperty("class-name", "org.teiid.resource.adapter.ws.WSManagedConnectionFactory");
        p.setProperty("EndPoint", "{endpoint}");
        this.admin.createDataSource(raSource, "webservice", p);
        Assert.assertTrue((boolean)this.admin.getDataSourceNames().contains(raSource));
        p = this.admin.getDataSource(raSource);
        Assert.assertEquals((Object)"org.teiid.resource.adapter.ws.WSManagedConnectionFactory", (Object)p.getProperty("class-name"));
        Assert.assertEquals((Object)"{endpoint}", (Object)p.getProperty("EndPoint"));
        Assert.assertEquals((Object)"webservice", (Object)p.getProperty("driver-name"));
        this.admin.deleteDataSource(raSource);
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(raSource));
        Assert.assertTrue((boolean)this.admin.getDataSourceTemplateNames().contains("webservice"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTraslators() throws Exception {
        VDBTranslatorMetaData t;
        Collection translators = this.admin.getTranslators();
        Assert.assertEquals((String)translators.toString(), (long)42L, (long)translators.size());
        JavaArchive jar = this.getLoopyArchive();
        try {
            this.admin.deploy("loopy.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
            t = (VDBTranslatorMetaData)this.admin.getTranslator("loopy");
            Assert.assertNotNull((Object)t);
            Assert.assertEquals((Object)"ANY", (Object)t.getPropertyValue("SupportedJoinCriteria"));
            Assert.assertEquals((Object)"true", (Object)t.getPropertyValue("supportsSelectDistinct"));
        }
        finally {
            this.admin.undeploy("loopy.jar");
        }
        t = (VDBTranslatorMetaData)this.admin.getTranslator("orcl");
        Assert.assertNull((Object)t);
    }

    @Test
    public void testTraslatorProperties() throws Exception {
        Collection props = this.admin.getTranslatorPropertyDefinitions("accumulo", Admin.TranlatorPropertyType.OVERRIDE);
        Assert.assertEquals((long)19L, (long)props.size());
        props = this.admin.getTranslatorPropertyDefinitions("accumulo", Admin.TranlatorPropertyType.EXTENSION_METADATA);
        Assert.assertEquals((long)3L, (long)props.size());
        for (PropertyDefinition p : props) {
            if (!p.getName().equals("{http://www.teiid.org/translator/accumulo/2013}CF")) continue;
            Assert.assertEquals((Object)"org.teiid.metadata.Column", (Object)p.getPropertyValue("owner"));
        }
        props = this.admin.getTranslatorPropertyDefinitions("accumulo", Admin.TranlatorPropertyType.IMPORT);
        Assert.assertEquals((long)2L, (long)props.size());
        for (PropertyDefinition p : props) {
            if (!p.getName().equals("importer.ColumnNamePattern")) continue;
            Assert.assertEquals((Object)"java.lang.String", (Object)p.getPropertyTypeClassName());
        }
    }

    private JavaArchive getLoopyArchive() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"loopy.jar")).addClasses(new Class[]{SampleExecutionFactory.class})).addAsManifestResource((Asset)new ByteArrayAsset(SampleExecutionFactory.class.getName().getBytes()), ArchivePaths.create((String)"services/org.teiid.translator.ExecutionFactory"));
        jar.addAsManifestResource((Asset)new ByteArrayAsset("Dependencies: org.jboss.teiid.translator.loopback\n".getBytes()), ArchivePaths.create((String)"MANIFEST.MF"));
        return jar;
    }

    @Test
    public void testVDBConnectionType() throws Exception {
        this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
        AdminUtil.waitForVDBLoad(this.admin, "bqt2", 1, 3);
        VDB vdb = this.admin.getVDB("bqt", 1);
        Model model = (Model)vdb.getModels().get(0);
        this.admin.updateSource("bqt", 1, "Source", "h2", "java:jboss/datasources/ExampleDS");
        try {
            this.admin.removeSource("bqt", 1, model.getName(), "Source");
            Assert.fail();
        }
        catch (AdminException e) {
            // empty catch block
        }
        Assert.assertEquals((Object)VDB.ConnectionType.BY_VERSION, (Object)vdb.getConnectionType());
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
        conn.close();
        this.admin.changeVDBConnectionType("bqt", 1, VDB.ConnectionType.NONE);
        try {
            TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
            Assert.fail((String)"should have failed to connect as no new connections allowed");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.admin.deploy("bqt2.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt2.vdb")));
        AdminUtil.waitForVDBLoad(this.admin, "bqt2", 1, 3);
        this.admin.updateSource("bqt", 2, "Source", "h2", "java:jboss/datasources/ExampleDS");
        conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
        conn.close();
        this.admin.changeVDBConnectionType("bqt", 2, VDB.ConnectionType.ANY);
        conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
        conn.close();
        vdb = this.admin.getVDB("bqt", 2);
        model = (Model)vdb.getModels().get(0);
        Assert.assertEquals((Object)model.getSourceConnectionJndiName("Source"), (Object)"java:jboss/datasources/ExampleDS");
        Assert.assertEquals((Object)model.getSourceTranslatorName("Source"), (Object)"h2");
        Assert.assertEquals((Object)VDB.ConnectionType.ANY, (Object)vdb.getConnectionType());
    }

    @Test
    public void testCacheTypes() throws Exception {
        Object[] array = new String[]{Admin.Cache.PREPARED_PLAN_CACHE.toString(), Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString()};
        Collection types = this.admin.getCacheTypes();
        Assert.assertArrayEquals((Object[])array, (Object[])types.toArray());
    }

    @Test
    public void testSessions() throws Exception {
        this.deployVdb();
        Collection sessions = this.admin.getSessions();
        Assert.assertEquals((long)0L, (long)sessions.size());
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user;ApplicationName=test", null);
        sessions = this.admin.getSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        Session s = (Session)sessions.iterator().next();
        Assert.assertEquals((Object)"user@teiid-security", (Object)s.getUserName());
        Assert.assertEquals((Object)"test", (Object)s.getApplicationName());
        Assert.assertEquals((Object)"bqt", (Object)s.getVDBName());
        Assert.assertEquals((long)1L, (long)s.getVDBVersion());
        Assert.assertNotNull((Object)s.getSessionId());
        conn.close();
        conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user;ApplicationName=test", null);
        sessions = this.admin.getSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        s = (Session)sessions.iterator().next();
        this.admin.terminateSession(s.getSessionId());
        Thread.sleep(2000L);
        sessions = this.admin.getSessions();
        Assert.assertEquals((long)0L, (long)sessions.size());
        conn.close();
    }

    private boolean deployVdb() throws AdminException, FileNotFoundException {
        this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
        AdminUtil.waitForVDBLoad(this.admin, "bqt", 1, 3);
        boolean vdbOneDeployed = true;
        VDB vdb = this.admin.getVDB("bqt", 1);
        Model model = (Model)vdb.getModels().get(0);
        this.admin.assignToModel("bqt", 1, model.getName(), "Source", "h2", "java:jboss/datasources/ExampleDS");
        return vdbOneDeployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRequests() throws Exception {
        JavaArchive jar = this.getLoopyArchive();
        try {
            this.admin.deploy("loopy.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
            this.deployVdb();
            Translator t = this.admin.getTranslator("loopy");
            Assert.assertNotNull((Object)t);
            this.admin.updateSource("bqt", 1, "Source", "loopy", "java:jboss/datasources/ExampleDS");
            ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:bqt@mm://localhost:31000;user=user;password=user", null);
            Collection sessions = this.admin.getSessions();
            Assert.assertEquals((long)1L, (long)sessions.size());
            Session s = (Session)sessions.iterator().next();
            Statement stmt = conn.createStatement();
            Collection requests = this.admin.getRequests();
            Assert.assertEquals((long)0L, (long)requests.size());
            stmt.execute("select * from source.smalla");
            requests = this.admin.getRequests();
            Assert.assertEquals((long)1L, (long)requests.size());
            Request r = (Request)requests.iterator().next();
            Assert.assertEquals((Object)"select * from source.smalla", (Object)r.getCommand());
            Assert.assertNotNull((Object)r.getExecutionId());
            Assert.assertNotNull((Object)r.getSessionId());
            stmt.execute("select * from source.smalla");
            Collection requests2 = this.admin.getRequestsForSession(s.getSessionId());
            Assert.assertEquals((long)1L, (long)requests2.size());
            Request r2 = (Request)requests.iterator().next();
            Assert.assertEquals((Object)"select * from source.smalla", (Object)r2.getCommand());
            Assert.assertEquals((Object)s.getSessionId(), (Object)r2.getSessionId());
            stmt.close();
            conn.close();
            requests = this.admin.getRequests();
            Assert.assertEquals((long)0L, (long)requests.size());
        }
        finally {
            this.admin.undeploy("loopy.jar");
        }
    }

    @Test
    public void getDatasourceTemplateNames() throws Exception {
        HashSet<String> vals = new HashSet<String>(Arrays.asList("teiid-local", "google", "teiid", "ldap", "accumulo", "file", "cassandra", "salesforce", "mongodb", "solr", "webservice", "simpledb", "h2"));
        this.deployVdb();
        Set templates = this.admin.getDataSourceTemplateNames();
        Assert.assertEquals(vals, (Object)templates);
    }

    @Test
    public void getTemplatePropertyDefinitions() throws Exception {
        HashSet<String> props = new HashSet<String>();
        this.deployVdb();
        Collection pds = this.admin.getTemplatePropertyDefinitions("h2");
        for (PropertyDefinition pd : pds) {
            props.add(pd.getName());
        }
        Assert.assertTrue((boolean)props.contains("connection-url"));
        Assert.assertTrue((boolean)props.contains("user-name"));
        Assert.assertTrue((boolean)props.contains("password"));
        Assert.assertTrue((boolean)props.contains("check-valid-connection-sql"));
        Assert.assertTrue((boolean)props.contains("max-pool-size"));
        Assert.assertTrue((boolean)props.contains("connection-properties"));
        Assert.assertTrue((boolean)props.contains("max-pool-size"));
        HashSet<String> rar_props = new HashSet<String>();
        pds = this.admin.getTemplatePropertyDefinitions("file");
        for (PropertyDefinition pd : pds) {
            rar_props.add(pd.getName());
        }
        Assert.assertTrue((boolean)rar_props.contains("ParentDirectory"));
        Assert.assertTrue((boolean)rar_props.contains("FileMapping"));
        Assert.assertTrue((boolean)rar_props.contains("AllowParentPaths"));
        Assert.assertTrue((boolean)rar_props.contains("resourceadapter-class"));
        Assert.assertTrue((boolean)rar_props.contains("managedconnectionfactory-class"));
        Assert.assertTrue((boolean)rar_props.contains("max-pool-size"));
    }

    @Test
    public void getTranslatorPropertyDefinitions() throws Exception {
        HashSet<String> props = new HashSet<String>();
        Collection pds = this.admin.getTranslatorPropertyDefinitions("ws");
        for (PropertyDefinition pd : pds) {
            props.add(pd.getName());
        }
        Assert.assertTrue((boolean)props.contains("DefaultBinding"));
        Assert.assertTrue((boolean)props.contains("DefaultServiceMode"));
        Assert.assertTrue((boolean)props.contains("MaxDependentInPredicates"));
        for (PropertyDefinition pd : pds) {
            if (!pd.getName().equals("DefaultBinding")) continue;
            Assert.assertEquals((Object)"java.lang.String", (Object)pd.getPropertyTypeClassName());
            Assert.assertFalse((boolean)pd.isRequired());
            Assert.assertEquals((Object)"Contols what SOAP or HTTP type of invocation will be used if none is specified.", (Object)pd.getDescription());
            Assert.assertEquals((Object)"Default Binding", (Object)pd.getDisplayName());
            Assert.assertTrue((boolean)pd.isModifiable());
            Assert.assertFalse((boolean)pd.isAdvanced());
            Assert.assertFalse((boolean)pd.isMasked());
            Assert.assertEquals((Object)"SOAP12", (Object)pd.getDefaultValue());
            Assert.assertNotNull((Object)pd.getAllowedValues());
        }
    }

    @Test
    public void getWorkerPoolStats() throws Exception {
        this.deployVdb();
        Assert.assertNotNull((Object)this.admin.getWorkerPoolStats());
    }

    @Test
    public void testDataRoleMapping() throws Exception {
        this.admin.deploy("bqt2.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt2.vdb")));
        AdminUtil.waitForVDBLoad(this.admin, "bqt2", 1, 3);
        VDB vdb = this.admin.getVDB("bqt", 2);
        Model model = (Model)vdb.getModels().get(0);
        this.admin.assignToModel("bqt", 2, model.getName(), "Source", "h2", "java:jboss/datasources/ExampleDS");
        vdb = this.admin.getVDB("bqt", 2);
        Assert.assertTrue((boolean)vdb.isValid());
        List policies = vdb.getDataPolicies();
        Assert.assertEquals((long)1L, (long)policies.size());
        DataPolicy dp = (DataPolicy)policies.get(0);
        Assert.assertEquals((Object)"roleOne", (Object)dp.getName());
        Assert.assertEquals((long)2L, (long)dp.getPermissions().size());
        Assert.assertTrue((boolean)dp.isAllowCreateTemporaryTables());
        Assert.assertTrue((boolean)dp.isAnyAuthenticated());
        List roleNames = dp.getMappedRoleNames();
        Assert.assertArrayEquals((Object[])new String[]{"ROLE1", "ROLE2"}, (Object[])roleNames.toArray());
        this.admin.removeDataRoleMapping("bqt", 2, "roleOne", "ROLE1");
        vdb = this.admin.getVDB("bqt", 2);
        policies = vdb.getDataPolicies();
        dp = (DataPolicy)policies.get(0);
        roleNames = dp.getMappedRoleNames();
        Assert.assertArrayEquals((Object[])new String[]{"ROLE2"}, (Object[])roleNames.toArray());
        this.admin.addDataRoleMapping("bqt", 2, "roleOne", "ROLE3");
        vdb = this.admin.getVDB("bqt", 2);
        policies = vdb.getDataPolicies();
        dp = (DataPolicy)policies.get(0);
        roleNames = dp.getMappedRoleNames();
        Assert.assertArrayEquals((Object[])new String[]{"ROLE2", "ROLE3"}, (Object[])roleNames.toArray());
        this.admin.setAnyAuthenticatedForDataRole("bqt", 2, "roleOne", false);
        vdb = this.admin.getVDB("bqt", 2);
        policies = vdb.getDataPolicies();
        dp = (DataPolicy)policies.get(0);
        Assert.assertFalse((boolean)dp.isAnyAuthenticated());
    }

    @Test
    public void testCreateConnectionFactory() throws Exception {
        String deployedName = "wsOne";
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(deployedName));
        Properties p = new Properties();
        p.setProperty("class-name", "org.teiid.resource.adapter.ws.WSManagedConnectionFactory");
        p.setProperty("EndPoint", "{endpoint}");
        this.admin.createDataSource(deployedName, "webservice", p);
        Assert.assertTrue((boolean)this.admin.getDataSourceNames().contains(deployedName));
        this.admin.deleteDataSource(deployedName);
        Assert.assertFalse((boolean)this.admin.getDataSourceNames().contains(deployedName));
        this.admin.createDataSource(deployedName, "webservice", p);
        Assert.assertTrue((boolean)this.admin.getDataSourceNames().contains(deployedName));
        this.admin.deleteDataSource(deployedName);
    }

    @Test
    public void testVDBRestart() throws Exception {
        String vdbName = "test";
        String testVDB = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"test\" version=\"1\">\n    <property name=\"UseConnectorMetadata\" value=\"cached\" />\n    <model name=\"loopy\">\n        <source name=\"loop\" translator-name=\"loopy\" />\n    </model>\n</vdb>";
        Collection vdbs = this.admin.getVDBs();
        Assert.assertTrue((boolean)vdbs.isEmpty());
        JavaArchive jar = this.getLoopyArchive();
        this.admin.deploy("loopy.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
        this.admin.deploy("test-vdb.xml", (InputStream)new ByteArrayInputStream(testVDB.getBytes()));
        AdminUtil.waitForVDBLoad(this.admin, vdbName, 1, 3);
        int count = this.assertMetadataLoadCount(false, 1);
        this.admin.restartVDB(vdbName, 1, new String[0]);
        AdminUtil.waitForVDBLoad(this.admin, vdbName, 1, 3);
        count = this.assertMetadataLoadCount(true, count + 1);
        this.admin.restartVDB(vdbName, 1, new String[0]);
        AdminUtil.waitForVDBLoad(this.admin, vdbName, 1, 3);
        count = this.assertMetadataLoadCount(true, count + 1);
        this.admin.undeploy("loopy.jar");
    }

    private int assertMetadataLoadCount(boolean check, int expected) throws SQLException {
        ConnectionImpl conn = TeiidDriver.getInstance().connect("jdbc:teiid:test.1@mm://localhost:31000;user=user;password=user", null);
        Statement stmt = conn.createStatement();
        stmt.execute("SELECT execCount FROM Matadata");
        ResultSet rs = stmt.getResultSet();
        rs.next();
        int execCount = rs.getInt(1);
        if (check) {
            Assert.assertEquals((long)expected, (long)execCount);
        }
        rs.close();
        stmt.close();
        conn.close();
        return execCount;
    }

    @Test
    public void testDDLExport() throws Exception {
        String vdbName = "test";
        String testVDB = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"test\" version=\"1\">\n    <property name=\"UseConnectorMetadata\" value=\"cached\" />\n    <model name=\"loopy\">\n        <source name=\"loop\" translator-name=\"loopy\" />\n    </model>\n</vdb>";
        Collection vdbs = this.admin.getVDBs();
        Assert.assertTrue((boolean)vdbs.isEmpty());
        JavaArchive jar = this.getLoopyArchive();
        this.admin.deploy("loopy.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
        this.admin.deploy("test-vdb.xml", (InputStream)new ByteArrayInputStream(testVDB.getBytes()));
        AdminUtil.waitForVDBLoad(this.admin, vdbName, 1, 3);
        String ddl = this.admin.getSchema(vdbName, 1, "loopy", null, null);
        String expected = "CREATE FOREIGN TABLE Matadata (\n\texecCount integer\n);";
        Assert.assertEquals((Object)expected, (Object)ddl);
        this.admin.undeploy("loopy.jar");
    }

    @Test
    public void testErrorDeployment() throws Exception {
        Collection vdbs = this.admin.getVDBs();
        Assert.assertTrue((boolean)vdbs.isEmpty());
        this.admin.deploy("error-vdb.xml", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"error-vdb.xml")));
        AdminUtil.waitForVDBLoad(this.admin, "error", 1, 3);
        VDB vdb = this.admin.getVDB("error", 1);
        Assert.assertEquals((Object)VDB.Status.FAILED, (Object)vdb.getStatus());
    }

    @Test
    public void testODBCConnectionSuccess() throws Exception {
        this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "user");
        p.setProperty("password", "user");
        Connection c = d.connect("jdbc:postgresql://127.0.0.1:35432/bqt", p);
        c.close();
    }

    @Test
    public void testODBCConnectionFailure() throws Exception {
        this.admin.deploy("bqt.vdb", (InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"bqt.vdb")));
        Driver d = new Driver();
        Properties p = new Properties();
        p.setProperty("user", "user");
        p.setProperty("password", "notpassword");
        try {
            d.connect("jdbc:postgresql://127.0.0.1:35432/bqt", p);
            Assert.fail((String)"failed due to bad credentials");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Test
    public void testSystemPropertiesInVDBXML() throws Exception {
        String vdbName = "test";
        String testVDB = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<vdb name=\"test\" version=\"1\">\n    <property name=\"UseConnectorMetadata\" value=\"${teiid.vdb.UseConnectorMetadata:none}\" />\n    <model name=\"loopy\">\n        <source name=\"loop\" translator-name=\"loopy\" />\n    </model>\n</vdb>";
        Collection vdbs = this.admin.getVDBs();
        Assert.assertTrue((boolean)vdbs.isEmpty());
        JavaArchive jar = this.getLoopyArchive();
        this.admin.deploy("loopy.jar", ((ZipExporter)jar.as(ZipExporter.class)).exportAsInputStream());
        this.admin.deploy("test-vdb.xml", (InputStream)new ByteArrayInputStream(testVDB.getBytes()));
        AdminUtil.waitForVDBLoad(this.admin, vdbName, 1, 3);
        VDB vdb = this.admin.getVDB(vdbName, 1);
        String value = vdb.getPropertyValue("UseConnectorMetadata");
        Assert.assertEquals((Object)"custom", (Object)value);
        this.admin.undeploy("loopy.jar");
        this.admin.undeploy("test-vdb.xml");
    }
}

