/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.sql.Blob;
import java.sql.Clob;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.resolver.TestFunctionResolving;
import org.teiid.query.sql.symbol.Expression;

public class TestGeometry {
    @Test
    public void testRoundTrip() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))')");
        GeometryType geom = (GeometryType)Evaluator.evaluate((Expression)ex);
        byte[] bytes = geom.getBytes(1L, (int)geom.length());
        Expression ex1 = TestFunctionResolving.getExpression("ST_GeomFromBinary(X'" + new BinaryType(bytes) + "')");
        GeometryType geom1 = (GeometryType)Evaluator.evaluate((Expression)ex1);
        Assert.assertEquals((Object)geom, (Object)geom1);
    }

    @Test
    public void testAsText() throws Exception {
        Expression ex2 = TestFunctionResolving.getExpression("st_astext(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Clob val = (Clob)Evaluator.evaluate((Expression)ex2);
        Assert.assertEquals((Object)"POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))", (Object)ClobType.getString((Clob)val));
    }

    @Test
    public void testAsBinary() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_asbinary(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Assert.assertTrue((boolean)(Evaluator.evaluate((Expression)ex) instanceof Blob));
    }

    @Test
    public void testContains() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_contains(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }

    @Test
    public void testIntersects() throws Exception {
        Expression ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'), ST_GeomFromText('POLYGON ((40 0, 50 50, 0 50, 0 0, 40 0))'))");
        Boolean b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertTrue((boolean)b);
        ex = TestFunctionResolving.getExpression("st_intersects(ST_GeomFromText('POLYGON ((100 100, 200 200, 75 75, 100 100))'), ST_GeomFromText('POLYGON ((43 0, 50 50, 0 50, 0 0, 43 0))'))");
        b = (Boolean)Evaluator.evaluate((Expression)ex);
        Assert.assertFalse((boolean)b);
    }
}

