/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.InStream;
import com.vividsolutions.jts.io.InputStreamInStream;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKBWriter;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;

public class GeometryUtils {
    public static ClobType geometryToClob(GeometryType geometry) throws FunctionExecutionException {
        InputStream is = null;
        try {
            WKBReader reader = new WKBReader();
            is = geometry.getBinaryStream();
            Geometry jtsGeometry = reader.read((InStream)new InputStreamInStream(is));
            ClobType clobType = new ClobType((Clob)new ClobImpl(jtsGeometry.toText()));
            return clobType;
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static GeometryType geometryFromClob(ClobType wkt) throws FunctionExecutionException {
        Reader r = null;
        try {
            WKTReader reader = new WKTReader();
            WKBWriter writer = new WKBWriter();
            r = wkt.getCharacterStream();
            Geometry jtsGeometry = reader.read(r);
            byte[] bytes = writer.write(jtsGeometry);
            GeometryType geometryType = new GeometryType(bytes);
            return geometryType;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static GeometryType geometryFromBlob(BlobType wkb) throws FunctionExecutionException {
        InputStream is = null;
        try {
            WKBReader reader = new WKBReader();
            is = wkb.getBinaryStream();
            reader.read((InStream)new InputStreamInStream(is));
            GeometryType geometryType = new GeometryType((Blob)wkb.getReference());
            return geometryType;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Boolean intersects(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            WKBReader reader = new WKBReader();
            is1 = geom1.getBinaryStream();
            is2 = geom2.getBinaryStream();
            Geometry g1 = reader.read((InStream)new InputStreamInStream(is1));
            Geometry g2 = reader.read((InStream)new InputStreamInStream(is2));
            Boolean bl = g1.intersects(g2);
            return bl;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (is1 != null) {
                try {
                    is1.close();
                }
                catch (IOException e) {}
            }
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static Boolean contains(GeometryType geom1, GeometryType geom2) throws FunctionExecutionException {
        InputStream is1 = null;
        InputStream is2 = null;
        try {
            WKBReader reader = new WKBReader();
            is1 = geom1.getBinaryStream();
            is2 = geom2.getBinaryStream();
            Geometry g1 = reader.read((InStream)new InputStreamInStream(is1));
            Geometry g2 = reader.read((InStream)new InputStreamInStream(is2));
            Boolean bl = g1.contains(g2);
            return bl;
        }
        catch (ParseException e) {
            throw new FunctionExecutionException(e);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException(e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException(e);
        }
        finally {
            if (is1 != null) {
                try {
                    is1.close();
                }
                catch (IOException e) {}
            }
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

