/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.test.util.PropUtils;

public class ConfigPropertyLoader {
    public static final String DEFAULT_CONFIG_FILE_NAME = "default-config.properties";
    private static ConfigPropertyLoader _instance = null;
    private static String LAST_CONFIG_FILE = null;
    private Properties overrides = new Properties();
    private Properties props = null;
    private Map<String, String> modelAssignedDatabaseType = new HashMap<String, String>(5);

    private ConfigPropertyLoader() {
    }

    public static synchronized ConfigPropertyLoader getInstance() {
        boolean diff = ConfigPropertyLoader.differentConfigProp();
        if (_instance != null) {
            if (!diff) {
                return _instance;
            }
            ConfigPropertyLoader.reset();
        }
        _instance = new ConfigPropertyLoader();
        _instance.initialize();
        return _instance;
    }

    private static boolean differentConfigProp() {
        String filename = System.getProperty("config");
        if (filename == null) {
            filename = DEFAULT_CONFIG_FILE_NAME;
        }
        if (LAST_CONFIG_FILE == null || !LAST_CONFIG_FILE.equalsIgnoreCase(filename)) {
            LAST_CONFIG_FILE = filename;
            return true;
        }
        return false;
    }

    public static synchronized void reset() {
        if (_instance == null) {
            return;
        }
        ConfigPropertyLoader._instance.overrides.clear();
        ConfigPropertyLoader._instance.modelAssignedDatabaseType.clear();
        ConfigPropertyLoader._instance.props.clear();
        _instance = null;
        LAST_CONFIG_FILE = null;
    }

    private void initialize() {
        this.props = PropUtils.loadProperties(LAST_CONFIG_FILE, null);
    }

    public String getProperty(String key) {
        String rtn = null;
        rtn = this.overrides.getProperty(key);
        if (rtn == null && (rtn = this.props.getProperty(key)) == null) {
            rtn = System.getProperty(key);
        }
        return rtn;
    }

    public void setProperty(String key, String value) {
        this.overrides.setProperty(key, value);
    }

    public void setProperties(Properties props) {
        this.overrides.putAll((Map<?, ?>)props);
    }

    public Properties getProperties() {
        Properties p = PropertiesUtils.clone((Properties)System.getProperties());
        if (this.props != null) {
            p.putAll((Map<?, ?>)this.props);
        }
        if (this.overrides != null) {
            p.putAll((Map<?, ?>)this.overrides);
        }
        return p;
    }

    public boolean isDataStoreDisabled() {
        String disable_config = this.getProperty("disable_datastore");
        return disable_config != null;
    }

    public Map<String, String> getModelAssignedDatabaseTypes() {
        return this.modelAssignedDatabaseType;
    }

    public void setModelAssignedToDatabaseType(String modelname, String dbtype) {
        this.modelAssignedDatabaseType.put(modelname, dbtype);
    }

    public static void main(String[] args) {
        System.setProperty("test", "value");
        ConfigPropertyLoader _instance = ConfigPropertyLoader.getInstance();
        Properties p = _instance.getProperties();
        if (p == null || p.isEmpty()) {
            throw new RuntimeException("Failed to load config properties file");
        }
        if (!p.getProperty("test").equalsIgnoreCase("value")) {
            throw new RuntimeException("Failed to pickup system property");
        }
        _instance.setProperty("override", "ovalue");
        if (!_instance.getProperties().getProperty("override").equalsIgnoreCase("ovalue")) {
            throw new RuntimeException("Override value wasnt found");
        }
        ConfigPropertyLoader.reset();
        if (_instance.getProperties().getProperty("override") != null) {
            throw new RuntimeException("Override value was found, should have been removed on reset");
        }
        if (!p.getProperty("test").equalsIgnoreCase("value")) {
            throw new RuntimeException("Failed to pickup system property");
        }
        System.out.println("Loaded Config Properties " + p.toString());
    }
}

