/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Matcher;
import javax.sql.rowset.serial.SerialArray;
import org.teiid.client.RequestMessage;
import org.teiid.client.metadata.MetadataResult;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.JDBCSQLTypeInfo;
import org.teiid.core.util.ReaderInputStream;
import org.teiid.core.util.SqlUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.DataTypeTransformer;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.jdbc.MetadataProvider;
import org.teiid.jdbc.NonBlockingRowProcessor;
import org.teiid.jdbc.ParameterMetaDataImpl;
import org.teiid.jdbc.RequestOptions;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.ResultSetMetaDataImpl;
import org.teiid.jdbc.StatementCallback;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidPreparedStatement;
import org.teiid.jdbc.TeiidSQLException;

public class PreparedStatementImpl
extends StatementImpl
implements TeiidPreparedStatement {
    protected String prepareSql;
    private Map<Integer, Object> parameterMap;
    TreeMap<String, Integer> paramsByName;
    protected List<List<Object>> batchParameterList;
    private MetadataResult metadataResults;
    private ResultSetMetaData metadata;
    private ParameterMetaDataImpl parameterMetaData;
    private Calendar serverCalendar;
    private Object command;
    private boolean autoGeneratedKeys;

    PreparedStatementImpl(ConnectionImpl connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        super(connection, resultSetType, resultSetConcurrency);
        if (sql == null) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMPreparedStatement.Err_prep_sql"));
        }
        this.prepareSql = sql;
        TimeZone timezone = connection.getServerConnection().getLogonResult().getTimeZone();
        if (timezone != null && !timezone.hasSameRules(this.getDefaultCalendar().getTimeZone())) {
            this.serverCalendar = Calendar.getInstance(timezone);
        }
    }

    public void setAutoGeneratedKeys(boolean getAutoGeneratedKeys) {
        this.autoGeneratedKeys = getAutoGeneratedKeys;
    }

    @Override
    public void addBatch() throws SQLException {
        this.checkStatement();
        if (this.batchParameterList == null) {
            this.batchParameterList = new ArrayList<List<Object>>();
        }
        this.batchParameterList.add(this.getParameterValues());
        this.clearParameters();
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchParameterList != null) {
            this.batchParameterList.clear();
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkStatement();
        if (this.parameterMap != null) {
            this.parameterMap.clear();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public void submitExecute(String sql, StatementCallback callback, RequestOptions options) throws TeiidSQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        String msg = JDBCPlugin.Util.getString("JDBC.Method_not_supported");
        throw new TeiidSQLException(msg);
    }

    @Override
    public void submitExecute(StatementCallback callback, RequestOptions options) throws SQLException {
        NonBlockingRowProcessor processor = new NonBlockingRowProcessor(this, callback);
        this.submitExecute(RequestMessage.ResultsMode.EITHER, options).addCompletionListener(processor);
    }

    public ResultsFuture<Boolean> submitExecute(RequestMessage.ResultsMode mode, RequestOptions options) throws SQLException {
        return this.executeSql(new String[]{this.prepareSql}, false, mode, false, options);
    }

    @Override
    public boolean execute() throws SQLException {
        this.executeSql(new String[]{this.prepareSql}, false, RequestMessage.ResultsMode.EITHER, true, null);
        return this.hasResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        if (this.batchParameterList == null || this.batchParameterList.isEmpty()) {
            return new int[0];
        }
        try {
            this.executeSql(new String[]{this.prepareSql}, true, RequestMessage.ResultsMode.UPDATECOUNT, true, null);
        }
        finally {
            this.batchParameterList.clear();
        }
        return this.updateCounts;
    }

    @Override
    public ResultSetImpl executeQuery() throws SQLException {
        this.executeSql(new String[]{this.prepareSql}, false, RequestMessage.ResultsMode.RESULTSET, true, null, this.autoGeneratedKeys);
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.executeSql(new String[]{this.prepareSql}, false, RequestMessage.ResultsMode.UPDATECOUNT, true, null, this.autoGeneratedKeys);
        if (this.updateCounts == null) {
            return 0;
        }
        return this.updateCounts[0];
    }

    @Override
    protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
        RequestMessage message = super.createRequestMessage(commands, false, resultsMode);
        message.setStatementType(RequestMessage.StatementType.PREPARED);
        message.setParameterValues(isBatchedCommand ? this.getParameterValuesList() : this.getParameterValues());
        message.setBatchedUpdate(isBatchedCommand);
        message.setCommand(this.command);
        return message;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkStatement();
        if (this.metadata == null) {
            if (this.updateCounts != null) {
                return null;
            }
            if (this.resultSet != null) {
                this.metadata = this.resultSet.getMetaData();
            } else {
                Matcher matcher = StatementImpl.SHOW_STATEMENT.matcher(this.prepareSql);
                if (matcher.matches()) {
                    this.executeShow(matcher);
                    this.metadata = this.resultSet.getMetaData();
                    this.resultSet = null;
                    return this.metadata;
                }
                if (this.getMetadataResults().getColumnMetadata() == null) {
                    return null;
                }
                MetadataProvider provider = new MetadataProvider(this.getMetadataResults().getColumnMetadata());
                this.metadata = new ResultSetMetaDataImpl(provider, this.getExecutionProperty("useJDBC4ColumnNameAndLabelSemantics"));
            }
        }
        return this.metadata;
    }

    private MetadataResult getMetadataResults() throws SQLException {
        if (this.metadataResults == null) {
            if (StatementImpl.SET_STATEMENT.matcher(this.prepareSql).matches() || StatementImpl.TRANSACTION_STATEMENT.matcher(this.prepareSql).matches() || StatementImpl.SHOW_STATEMENT.matcher(this.prepareSql).matches() || StatementImpl.SET_CHARACTERISTIC_STATEMENT.matcher(this.prepareSql).matches()) {
                this.metadataResults = new MetadataResult();
            } else {
                try {
                    this.metadataResults = this.getDQP().getMetadata(this.currentRequestID, this.prepareSql, Boolean.valueOf(this.getExecutionProperty("ansiQuotedIdentifiers")));
                }
                catch (TeiidComponentException e) {
                    throw TeiidSQLException.create(e);
                }
                catch (TeiidProcessingException e) {
                    throw TeiidSQLException.create(e);
                }
            }
        }
        return this.metadataResults;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, in);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream in, int length) throws SQLException {
        this.setBlob(parameterIndex, in);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.setObject(parameterIndex, (Object)x);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setByte(int parameterIndex, byte value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.setObject(parameterIndex, (Object)bytes);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.setObject(parameterIndex, (Object)x);
    }

    @Override
    public void setDate(int parameterIndex, Date value) throws SQLException {
        this.setDate(parameterIndex, value, (Calendar)null);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate((Object)parameterIndex, x, cal);
    }

    void setDate(Object parameterIndex, Date x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, (Object)x);
            return;
        }
        this.setObject(parameterIndex, (Object)TimestampWithTimezone.createDate((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    @Override
    public void setDouble(int parameterIndex, double value) throws SQLException {
        this.setObject(parameterIndex, (Object)new Double(value));
    }

    @Override
    public void setFloat(int parameterIndex, float value) throws SQLException {
        this.setObject(parameterIndex, (Object)new Float(value));
    }

    @Override
    public void setInt(int parameterIndex, int value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setLong(int parameterIndex, long value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setNull(int parameterIndex, int jdbcType) throws SQLException {
        this.setObject(parameterIndex, (Object)null);
    }

    @Override
    public void setNull(int parameterIndex, int jdbcType, String typeName) throws SQLException {
        this.setObject(parameterIndex, (Object)null);
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetJdbcType, int scale) throws SQLException {
        this.setObject(parameterIndex, value, targetJdbcType, scale);
    }

    void setObject(Object parameterIndex, Object value, int targetJdbcType, int scale) throws SQLException {
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        if (targetJdbcType != 3 || targetJdbcType != 2) {
            this.setObject(parameterIndex, value, targetJdbcType);
        } else {
            BigDecimal bigDecimalObject = DataTypeTransformer.getBigDecimal(value);
            this.setObject(parameterIndex, (Object)bigDecimalObject.setScale(scale));
        }
    }

    @Override
    public void setObject(int parameterIndex, Object value, int targetJdbcType) throws SQLException {
        this.setObject((Object)parameterIndex, value, targetJdbcType);
    }

    void setObject(Object parameterIndex, Object value, int targetJdbcType) throws SQLException {
        Object targetObject = value;
        if (value == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        String typeName = JDBCSQLTypeInfo.getTypeName((int)targetJdbcType);
        int typeCode = DataTypeManager.getTypeCode((Class)DataTypeManager.getDataTypeClass((String)typeName));
        switch (typeCode) {
            case 0: {
                targetObject = DataTypeTransformer.getString(value);
                break;
            }
            case 1: {
                targetObject = DataTypeTransformer.getCharacter(value);
                break;
            }
            case 5: {
                targetObject = DataTypeTransformer.getInteger(value);
                break;
            }
            case 3: {
                targetObject = DataTypeTransformer.getByte(value);
                break;
            }
            case 4: {
                targetObject = DataTypeTransformer.getShort(value);
                break;
            }
            case 6: {
                targetObject = DataTypeTransformer.getLong(value);
                break;
            }
            case 8: {
                targetObject = Float.valueOf(DataTypeTransformer.getFloat(value));
                break;
            }
            case 9: {
                targetObject = DataTypeTransformer.getDouble(value);
                break;
            }
            case 2: {
                targetObject = DataTypeTransformer.getBoolean(value);
                break;
            }
            case 10: {
                targetObject = DataTypeTransformer.getBigDecimal(value);
                break;
            }
            case 13: {
                targetObject = DataTypeTransformer.getTimestamp(value);
                break;
            }
            case 11: {
                targetObject = DataTypeTransformer.getDate(value);
                break;
            }
            case 12: {
                targetObject = DataTypeTransformer.getTime(value);
                break;
            }
            case 15: {
                targetObject = DataTypeTransformer.getBlob(value);
                break;
            }
            case 16: {
                targetObject = DataTypeTransformer.getClob(value);
                break;
            }
            case 17: {
                targetObject = DataTypeTransformer.getSQLXML(value);
                break;
            }
            case 19: {
                targetObject = DataTypeTransformer.getBytes(value);
            }
        }
        this.setObject(parameterIndex, targetObject);
    }

    @Override
    public void setObject(int parameterIndex, Object value) throws SQLException {
        this.setObject((Object)parameterIndex, value);
    }

    void setObject(Object parameterIndex, Object value) throws SQLException {
        if (parameterIndex instanceof String) {
            String s = (String)parameterIndex;
            if (this.paramsByName == null) {
                this.paramsByName = new TreeMap(String.CASE_INSENSITIVE_ORDER);
                ParameterMetaDataImpl pmdi = this.getParameterMetaData();
                for (int i = 1; i <= pmdi.getParameterCount(); ++i) {
                    String name = pmdi.getParameterName(i);
                    this.paramsByName.put(name, i);
                }
            }
            if ((parameterIndex = this.paramsByName.get(s)) == null) {
                throw new TeiidSQLException(JDBCPlugin.Util.getString("MMCallableStatement.Param_not_found", new Object[]{s}));
            }
        }
        if ((Integer)parameterIndex < 1) {
            throw new TeiidSQLException(JDBCPlugin.Util.getString("MMPreparedStatement.Invalid_param_index"));
        }
        if (this.parameterMap == null) {
            this.parameterMap = new TreeMap<Integer, Object>();
        }
        if (this.serverCalendar != null && value instanceof java.util.Date) {
            value = TimestampWithTimezone.create((java.util.Date)((java.util.Date)value), (TimeZone)this.getDefaultCalendar().getTimeZone(), (Calendar)this.serverCalendar, value.getClass());
        }
        this.parameterMap.put((Integer)parameterIndex, value);
    }

    @Override
    public void setShort(int parameterIndex, short value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setString(int parameterIndex, String value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setTime(int parameterIndex, Time value) throws SQLException {
        this.setTime(parameterIndex, value, (Calendar)null);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime((Object)parameterIndex, x, cal);
    }

    void setTime(Object parameterIndex, Time x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, (Object)x);
            return;
        }
        this.setObject(parameterIndex, (Object)TimestampWithTimezone.createTime((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        this.setTimestamp(parameterIndex, value, (Calendar)null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp((Object)parameterIndex, x, cal);
    }

    void setTimestamp(Object parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (cal == null || x == null) {
            this.setObject(parameterIndex, (Object)x);
            return;
        }
        this.setObject(parameterIndex, (Object)TimestampWithTimezone.createTimestamp((java.util.Date)x, (TimeZone)cal.getTimeZone(), (Calendar)this.getDefaultCalendar()));
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.setObject(parameterIndex, (Object)x);
    }

    List<List<Object>> getParameterValuesList() {
        if (this.batchParameterList == null || this.batchParameterList.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<List<Object>>(this.batchParameterList);
    }

    List<Object> getParameterValues() {
        if (this.parameterMap == null || this.parameterMap.isEmpty()) {
            return Collections.emptyList();
        }
        return new ArrayList<Object>(this.parameterMap.values());
    }

    @Override
    public ParameterMetaDataImpl getParameterMetaData() throws SQLException {
        if (this.parameterMetaData == null) {
            this.parameterMetaData = new ParameterMetaDataImpl(new ResultSetMetaDataImpl(new MetadataProvider(this.getMetadataResults().getParameterMetadata()), this.getExecutionProperty("useJDBC4ColumnNameAndLabelSemantics")));
        }
        return this.parameterMetaData;
    }

    void setServerCalendar(Calendar serverCalendar) {
        this.serverCalendar = serverCalendar;
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterIndex, (Object)xmlObject);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        if (x instanceof ArrayImpl) {
            this.setObject(parameterIndex, (Object)x);
        } else {
            this.setObject(parameterIndex, (Object)new SerialArray(x));
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.setAsciiStream((Object)parameterIndex, x);
    }

    void setAsciiStream(Object parameterIndex, final InputStream x) throws SQLException {
        if (x == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        this.setObject(parameterIndex, (Object)new ClobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return x;
            }
        }, -1L));
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.setBlob(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.setBlob((Object)parameterIndex, inputStream);
    }

    void setBlob(Object parameterIndex, final InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        this.setObject(parameterIndex, (Object)new BlobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return inputStream;
            }
        }));
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob((Object)parameterIndex, reader);
    }

    void setClob(Object parameterIndex, final Reader reader) throws SQLException {
        if (reader == null) {
            this.setObject(parameterIndex, null);
            return;
        }
        this.setObject(parameterIndex, (Object)new ClobImpl(new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return new ReaderInputStream(reader, Charset.forName("UTF-8"));
            }
        }, -1L));
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.setClob(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.setCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.setClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setObject(parameterIndex, (Object)value);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw SqlUtil.createFeatureNotSupportedException();
    }

    public void setCommand(Object command) {
        this.command = command;
    }
}

