/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.BlockingFakeRelationalNode;
import org.teiid.query.processor.relational.FakeRelationalNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.util.CommandContext;

public class TestUnionAllNode {
    public void helpTestUnion(RelationalNode[] children, RelationalNode union, List[] expected) throws TeiidComponentException, TeiidProcessingException {
        BufferManagerImpl mgr = BufferManagerFactory.getTestBufferManager(1L, 2);
        CommandContext context = new CommandContext((Object)"pid", "test", null, null, 1);
        FakeDataManager fdm = new FakeDataManager();
        for (int i = 0; i < children.length; ++i) {
            union.addChild(children[i]);
            children[i].initialize(context, (BufferManager)mgr, (ProcessorDataManager)fdm);
        }
        union.initialize(context, (BufferManager)mgr, (ProcessorDataManager)fdm);
        union.open();
        int currentRow = 1;
        while (true) {
            try {
                TupleBatch batch;
                do {
                    batch = union.nextBatch();
                    for (int row = currentRow; row <= batch.getEndRow(); ++row) {
                        List tuple = batch.getTuple(row);
                        Assert.assertEquals((String)("Rows don't match at " + row), (Object)expected[row - 1], (Object)tuple);
                    }
                    currentRow += batch.getRowCount();
                } while (!batch.getTerminationFlag());
            }
            catch (BlockedException e) {
                continue;
            }
            break;
        }
        union.close();
        Assert.assertEquals((String)"Didn't match expected counts", (long)expected.length, (long)(currentRow - 1));
    }

    @Test
    public void testNoRows() throws TeiidComponentException, TeiidProcessingException {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ArrayList<ElementSymbol> leftElements = new ArrayList<ElementSymbol>();
        leftElements.add(es1);
        FakeRelationalNode leftNode = new FakeRelationalNode(1, new List[0]);
        leftNode.setElements(leftElements);
        ArrayList<ElementSymbol> rightElements = new ArrayList<ElementSymbol>();
        rightElements.add(es2);
        FakeRelationalNode rightNode = new FakeRelationalNode(2, new List[0]);
        rightNode.setElements(rightElements);
        ArrayList<ElementSymbol> unionElements = new ArrayList<ElementSymbol>();
        unionElements.add(es1);
        UnionAllNode union = new UnionAllNode(3);
        union.setElements(unionElements);
        this.helpTestUnion(new RelationalNode[]{leftNode, rightNode}, (RelationalNode)union, new List[0]);
    }

    public void helpTestUnionConfigs(int sources, int blockModIndex, int rowsPerSource, int batchSize, List[] expected) throws TeiidComponentException, TeiidProcessingException {
        ElementSymbol es1 = new ElementSymbol("e1");
        es1.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        ElementSymbol es2 = new ElementSymbol("e2");
        es2.setType(DataTypeManager.DefaultDataClasses.INTEGER);
        RelationalNode[] nodes = new RelationalNode[sources];
        for (int i = 0; i < nodes.length; ++i) {
            ArrayList<ElementSymbol> childElements = new ArrayList<ElementSymbol>();
            childElements.add(es1);
            List[] tuples = new List[rowsPerSource];
            for (int r = 0; r < rowsPerSource; ++r) {
                tuples[r] = Arrays.asList(new Integer(i));
            }
            nodes[i] = blockModIndex >= 0 && i % blockModIndex == 0 ? new BlockingFakeRelationalNode(i, tuples, batchSize) : new FakeRelationalNode(i, tuples, batchSize);
            nodes[i].setElements(childElements);
        }
        ArrayList<ElementSymbol> unionElements = new ArrayList<ElementSymbol>();
        unionElements.add(es1);
        UnionAllNode union = new UnionAllNode(nodes.length);
        union.setElements(unionElements);
        this.helpTestUnion(nodes, (RelationalNode)union, expected);
    }

    @Test
    public void testBasicUnion() throws TeiidComponentException, TeiidProcessingException {
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(1))};
        this.helpTestUnionConfigs(2, -1, 2, 50, expected);
    }

    @Test
    public void testBasicUnionMultipleSources() throws TeiidComponentException, TeiidProcessingException {
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(4)), Arrays.asList(new Integer(4))};
        this.helpTestUnionConfigs(5, -1, 2, 50, expected);
    }

    @Test
    public void testMultipleSourcesHalfBlockingNodes() throws TeiidComponentException, TeiidProcessingException {
        List[] expected = new List[]{Arrays.asList(new Integer(1)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(4))};
        this.helpTestUnionConfigs(5, 2, 1, 50, expected);
    }

    @Test
    public void testMultipleSourcesAllBlockingNodes() throws TeiidComponentException, TeiidProcessingException {
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(3)), Arrays.asList(new Integer(4))};
        this.helpTestUnionConfigs(5, 1, 1, 50, expected);
    }

    @Test
    public void testMultipleSourceMultiBatchAllBlocking() throws TeiidComponentException, TeiidProcessingException {
        List[] expected = new List[]{Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(0)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(1)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2)), Arrays.asList(new Integer(2))};
        this.helpTestUnionConfigs(3, 1, 6, 1, expected);
    }
}

