/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.teiid.core.util.MixinProxy;

public class SimpleMock
extends MixinProxy {
    SimpleMock(Object[] baseInstances) {
        super(baseInstances);
    }

    protected Object noSuchMethodFound(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return false;
            }
            return 0;
        }
        if (!clazz.isInterface()) {
            try {
                Constructor<?> c = clazz.getDeclaredConstructor(new Class[0]);
                if (c != null) {
                    try {
                        return c.newInstance(new Object[0]);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            return null;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        if (clazz.isInterface()) {
            interfaces = new Class[]{clazz};
        }
        if (interfaces != null && interfaces.length > 0) {
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)((Object)this));
        }
        return null;
    }

    public static <T> T createSimpleMock(Class<T> clazz) {
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)((Object)new SimpleMock(new Object[0])));
    }

    public static <T> T createSimpleMock(Object baseInstance, Class<T> clazz) {
        if (baseInstance instanceof Object[]) {
            return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)((Object)new SimpleMock((Object[])baseInstance)));
        }
        return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)((Object)new SimpleMock(new Object[]{baseInstance})));
    }

    public static Object createSimpleMock(Object[] baseInstances, Class[] interfaces) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)((Object)new SimpleMock(baseInstances)));
    }
}

