/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.Streamable;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.dqp.internal.process.SaveOnReadInputStream;

public class TestSaveOnReadInputStream {
    @Test
    public void testSave() throws IOException {
        SaveOnReadInputStream soris = this.getSaveOnReadInputStream();
        InputStreamFactory isf = soris.getInputStreamFactory();
        InputStream is = isf.getInputStream();
        Assert.assertEquals((Object)"hello world", (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)is), Streamable.CHARSET));
        InputStream is2 = isf.getInputStream();
        Assert.assertEquals((Object)"hello world", (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)is2), Streamable.CHARSET));
    }

    @Test
    public void testPartialReadSave() throws IOException {
        SaveOnReadInputStream soris = this.getSaveOnReadInputStream();
        InputStreamFactory isf = soris.getInputStreamFactory();
        InputStream is = isf.getInputStream();
        is.read();
        InputStream is2 = isf.getInputStream();
        Assert.assertEquals((Object)"ello world", (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)is), Streamable.CHARSET));
        Assert.assertEquals((Object)"hello world", (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)is2), Streamable.CHARSET));
        InputStream is3 = isf.getInputStream();
        Assert.assertEquals((Object)"hello world", (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)is3), Streamable.CHARSET));
    }

    @Test
    public void testStorageMode() throws IOException {
        SaveOnReadInputStream soris = this.getSaveOnReadInputStream();
        InputStreamFactory isf = soris.getInputStreamFactory();
        Assert.assertEquals((Object)InputStreamFactory.StorageMode.MEMORY, (Object)isf.getStorageMode());
        InputStream is = isf.getInputStream();
        Assert.assertEquals((Object)"hello world", (Object)new String(ObjectConverterUtil.convertToByteArray((InputStream)is), Streamable.CHARSET));
    }

    private SaveOnReadInputStream getSaveOnReadInputStream() {
        FileStore fs = BufferManagerFactory.getStandaloneBufferManager().createFileStore("test");
        FileStoreInputStreamFactory factory = new FileStoreInputStreamFactory(fs, "UTF-8");
        ByteArrayInputStream is = new ByteArrayInputStream("hello world".getBytes(Streamable.CHARSET));
        SaveOnReadInputStream soris = new SaveOnReadInputStream((InputStream)is, factory);
        return soris;
    }
}

