/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.client;

import org.teiid.test.framework.ConfigPropertyLoader;
import org.teiid.test.framework.TestLogger;
import org.teiid.test.framework.TransactionContainer;
import org.teiid.test.framework.exception.QueryTestFailedException;
import org.teiid.test.framework.exception.TransactionRuntimeException;
import org.teiid.test.framework.transaction.JNDITransaction;
import org.teiid.test.framework.transaction.LocalTransaction;
import org.teiid.test.framework.transaction.TxnAutoTransaction;
import org.teiid.test.framework.transaction.XATransaction;

public class TransactionFactory {
    public static final String TRANSACTION_TYPE = "transaction-option";

    private TransactionFactory() {
    }

    public static TransactionContainer create(ConfigPropertyLoader config) throws QueryTestFailedException {
        TransactionContainer transacton = null;
        String type = config.getProperty(TRANSACTION_TYPE);
        if (type == null) {
            throw new TransactionRuntimeException("transaction-option property was not specified");
        }
        TestLogger.logDebug("====  Create Transaction-Option: " + type);
        if (type.equalsIgnoreCase("local")) {
            transacton = new LocalTransaction();
        } else if (type.equalsIgnoreCase("xa")) {
            transacton = new XATransaction();
        } else if (type.equalsIgnoreCase("jndi")) {
            transacton = new JNDITransaction();
        } else if (type.equalsIgnoreCase("off")) {
            transacton = new TxnAutoTransaction("OFF");
        } else if (type.equalsIgnoreCase("on")) {
            transacton = new TxnAutoTransaction("ON");
        } else if (type.equalsIgnoreCase("auto")) {
            transacton = new TxnAutoTransaction("DETECT");
        } else {
            throw new TransactionRuntimeException("Invalid property value of " + type + " for " + TRANSACTION_TYPE);
        }
        TestLogger.log("====  TransactionContainer: " + transacton.getClass().getName() + " option:" + type);
        return transacton;
    }

    public static interface TRANSACTION_TYPES {
        public static final String LOCAL_TRANSACTION = "local";
        public static final String XATRANSACTION = "xa";
        public static final String JNDI_TRANSACTION = "jndi";
        public static final String OFFWRAP_TRANSACTION = "off";
        public static final String ONWRAP_TRANSACTION = "on";
        public static final String AUTOWRAP_TRANSACTION = "auto";
    }
}

