/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.test.framework.transaction;

import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.teiid.test.framework.TransactionContainer;
import org.teiid.test.framework.TransactionQueryTestCase;
import org.teiid.test.framework.exception.TransactionRuntimeException;

public class JNDITransaction
extends TransactionContainer {
    UserTransaction userTxn = null;

    @Override
    protected void before(TransactionQueryTestCase test) {
        String jndi = test.getConnectionStrategy().getEnvironment().getProperty("usertxn-jndiname");
        if (jndi == null) {
            throw new TransactionRuntimeException("No JNDI name found for the User Transaction to look up in application server");
        }
        try {
            InitialContext ctx = new InitialContext();
            this.userTxn = (UserTransaction)ctx.lookup(jndi);
            this.userTxn.begin();
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    @Override
    protected void after(TransactionQueryTestCase test) {
        try {
            if (this.userTxn != null) {
                if (test.rollbackAllways() || test.exceptionOccurred()) {
                    this.userTxn.rollback();
                } else {
                    this.userTxn.commit();
                }
                this.userTxn = null;
            }
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }
}

