/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.sql.lang.Command;

public class FakeProcessorPlan
extends ProcessorPlan {
    private List outputElements;
    private List batches;
    int batchIndex = 0;
    private int nextBatchRow = 1;
    private boolean opened = false;

    public FakeProcessorPlan(List outputElements, List batches) {
        this.outputElements = outputElements;
        this.batches = batches;
    }

    public FakeProcessorPlan(int counts) {
        List[] rows = new List[counts];
        for (int i = 0; i < counts; ++i) {
            rows[i] = Arrays.asList(new Integer(1));
        }
        TupleBatch batch = new TupleBatch(1, rows);
        batch.setTerminationFlag(true);
        this.batches = Arrays.asList(batch);
        this.outputElements = Command.getUpdateCommandSymbol();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public FakeProcessorPlan clone() {
        throw new UnsupportedOperationException();
    }

    public List getOutputElements() {
        return this.outputElements;
    }

    public void open() throws TeiidComponentException {
        Assert.assertFalse((String)"ProcessorPlan.open() should not be called more than once", (boolean)this.opened);
        this.opened = true;
    }

    public TupleBatch nextBatch() throws BlockedException, TeiidComponentException {
        if (this.batches == null || this.batches.size() == 0 || this.batchIndex >= this.batches.size()) {
            TupleBatch batch = new TupleBatch(this.nextBatchRow, Collections.EMPTY_LIST);
            batch.setTerminationFlag(true);
            return batch;
        }
        Object nextReturn = this.batches.get(this.batchIndex);
        ++this.batchIndex;
        if (nextReturn instanceof TupleBatch) {
            TupleBatch batch = (TupleBatch)nextReturn;
            this.nextBatchRow += batch.getRowCount();
            return batch;
        }
        throw (TeiidComponentException)((Object)nextReturn);
    }

    public void close() throws TeiidComponentException {
    }

    public List getSchema() {
        return this.outputElements;
    }
}

