/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.sql.rowset.serial.SerialBlob;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.ArrayImpl;
import org.teiid.core.types.BinaryType;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.TimestampWithTimezone;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.DefaultCapabilitiesFinder;
import org.teiid.query.processor.FakeDataManager;
import org.teiid.query.processor.ProcessorPlan;
import org.teiid.query.processor.TestProcessor;
import org.teiid.query.processor.TestTextTable;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.query.unittest.TimestampUtil;
import org.teiid.query.util.CommandContext;

public class TestSQLXMLProcessing {
    private static FakeDataManager dataManager = new FakeDataManager();

    @Test
    public void testXmlElementTextContent() throws Exception {
        String sql = "SELECT xmlelement(foo, '<bar>', convert('<bar1/>', xml))";
        List[] expected = new List[]{Arrays.asList("<foo>&lt;bar&gt;<bar1/></foo>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlElementTextContent1() throws Exception {
        String sql = "SELECT xmlelement(foo, '<bar>', convert('<?xml version=\"1.0\" encoding=\"UTF-8\"?><bar1/>', xml))";
        List[] expected = new List[]{Arrays.asList("<foo>&lt;bar&gt;<bar1></bar1></foo>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlElement() throws Exception {
        String sql = "SELECT xmlelement(e1, e2) from pm1.g1 order by e1, e2";
        List[] expected = new List[]{Arrays.asList("<e1>1</e1>"), Arrays.asList("<e1>0</e1>"), Arrays.asList("<e1>0</e1>"), Arrays.asList("<e1>3</e1>"), Arrays.asList("<e1>2</e1>"), Arrays.asList("<e1>1</e1>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlElementWithConcat() throws Exception {
        String sql = "SELECT xmlelement(e1, e2, xmlconcat(xmlelement(x), xmlelement(y, e3))) from pm1.g1 order by e1, e2";
        List[] expected = new List[]{Arrays.asList("<e1>1<x></x><y>false</y></e1>"), Arrays.asList("<e1>0<x></x><y>false</y></e1>"), Arrays.asList("<e1>0<x></x><y>false</y></e1>"), Arrays.asList("<e1>3<x></x><y>true</y></e1>"), Arrays.asList("<e1>2<x></x><y>false</y></e1>"), Arrays.asList("<e1>1<x></x><y>true</y></e1>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlElementWithForest() throws Exception {
        String sql = "SELECT xmlelement(x, xmlforest(e1, e2, '1' as val)) from pm1.g1 order by e1, e2 limit 2";
        List[] expected = new List[]{Arrays.asList("<x><e2>1</e2><val>1</val></x>"), Arrays.asList("<x><e1>a</e1><e2>0</e2><val>1</val></x>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlElementWithAttributes() throws Exception {
        String sql = "SELECT xmlelement(x, xmlattributes(e1, e2, '1' as val)) from pm1.g1 order by e1, e2 limit 2";
        List[] expected = new List[]{Arrays.asList("<x e2=\"1\" val=\"1\"></x>"), Arrays.asList("<x e1=\"a\" e2=\"0\" val=\"1\"></x>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlElementWithPi() throws Exception {
        String sql = "SELECT xmlelement(x, xmlpi(name e1, '  1'))";
        List[] expected = new List[]{Arrays.asList("<x><?e1 1?></x>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlElementWithNamespaces() throws Exception {
        String sql = "SELECT xmlelement(x, xmlnamespaces(no default, 'http://foo' as x, 'http://foo1' as y), xmlattributes(e1), e2) from pm1.g1 order by e1, e2 limit 2";
        List[] expected = new List[]{Arrays.asList("<x xmlns=\"\" xmlns:x=\"http://foo\" xmlns:y=\"http://foo1\">1</x>"), Arrays.asList("<x xmlns=\"\" xmlns:x=\"http://foo\" xmlns:y=\"http://foo1\" e1=\"a\">0</x>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlAgg() throws Exception {
        String sql = "SELECT xmlelement(parent, xmlAgg(xmlelement(x, xmlattributes(e1, e2)))) from pm1.g1";
        List[] expected = new List[]{Arrays.asList("<parent><x e1=\"a\" e2=\"0\"></x><x e2=\"1\"></x><x e1=\"a\" e2=\"3\"></x><x e1=\"c\" e2=\"1\"></x><x e1=\"b\" e2=\"2\"></x><x e1=\"a\" e2=\"0\"></x></parent>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlAggOrderBy() throws Exception {
        String sql = "SELECT xmlelement(parent, xmlAgg(xmlelement(x, xmlattributes(e1, e2)) order by e2)) from pm1.g1";
        List[] expected = new List[]{Arrays.asList("<parent><x e1=\"a\" e2=\"0\"></x><x e1=\"a\" e2=\"0\"></x><x e2=\"1\"></x><x e1=\"c\" e2=\"1\"></x><x e1=\"b\" e2=\"2\"></x><x e1=\"a\" e2=\"3\"></x></parent>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlSerialize() throws Exception {
        String sql = "SELECT xmlserialize(document xmlelement(parent) as string)";
        List[] expected = new List[]{Arrays.asList("<parent></parent>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlSerialize1() throws Exception {
        String sql = "SELECT xmlserialize(document xmlelement(parent) as string including xmldeclaration)";
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.0\" encoding=\"UTF-8\"?><parent></parent>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlSerialize2() throws Exception {
        String sql = "SELECT xmlserialize(document xmlelement(parent) as string version '1.2' including xmldeclaration)";
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.2\" encoding=\"UTF-8\"?><parent></parent>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlSerializeBinary() throws Exception {
        String sql = "SELECT xmlserialize(document xmlelement(parent) as varbinary version '1.2' including xmldeclaration)";
        List[] expected = new List[]{Arrays.asList(new BinaryType("<?xml version=\"1.2\" encoding=\"UTF-8\"?><parent></parent>".getBytes(Charset.forName("UTF-8"))))};
        this.process(sql, expected);
    }

    @Test
    public void testXmlSerializeBinary1() throws Exception {
        String sql = "SELECT xmlserialize(document xmlelement(parent) as varbinary encoding \"UTF-16\" version '1.2' including xmldeclaration)";
        List[] expected = new List[]{Arrays.asList(new BinaryType("<?xml version=\"1.2\" encoding=\"UTF-16\"?><parent></parent>".getBytes(Charset.forName("UTF-16"))))};
        this.process(sql, expected);
    }

    @Test
    public void testXmlSerializeBinary2() throws Exception {
        String sql = "SELECT cast(xmlserialize(document xmlelement(other) as blob encoding \"UTF-16\" version '1.2' including xmldeclaration) as varbinary)";
        List[] expected = new List[]{Arrays.asList(new BinaryType("<?xml version=\"1.2\" encoding=\"UTF-16\"?><other></other>".getBytes(Charset.forName("UTF-16"))))};
        this.process(sql, expected);
    }

    @Test
    public void testXmlSerialize3() throws Exception {
        String sql = "SELECT xmlserialize(document xmlparse(document '<?xml version=\"1.1\" encoding=\"UTF-8\"?><a></a>') as string)";
        List[] expected = new List[]{Arrays.asList("<?xml version=\"1.1\" encoding=\"UTF-8\"?><a></a>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTable() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert('<a><b>first</b><b x=\"attr\">second</b></a>', xml) columns x string path '@x', val string path '/.') as x";
        List[] expected = new List[]{Arrays.asList(null, "first"), Arrays.asList("attr", "second")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableNull() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert(null, xml) columns x string path '@x', val string path '/.') as x";
        List[] expected = new List[]{};
        this.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testXmlTableSequence() throws Exception {
        String sql = "select * from xmltable('/a' passing convert('<a><b>first</b><b x=\"attr\">second</b></a>', xml) columns x string path 'b') as x";
        this.process(sql, null);
    }

    @Test
    public void testXmlTableSequenceArray() throws Exception {
        String sql = "select * from xmltable('/a' passing convert('<a><b>first</b><b x=\"attr\">second</b></a>', xml) columns x string[] path 'b') as x";
        List[] expected = new List[]{Arrays.asList(new ArrayImpl(new Object[]{"first", "second"}))};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableBinary() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert('<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><b xsi:type=\"xs:hexBinary\">0FAB</b><b>1F1C</b></a>', xml) columns val varbinary path '/.') as x";
        List[] expected = new List[]{Arrays.asList(new BinaryType(new byte[]{15, -85})), Arrays.asList(new BinaryType(new byte[]{31, 28}))};
        this.process(sql, expected);
    }

    @Test
    public void testXsiNil() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert('<a xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><b xsi:nil=\"true\" xsi:type=\"xs:int\"/><b>1</b></a>', xml) columns val integer path '.') as x";
        List[] expected = new List[]{Collections.singletonList(null), Arrays.asList(1)};
        this.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testXmlTableAsynchError() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert('<a><b>first</b><b x=\"attr\">second</b></a>', xml) columns x blob path '@x', val string path '/.') as x";
        this.process(sql, null);
    }

    @Test
    public void testXmlTableNumeric() throws Exception {
        String sql = "select * from xmltable('/a' passing convert('<a s=\"1\" d=\"2.0\" l=\"12345678901\"/>', xml) columns x short path '@s', x1 double path '@d', z long path '@l') as x";
        List[] expected = new List[]{Arrays.asList((short)1, 2.0, 12345678901L)};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableDateTime() throws Exception {
        String sql = "select * from xmltable('/a' passing convert('<a dt=\"0001-11-17T07:38:49\" dtz=\"2011-11-17T07:38:49Z\" t=\"13:23:14\" d=\"2010-04-05\" />', xml) columns x timestamp path '@dt', x1 timestamp path '@dtz', y date path '@d', z time path '@t') as x";
        List[] expected = new List[]{Arrays.asList(TimestampUtil.createTimestamp((int)-1899, (int)10, (int)19, (int)7, (int)38, (int)49, (int)0), TimestampUtil.createTimestamp((int)111, (int)10, (int)17, (int)1, (int)38, (int)49, (int)0), TimestampUtil.createDate((int)110, (int)3, (int)5), TimestampUtil.createTime((int)13, (int)23, (int)14))};
        this.process(sql, expected);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testXmlTableDateTimeInDST() throws Exception {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("PST"));
        try {
            String sql = "select * from xmltable('/a' passing convert('<a dt=\"2011-11-01T09:38:49\" dtz=\"2011-11-01T07:38:49Z\"/>', xml) columns x timestamp path '@dt', x1 timestamp path '@dtz') as x";
            List[] expected = new List[]{Arrays.asList(TimestampUtil.createTimestamp((int)111, (int)10, (int)1, (int)9, (int)38, (int)49, (int)0), TimestampUtil.createTimestamp((int)111, (int)10, (int)1, (int)0, (int)38, (int)49, (int)0))};
            this.process(sql, expected);
        }
        finally {
            TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        }
    }

    @Test
    public void testXmlTablePassingSubquery() throws Exception {
        String sql = "select * from xmltable('/a/b' passing (SELECT xmlelement(name a, xmlAgg(xmlelement(name b, e1))) from pm1.g1) columns val string path '/.') as x";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(""), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableInView() throws Exception {
        String sql = "select * from g1";
        List[] expected = new List[]{Arrays.asList(null, "first"), Arrays.asList("attr", "second")};
        MetadataStore metadataStore = new MetadataStore();
        Schema vm1 = RealMetadataFactory.createVirtualModel("vm1", metadataStore);
        QueryNode vm1g1n1 = new QueryNode("select * from xmltable('/a/b' passing convert('<a><b>first</b><b x=\"attr\">second</b></a>', xml) columns x string path '@x', val string path '/.') as x");
        Table vm1g1 = RealMetadataFactory.createVirtualGroup("g1", vm1, vm1g1n1);
        RealMetadataFactory.createElements(vm1g1, new String[]{"x", "val"}, new String[]{"string", "string"});
        TransformationMetadata metadata = RealMetadataFactory.createTransformationMetadata(metadataStore, "example", new FunctionTree[0]);
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), TestProcessor.createCommandContext());
        TestProcessor.helpProcess(plan, TestProcessor.createCommandContext(), dataManager, expected);
        plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)metadata, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), TestProcessor.createCommandContext());
        TestProcessor.doProcess(plan, dataManager, expected, TestProcessor.createCommandContext());
    }

    @Test
    public void testXmlTableDefaultAndParent() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert('<a y=\"rev\"><b>first</b><b x=\"1\">second</b></a>', xml) columns x integer default -1 path '@x' , val string path '../@y') as x";
        List[] expected = new List[]{Arrays.asList(-1, "rev"), Arrays.asList(1, "rev")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableReturnXml() throws Exception {
        String sql = "select * from xmltable('/*:a/*:b' passing convert('<a xmlns=\"http:foo\"><b>first</b><b xmlns=\"\" x=\"1\">second</b></a>', xml) columns val xml path '.') as x";
        List[] expected = new List[]{Arrays.asList("<b xmlns=\"http:foo\">first</b>"), Arrays.asList("<b x=\"1\">second</b>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableNoColumns() throws Exception {
        String sql = "select * from xmltable('/a' passing convert('<a><b>first</b><b x=\"1\">second</b></a>', xml)) as x";
        List[] expected = new List[]{Arrays.asList("<a><b>first</b><b x=\"1\">second</b></a>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTablePassing() throws Exception {
        String sql = "select * from xmltable('<root>{for $x in $a/a/b return <c>{$x}</c>}</root>' passing convert('<a><b>first</b><b x=\"1\">second</b></a>', xml) as a columns x xml path 'c[1]/b') as x";
        List[] expected = new List[]{Arrays.asList("<b>first</b>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableForOrdinalityAndDefaultPath() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert('<a><b><c>1</c></b><b>1</b><b><c>1</c></b><b>1</b></a>', xml) columns x for ordinality, c integer) as x";
        List[] expected = new List[]{Arrays.asList(1, 1), Arrays.asList(2, null), Arrays.asList(3, 1), Arrays.asList(4, null)};
        ProcessorPlan plan = this.process(sql, expected);
        Assert.assertEquals((Object)DataTypeManager.DefaultDataClasses.INTEGER, (Object)((Expression)plan.getOutputElements().get(0)).getType());
    }

    @Test
    public void testXmlTableDescendantPath() throws Exception {
        String sql = "select * from xmltable('<a>{for $i in (1 to 5) return $i}</a>' columns x string path '//text()') as x";
        List[] expected = new List[]{Arrays.asList("1 2 3 4 5")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlQuery() throws Exception {
        String sql = "select xmlquery('for $i in (1 to 5) return $i')";
        List[] expected = new List[]{Arrays.asList("1 2 3 4 5")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlExists() throws Exception {
        String sql = "select xmlexists('for $i in (1 to 1) return $i'), xmlexists('for $i in (1 to 0) return $i')";
        List[] expected = new List[]{Arrays.asList(true, false)};
        this.process(sql, expected);
    }

    @Test
    public void testXmlQueryNull() throws Exception {
        String sql = "select xmlquery('/a' passing cast(null as xml))";
        List[] expected = new List[]{Collections.singletonList(null)};
        this.process(sql, expected);
    }

    @Test
    public void testXmlQueryEmptyNull() throws Exception {
        String sql = "select xmlquery('/a' passing xmlparse(document '<x/>') null on empty)";
        List[] expected = new List[]{Arrays.asList(new String[]{null})};
        this.process(sql, expected);
    }

    @Test
    public void testXmlQueryEmptyNullString() throws Exception {
        String sql = "select xmlquery('/a/b' passing xmlparse(document '<x/>') null on empty)";
        List[] expected = new List[]{Arrays.asList(new String[]{null})};
        this.process(sql, expected);
    }

    @Test
    public void testXmlQueryStreaming() throws Exception {
        String sql = "select xmlquery('/a/b' passing xmlparse(document '<a><b x=''1''/><b x=''2''/></a>') null on empty)";
        List[] expected = new List[]{Arrays.asList("<b x=\"1\"/><b x=\"2\"/>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableStreamingTiming() throws Throwable {
        String sql = "select xmlserialize(x.object_value as string), y.x from xmltable('/a/b' passing xmlparse(document '<a><b x=''1''/><b x=''2''/></a>')) as x, (select 1 as x) as y";
        List[] expected = new List[]{Arrays.asList("<b x=\"1\"/>", 1), Arrays.asList("<b x=\"2\"/>", 1)};
        this.executeStreaming(sql, expected, -1);
    }

    @Test
    public void testXmlTableStreamingMultibatch() throws Throwable {
        String sql = "select t.* from (select xmlelement(a, xmlagg(xmlelement(b, e1))) doc from pm1.g1) as x, xmltable('/a/b' passing doc columns x string path '.') as t";
        List[] expected = new List[]{Arrays.asList("a"), Arrays.asList(""), Arrays.asList("a"), Arrays.asList("c"), Arrays.asList("b"), Arrays.asList("a")};
        dataManager.setBlockOnce();
        this.executeStreaming(sql, expected, 2);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testXmlTableStreamingTimingWithError() throws Throwable {
        String sql = "select x.x, y.x from xmltable('/a/b' passing xmlparse(document '<a><b x=''1''/><b x=''2''/></a>') columns x integer path '1 div (@x - 1)') as x, (select 1 as x) as y";
        List[] expected = new List[]{Arrays.asList(1, 1), Arrays.asList(2, 1)};
        this.executeStreaming(sql, expected, -1);
    }

    private void executeStreaming(String sql, final List<?>[] expected, int batchSize) throws Throwable {
        final CommandContext cc = TestProcessor.createCommandContext();
        if (batchSize != -1) {
            cc.setBufferManager((BufferManager)BufferManagerFactory.getTestBufferManager(0L, 1));
        }
        final ResultsFuture r = new ResultsFuture();
        Executor ex = new Executor(){

            @Override
            public void execute(Runnable command) {
                r.getResultsReceiver().receiveResults((Object)command);
            }
        };
        cc.setExecutor(ex);
        final ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), cc);
        final ResultsFuture result = new ResultsFuture();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    TestProcessor.doProcess(plan, dataManager, expected, cc);
                    result.getResultsReceiver().receiveResults(null);
                }
                catch (Throwable e) {
                    result.getResultsReceiver().exceptionOccurred(e);
                }
            }
        };
        t.start();
        Runnable runnable = (Runnable)r.get();
        runnable.run();
        try {
            result.get();
        }
        catch (ExecutionException e) {
            if (e.getCause() != null) {
                throw e.getCause();
            }
            throw e;
        }
    }

    @Test
    public void testXmlNameEscaping() throws Exception {
        String sql = "select xmlforest(\"xml\") from (select 1 as \"xml\") x";
        List[] expected = new List[]{Arrays.asList("<_u0078_ml>1</_u0078_ml>")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlParseDoc() throws Exception {
        String sql = "select xmlparse(document '<a/>')";
        List[] expected = new List[]{Arrays.asList("<a/>")};
        this.process(sql, expected);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testXmlParseDocException() throws Exception {
        String sql = "select xmlparse(document 'a<a/>')";
        List[] expected = new List[]{};
        this.process(sql, expected);
    }

    @Test
    public void testXmlParseContent() throws Exception {
        String sql = "select xmlparse(content 'a<a/>')";
        List[] expected = new List[]{Arrays.asList("a<a/>")};
        this.process(sql, expected);
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testXmlParseContentException() throws Exception {
        String sql = "select xmlparse(content 'a<')";
        List[] expected = new List[]{};
        this.process(sql, expected);
    }

    @Test
    public void testXmlParseContentWellformed() throws Exception {
        String sql = "select xmlparse(content 'a<' WELLFORMED)";
        List[] expected = new List[]{Arrays.asList("a<")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlParseClob() throws Exception {
        String sql = "select xmlparse(document cast(? as clob)) x";
        List[] expected = new List[]{Arrays.asList(ObjectConverterUtil.convertToString((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"udf.xmi"))))};
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestTextTable.clobFromFile("udf.xmi")));
    }

    @Test
    public void testXmlParseBlob() throws Exception {
        String sql = "select xmlparse(document cast(? as blob)) x";
        List[] expected = new List[]{Arrays.asList(ObjectConverterUtil.convertToString((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"udf.xmi"))))};
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestSQLXMLProcessing.blobFromFile("udf.xmi")));
    }

    @Test
    public void testXmlParseBlobWithEncoding() throws Exception {
        String sql = "select xmlparse(document cast(? as blob)) x";
        List[] expected = new List[]{Arrays.asList(ObjectConverterUtil.convertToString((Reader)new InputStreamReader((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"encoding.xml")), Charset.forName("ISO-8859-1"))))};
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(TestSQLXMLProcessing.blobFromFile("encoding.xml")));
    }

    @Test
    public void testXmlTableTypes() throws Exception {
        String sql = "select * from xmltable('/a' passing xmlparse(document '<a>2000-01-01T01:01:00.2-06:00</a>') columns x timestamp path 'xs:dateTime(./text())', y timestamp path '.') as x";
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)1, (int)0, (int)200000000);
        List[] expected = new List[]{Arrays.asList(ts, ts)};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableStreamingParentAttributes() throws Exception {
        String sql = "select * from xmltable('/a/b' passing xmlparse(document '<a x=''1''><b>foo</b></a>') columns y string path '.', x integer path '../@x') as x";
        List[] expected = new List[]{Arrays.asList("foo", 1)};
        this.process(sql, expected);
    }

    @Test
    public void testXmlStreamingError() throws Exception {
        String sql = "select * from xmltable('/a/a' passing xmlparse(document '<a><a>2000-01-01T01:01:00.2-06:00<a></a></a></a>') columns x timestamp path 'xs:dateTime(./text())') as x";
        Timestamp ts = TimestampUtil.createTimestamp((int)100, (int)0, (int)1, (int)1, (int)1, (int)0, (int)200000000);
        List[] expected = new List[]{Arrays.asList(ts)};
        this.process(sql, expected);
    }

    @Test
    public void testXmlTableSubquery() throws Exception {
        String sql = "select * from xmltable('/a/b' passing convert('<a><b>first</b><b x=\"attr\">c</b></a>', xml) columns x string path '@x', val string path '/.') as x where val = (select max(e1) from pm1.g1 as x)";
        List[] expected = new List[]{Arrays.asList("attr", "c")};
        this.process(sql, expected);
    }

    @BeforeClass
    public static void oneTimeSetUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        TestProcessor.sampleData1(dataManager);
    }

    @AfterClass
    public static void oneTimeTearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    private ProcessorPlan process(String sql, List<?>[] expected) throws Exception {
        CommandContext cc = TestProcessor.createCommandContext();
        ProcessorPlan plan = TestProcessor.helpGetPlan(TestProcessor.helpParse(sql), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), (CapabilitiesFinder)new DefaultCapabilitiesFinder(), cc);
        TestProcessor.helpProcess(plan, cc, dataManager, expected);
        return plan;
    }

    public static BlobType blobFromFile(String file) {
        return new BlobType((Blob)new BlobImpl((InputStreamFactory)new InputStreamFactory.FileInputStreamFactory(UnitTestUtil.getTestDataFile((String)file))));
    }

    @Test
    public void testXmlTableWithDefault() throws Exception {
        String sql = "select * from xmltable(XMLNAMESPACES(default 'http://x.y.com'), '/a/b' passing convert('<a xmlns=\"http://x.y.com\"><b>first</b><b x=\"attr\">second</b></a>', xml) columns x string path '@x', val string path '/.') as x";
        List[] expected = new List[]{Arrays.asList(null, "first"), Arrays.asList("attr", "second")};
        this.process(sql, expected);
    }

    @Test
    public void testXmlAggNested() throws Exception {
        String sql = "SELECT XMLELEMENT(NAME metadata, XMLFOREST(e1), (SELECT XMLAGG(XMLELEMENT(NAME subTypes, XMLFOREST(e1))) FROM pm1.g2 AS b WHERE b.e1 = a.e1)) FROM pm1.g1 AS a where e1 = 'a' GROUP BY e1";
        List[] expected = new List[]{Arrays.asList("<metadata><gcol0>a</gcol0><subTypes><e1>a</e1></subTypes><subTypes><e1>a</e1></subTypes><subTypes><e1>a</e1></subTypes></metadata>")};
        this.process(sql, expected);
    }

    @Test
    public void testJsonStreamingXmlTable() throws Exception {
        String sql = "select * from xmltable('/Person/phoneNumber' passing jsontoxml('Person', cast(? as blob)) columns x string path 'type', y string path 'number') as x";
        List[] expected = new List[]{Arrays.asList("home", "212 555-1234"), Arrays.asList("fax", "646 555-4567")};
        SerialBlob b = BlobType.createBlob((byte[])"{ \"firstName\": \"John\", \"lastName\": \"Smith\", \"age\": 25, \"address\": { \"streetAddress\": \"21 2nd Street\", \"city\": \"New York\", \"state\": \"NY\", \"postalCode\": \"10021\" }, \"phoneNumber\": [ { \"type\": \"home\", \"number\": \"212 555-1234\" }, { \"type\": \"fax\", \"number\": \"646 555-4567\" } ] }".getBytes(Charset.forName("UTF-8")));
        TestProcessor.processPreparedStatement(sql, expected, dataManager, (CapabilitiesFinder)new DefaultCapabilitiesFinder(), (QueryMetadataInterface)RealMetadataFactory.example1Cached(), Arrays.asList(b));
    }

    @Test(expected=ExpressionEvaluationException.class)
    public void testExternalEntityResolving() throws Exception {
        String sql = "SELECT xmlelement(foo, '<bar>', convert('<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE foo [<!ENTITY xxe SYSTEM \"file:///etc/passwd\">]><bar1>&xxe;</bar1>', xml))";
        this.process(sql, null);
    }

    @Test
    public void testXmlText() throws Exception {
        String sql = "SELECT xmlserialize(xmltext('foo&bar') as string)";
        List[] expected = new List[]{Arrays.asList("foo&amp;bar")};
        this.process(sql, expected);
    }

    @Test(expected=TeiidProcessingException.class)
    public void testInvalidXmlComment() throws Exception {
        String sql = "SELECT xmlcomment('--')";
        this.process(sql, null);
    }

    @Test
    public void testXmlCast() throws Exception {
        String sql = "select xmlcast(xmlquery('/a/b' passing convert('<a><b>1</b></a>', xml)) as integer)";
        List[] expected = new List[]{Collections.singletonList(1)};
        Assert.assertEquals((Object)"SELECT XMLCAST(XMLQUERY('/a/b' PASSING convert('<a><b>1</b></a>', xml)) AS integer)", (Object)TestProcessor.helpParse(sql).toString());
        this.process(sql, expected);
    }

    @Test
    public void testXmlCast1() throws Exception {
        String sql = "select xmlcast(cast('2000-01-01 00:00:00' as timestamp) as xml)";
        List[] expected = new List[]{Collections.singletonList("2000-01-01T06:00:00Z")};
        this.process(sql, expected);
    }
}

