/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.datamgr;

import junit.framework.TestCase;
import org.teiid.dqp.internal.datamgr.TstLanguageBridgeFactory;
import org.teiid.language.Comparison;
import org.teiid.language.Literal;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.Expression;

public class TestCompareCriteriaImpl
extends TestCase {
    public TestCompareCriteriaImpl(String name) {
        super(name);
    }

    public static CompareCriteria helpExample(int operator, int leftVal, int rightVal) {
        Constant left = new Constant((Object)new Integer(leftVal));
        Constant right = new Constant((Object)new Integer(rightVal));
        return new CompareCriteria((Expression)left, operator, (Expression)right);
    }

    public static Comparison example(int operator, int leftVal, int rightVal) throws Exception {
        return TstLanguageBridgeFactory.factory.translate(TestCompareCriteriaImpl.helpExample(operator, leftVal, rightVal));
    }

    public void testGetLeftExpression() throws Exception {
        Comparison impl = TestCompareCriteriaImpl.example(6, 200, 100);
        TestCompareCriteriaImpl.assertNotNull((Object)impl.getLeftExpression());
        TestCompareCriteriaImpl.assertTrue((boolean)(impl.getLeftExpression() instanceof Literal));
        TestCompareCriteriaImpl.assertEquals((Object)new Integer(200), (Object)((Literal)impl.getLeftExpression()).getValue());
    }

    public void testGetRightExpression() throws Exception {
        Comparison impl = TestCompareCriteriaImpl.example(6, 200, 100);
        TestCompareCriteriaImpl.assertNotNull((Object)impl.getRightExpression());
        TestCompareCriteriaImpl.assertTrue((boolean)(impl.getRightExpression() instanceof Literal));
        TestCompareCriteriaImpl.assertEquals((Object)new Integer(100), (Object)((Literal)impl.getRightExpression()).getValue());
    }

    public void testGetOperator() throws Exception {
        TestCompareCriteriaImpl.assertEquals((Object)Comparison.Operator.EQ, (Object)TestCompareCriteriaImpl.example(1, 200, 100).getOperator());
        TestCompareCriteriaImpl.assertEquals((Object)Comparison.Operator.GE, (Object)TestCompareCriteriaImpl.example(6, 200, 100).getOperator());
        TestCompareCriteriaImpl.assertEquals((Object)Comparison.Operator.GT, (Object)TestCompareCriteriaImpl.example(4, 200, 100).getOperator());
        TestCompareCriteriaImpl.assertEquals((Object)Comparison.Operator.LE, (Object)TestCompareCriteriaImpl.example(5, 200, 100).getOperator());
        TestCompareCriteriaImpl.assertEquals((Object)Comparison.Operator.LT, (Object)TestCompareCriteriaImpl.example(3, 200, 100).getOperator());
        TestCompareCriteriaImpl.assertEquals((Object)Comparison.Operator.NE, (Object)TestCompareCriteriaImpl.example(2, 200, 100).getOperator());
    }
}

