/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.cache.Cachable;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.dqp.internal.process.AccessInfo;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.parser.ParseInfo;

public class TestSessionAwareCache {
    @Test
    public void testSessionSpecfic() {
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        cache.put(id, FunctionMethod.Determinism.SESSION_DETERMINISTIC, (Object)result, null);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).prepare((TupleBufferCache)((BufferManager)Mockito.anyObject()));
        Object c = cache.get(id);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)0))).restore((TupleBufferCache)((BufferManager)Mockito.anyObject()));
        Assert.assertTrue((result == c ? 1 : 0) != 0);
    }

    @Test
    public void testUserSpecfic() {
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Mockito.stub((Object)result.prepare((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        Mockito.stub((Object)result.restore((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        cache.put(id, FunctionMethod.Determinism.USER_DETERMINISTIC, (Object)result, null);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).prepare((TupleBufferCache)((BufferManager)Mockito.anyObject()));
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Object c = cache.get(id);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).restore((TupleBufferCache)((BufferManager)Mockito.anyObject()));
        Assert.assertTrue((result == c ? 1 : 0) != 0);
    }

    @Test
    public void testNoScope() {
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Mockito.stub((Object)result.prepare((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        Mockito.stub((Object)result.restore((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        cache.put(id, FunctionMethod.Determinism.VDB_DETERMINISTIC, (Object)result, null);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).prepare((TupleBufferCache)((BufferManager)Mockito.anyObject()));
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Object c = cache.get(id);
        ((Cachable)Mockito.verify((Object)result, (VerificationMode)Mockito.times((int)1))).restore((TupleBufferCache)((BufferManager)Mockito.anyObject()));
        Assert.assertTrue((result == c ? 1 : 0) != 0);
    }

    @Test
    public void testVDBRemoval() {
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Mockito.stub((Object)result.prepare((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        Mockito.stub((Object)result.restore((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        cache.put(id, FunctionMethod.Determinism.VDB_DETERMINISTIC, (Object)result, null);
        Object c = cache.get(id);
        Assert.assertTrue((result == c ? 1 : 0) != 0);
        cache.clearForVDB("vdb-name", 1);
        Assert.assertNull((Object)cache.get(id));
    }

    @Test
    public void testRemove() {
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Mockito.stub((Object)result.prepare((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        Mockito.stub((Object)result.restore((TupleBufferCache)((BufferManager)Mockito.anyObject()))).toReturn((Object)true);
        id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        cache.put(id, FunctionMethod.Determinism.VDB_DETERMINISTIC, (Object)result, null);
        Object c = cache.get(id);
        Assert.assertTrue((result == c ? 1 : 0) != 0);
        Assert.assertTrue((cache.remove(id, FunctionMethod.Determinism.VDB_DETERMINISTIC) != null ? 1 : 0) != 0);
        Assert.assertNull((Object)cache.get(id));
        cache.put(id, FunctionMethod.Determinism.SESSION_DETERMINISTIC, (Object)result, null);
        Assert.assertTrue((cache.get(id) != null ? 1 : 0) != 0);
        Assert.assertTrue((cache.remove(id, FunctionMethod.Determinism.SESSION_DETERMINISTIC) != null ? 1 : 0) != 0);
        Assert.assertNull((Object)cache.get(id));
    }

    @Test
    public void testTtl() {
        SessionAwareCache cache = new SessionAwareCache("resultset", (CacheFactory)DefaultCacheFactory.INSTANCE, SessionAwareCache.Type.RESULTSET, 0);
        SessionAwareCache.CacheID id = new SessionAwareCache.CacheID(TestSessionAwareCache.buildWorkContext(), new ParseInfo(), "SELECT * FROM FOO");
        Cachable result = (Cachable)Mockito.mock(Cachable.class);
        Assert.assertNull((Object)cache.computeTtl(id, (Object)result, null));
        Assert.assertEquals((Object)1L, (Object)cache.computeTtl(id, (Object)result, Long.valueOf(1L)));
        AccessInfo ai = new AccessInfo();
        Mockito.stub((Object)result.getAccessInfo()).toReturn((Object)ai);
        Table t = new Table();
        t.setProperty("{http://www.teiid.org/ext/relational/2012}data-ttl", "2");
        ai.addAccessedObject((Object)t);
        Assert.assertEquals((Object)2L, (Object)cache.computeTtl(id, (Object)result, null));
        Table t1 = new Table();
        Schema s = new Schema();
        t1.setParent((AbstractMetadataRecord)s);
        s.setProperty("{http://www.teiid.org/ext/relational/2012}data-ttl", "0");
        ai.addAccessedObject((Object)t1);
        Assert.assertEquals((Object)0L, (Object)cache.computeTtl(id, (Object)result, null));
    }

    public static DQPWorkContext buildWorkContext() {
        DQPWorkContext workContext = new DQPWorkContext();
        SessionMetadata session = new SessionMetadata();
        workContext.setSession(session);
        session.setVDBName("vdb-name");
        session.setVDBVersion(1);
        session.setSessionId(String.valueOf(1));
        session.setUserName("foo");
        return workContext;
    }
}

